package software.amazon.awscdk.services.lambda;

/**
 * Construction properties for a Code Signing Config object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.signer.*;
 * SigningProfile signingProfile = SigningProfile.Builder.create(this, "SigningProfile")
 *         .platform(Platform.AWS_LAMBDA_SHA384_ECDSA)
 *         .build();
 * CodeSigningConfig codeSigningConfig = CodeSigningConfig.Builder.create(this, "CodeSigningConfig")
 *         .signingProfiles(List.of(signingProfile))
 *         .build();
 * Function.Builder.create(this, "Function")
 *         .codeSigningConfig(codeSigningConfig)
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-17T17:31:15.794Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CodeSigningConfigProps")
@software.amazon.jsii.Jsii.Proxy(CodeSigningConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeSigningConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of signing profiles that defines a trusted user who can sign a code package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.signer.ISigningProfile> getSigningProfiles();

    /**
     * Code signing configuration description.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Code signing configuration policy for deployment validation failure.
     * <p>
     * If you set the policy to Enforce, Lambda blocks the deployment request
     * if signature validation checks fail.
     * If you set the policy to Warn, Lambda allows the deployment and
     * creates a CloudWatch log.
     * <p>
     * Default: UntrustedArtifactOnDeployment.WARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.UntrustedArtifactOnDeployment getUntrustedArtifactOnDeployment() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeSigningConfigProps> {
        java.util.List<software.amazon.awscdk.services.signer.ISigningProfile> signingProfiles;
        java.lang.String description;
        software.amazon.awscdk.services.lambda.UntrustedArtifactOnDeployment untrustedArtifactOnDeployment;

        /**
         * Sets the value of {@link CodeSigningConfigProps#getSigningProfiles}
         * @param signingProfiles List of signing profiles that defines a trusted user who can sign a code package. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder signingProfiles(java.util.List<? extends software.amazon.awscdk.services.signer.ISigningProfile> signingProfiles) {
            this.signingProfiles = (java.util.List<software.amazon.awscdk.services.signer.ISigningProfile>)signingProfiles;
            return this;
        }

        /**
         * Sets the value of {@link CodeSigningConfigProps#getDescription}
         * @param description Code signing configuration description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CodeSigningConfigProps#getUntrustedArtifactOnDeployment}
         * @param untrustedArtifactOnDeployment Code signing configuration policy for deployment validation failure.
         *                                      If you set the policy to Enforce, Lambda blocks the deployment request
         *                                      if signature validation checks fail.
         *                                      If you set the policy to Warn, Lambda allows the deployment and
         *                                      creates a CloudWatch log.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder untrustedArtifactOnDeployment(software.amazon.awscdk.services.lambda.UntrustedArtifactOnDeployment untrustedArtifactOnDeployment) {
            this.untrustedArtifactOnDeployment = untrustedArtifactOnDeployment;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeSigningConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeSigningConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeSigningConfigProps {
        private final java.util.List<software.amazon.awscdk.services.signer.ISigningProfile> signingProfiles;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.lambda.UntrustedArtifactOnDeployment untrustedArtifactOnDeployment;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.signingProfiles = software.amazon.jsii.Kernel.get(this, "signingProfiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.signer.ISigningProfile.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.untrustedArtifactOnDeployment = software.amazon.jsii.Kernel.get(this, "untrustedArtifactOnDeployment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.UntrustedArtifactOnDeployment.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.signingProfiles = (java.util.List<software.amazon.awscdk.services.signer.ISigningProfile>)java.util.Objects.requireNonNull(builder.signingProfiles, "signingProfiles is required");
            this.description = builder.description;
            this.untrustedArtifactOnDeployment = builder.untrustedArtifactOnDeployment;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.signer.ISigningProfile> getSigningProfiles() {
            return this.signingProfiles;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.UntrustedArtifactOnDeployment getUntrustedArtifactOnDeployment() {
            return this.untrustedArtifactOnDeployment;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("signingProfiles", om.valueToTree(this.getSigningProfiles()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getUntrustedArtifactOnDeployment() != null) {
                data.set("untrustedArtifactOnDeployment", om.valueToTree(this.getUntrustedArtifactOnDeployment()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CodeSigningConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeSigningConfigProps.Jsii$Proxy that = (CodeSigningConfigProps.Jsii$Proxy) o;

            if (!signingProfiles.equals(that.signingProfiles)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.untrustedArtifactOnDeployment != null ? this.untrustedArtifactOnDeployment.equals(that.untrustedArtifactOnDeployment) : that.untrustedArtifactOnDeployment == null;
        }

        @Override
        public final int hashCode() {
            int result = this.signingProfiles.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.untrustedArtifactOnDeployment != null ? this.untrustedArtifactOnDeployment.hashCode() : 0);
            return result;
        }
    }
}
