package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda alias.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.867Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.AliasProps")
@software.amazon.jsii.Jsii.Proxy(AliasProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AliasProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of this alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAliasName();

    /**
     * Function version this alias refers to.
     * 
     * <p>Use lambda.addVersion() to obtain a new lambda version to refer to.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.IVersion getVersion();

    /**
     * Additional versions with individual weights this alias points to.
     * 
     * <p>Individual additional version weights specified here should add up to
     * (less than) one. All remaining weight is routed to the default
     * version.</p>
     * <p>For example, the config is</p>
     * <pre><code>version: &quot;1&quot;
     * additionalVersions: [{ version: &quot;2&quot;, weight: 0.05 }]
     * </code></pre>
     * <p>Then 5% of traffic will be routed to function version 2, while
     * the remaining 95% of traffic will be routed to function version 1.</p>
     * 
     * Default: No additional versions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions() {
        return null;
    }

    /**
     * Description for the alias.
     * 
     * Default: No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String aliasName;
        private software.amazon.awscdk.services.lambda.IVersion version;
        private java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions;
        private java.lang.String description;

        /**
         * Sets the value of AliasName
         * @param aliasName Name of this alias. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasName(java.lang.String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        /**
         * Sets the value of Version
         * @param version Function version this alias refers to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(software.amazon.awscdk.services.lambda.IVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of AdditionalVersions
         * @param additionalVersions Additional versions with individual weights this alias points to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalVersions(java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions) {
            this.additionalVersions = additionalVersions;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description Description for the alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AliasProps build() {
            return new Jsii$Proxy(aliasName, version, additionalVersions, description);
        }
    }

    /**
     * An implementation for {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasProps {
        private final java.lang.String aliasName;
        private final software.amazon.awscdk.services.lambda.IVersion version;
        private final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aliasName = this.jsiiGet("aliasName", java.lang.String.class);
            this.version = this.jsiiGet("version", software.amazon.awscdk.services.lambda.IVersion.class);
            this.additionalVersions = this.jsiiGet("additionalVersions", java.util.List.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String aliasName, final software.amazon.awscdk.services.lambda.IVersion version, final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions, final java.lang.String description) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aliasName = java.util.Objects.requireNonNull(aliasName, "aliasName is required");
            this.version = java.util.Objects.requireNonNull(version, "version is required");
            this.additionalVersions = additionalVersions;
            this.description = description;
        }

        @Override
        public java.lang.String getAliasName() {
            return this.aliasName;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IVersion getVersion() {
            return this.version;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions() {
            return this.additionalVersions;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aliasName", om.valueToTree(this.getAliasName()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getAdditionalVersions() != null) {
                data.set("additionalVersions", om.valueToTree(this.getAdditionalVersions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.AliasProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AliasProps.Jsii$Proxy that = (AliasProps.Jsii$Proxy) o;

            if (!aliasName.equals(that.aliasName)) return false;
            if (!version.equals(that.version)) return false;
            if (this.additionalVersions != null ? !this.additionalVersions.equals(that.additionalVersions) : that.additionalVersions != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public int hashCode() {
            int result = this.aliasName.hashCode();
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.additionalVersions != null ? this.additionalVersions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
