package software.amazon.awscdk.services.lambda;

/**
 * A CloudFormation `AWS::Lambda::Alias`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.867Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnAlias")
public class CfnAlias extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnAlias(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAlias(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CfnAlias.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Lambda::Alias`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnAlias(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.CfnAliasProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::Lambda::Alias.FunctionName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * `AWS::Lambda::Alias.FunctionName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setFunctionName(final java.lang.String value) {
        this.jsiiSet("functionName", java.util.Objects.requireNonNull(value, "functionName is required"));
    }

    /**
     * `AWS::Lambda::Alias.FunctionVersion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getFunctionVersion() {
        return this.jsiiGet("functionVersion", java.lang.String.class);
    }

    /**
     * `AWS::Lambda::Alias.FunctionVersion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setFunctionVersion(final java.lang.String value) {
        this.jsiiSet("functionVersion", java.util.Objects.requireNonNull(value, "functionVersion is required"));
    }

    /**
     * `AWS::Lambda::Alias.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::Lambda::Alias.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final java.lang.String value) {
        this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::Lambda::Alias.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::Lambda::Alias.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::Lambda::Alias.RoutingConfig`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getRoutingConfig() {
        return this.jsiiGet("routingConfig", java.lang.Object.class);
    }

    /**
     * `AWS::Lambda::Alias.RoutingConfig`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRoutingConfig(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("routingConfig", value);
    }

    /**
     * `AWS::Lambda::Alias.RoutingConfig`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRoutingConfig(final software.amazon.awscdk.services.lambda.CfnAlias.AliasRoutingConfigurationProperty value) {
        this.jsiiSet("routingConfig", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnAlias.AliasRoutingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AliasRoutingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AliasRoutingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnAlias.AliasRoutingConfigurationProperty.AdditionalVersionWeights`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html#cfn-lambda-alias-aliasroutingconfiguration-additionalversionweights
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAdditionalVersionWeights();

        /**
         * @return a {@link Builder} of {@link AliasRoutingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AliasRoutingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object additionalVersionWeights;

            /**
             * Sets the value of AdditionalVersionWeights
             * @param additionalVersionWeights `CfnAlias.AliasRoutingConfigurationProperty.AdditionalVersionWeights`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder additionalVersionWeights(software.amazon.awscdk.core.IResolvable additionalVersionWeights) {
                this.additionalVersionWeights = additionalVersionWeights;
                return this;
            }

            /**
             * Sets the value of AdditionalVersionWeights
             * @param additionalVersionWeights `CfnAlias.AliasRoutingConfigurationProperty.AdditionalVersionWeights`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder additionalVersionWeights(java.util.List<java.lang.Object> additionalVersionWeights) {
                this.additionalVersionWeights = additionalVersionWeights;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AliasRoutingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AliasRoutingConfigurationProperty build() {
                return new Jsii$Proxy(additionalVersionWeights);
            }
        }

        /**
         * An implementation for {@link AliasRoutingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasRoutingConfigurationProperty {
            private final java.lang.Object additionalVersionWeights;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalVersionWeights = this.jsiiGet("additionalVersionWeights", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object additionalVersionWeights) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalVersionWeights = java.util.Objects.requireNonNull(additionalVersionWeights, "additionalVersionWeights is required");
            }

            @Override
            public java.lang.Object getAdditionalVersionWeights() {
                return this.additionalVersionWeights;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("additionalVersionWeights", om.valueToTree(this.getAdditionalVersionWeights()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnAlias.AliasRoutingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AliasRoutingConfigurationProperty.Jsii$Proxy that = (AliasRoutingConfigurationProperty.Jsii$Proxy) o;

                return this.additionalVersionWeights.equals(that.additionalVersionWeights);
            }

            @Override
            public int hashCode() {
                int result = this.additionalVersionWeights.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnAlias.VersionWeightProperty")
    @software.amazon.jsii.Jsii.Proxy(VersionWeightProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VersionWeightProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnAlias.VersionWeightProperty.FunctionVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFunctionVersion();

        /**
         * `CfnAlias.VersionWeightProperty.FunctionWeight`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionweight
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getFunctionWeight();

        /**
         * @return a {@link Builder} of {@link VersionWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VersionWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String functionVersion;
            private java.lang.Number functionWeight;

            /**
             * Sets the value of FunctionVersion
             * @param functionVersion `CfnAlias.VersionWeightProperty.FunctionVersion`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder functionVersion(java.lang.String functionVersion) {
                this.functionVersion = functionVersion;
                return this;
            }

            /**
             * Sets the value of FunctionWeight
             * @param functionWeight `CfnAlias.VersionWeightProperty.FunctionWeight`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder functionWeight(java.lang.Number functionWeight) {
                this.functionWeight = functionWeight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VersionWeightProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VersionWeightProperty build() {
                return new Jsii$Proxy(functionVersion, functionWeight);
            }
        }

        /**
         * An implementation for {@link VersionWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersionWeightProperty {
            private final java.lang.String functionVersion;
            private final java.lang.Number functionWeight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionVersion = this.jsiiGet("functionVersion", java.lang.String.class);
                this.functionWeight = this.jsiiGet("functionWeight", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String functionVersion, final java.lang.Number functionWeight) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionVersion = java.util.Objects.requireNonNull(functionVersion, "functionVersion is required");
                this.functionWeight = java.util.Objects.requireNonNull(functionWeight, "functionWeight is required");
            }

            @Override
            public java.lang.String getFunctionVersion() {
                return this.functionVersion;
            }

            @Override
            public java.lang.Number getFunctionWeight() {
                return this.functionWeight;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionVersion", om.valueToTree(this.getFunctionVersion()));
                data.set("functionWeight", om.valueToTree(this.getFunctionWeight()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnAlias.VersionWeightProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VersionWeightProperty.Jsii$Proxy that = (VersionWeightProperty.Jsii$Proxy) o;

                if (!functionVersion.equals(that.functionVersion)) return false;
                return this.functionWeight.equals(that.functionWeight);
            }

            @Override
            public int hashCode() {
                int result = this.functionVersion.hashCode();
                result = 31 * result + (this.functionWeight.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CfnAlias}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.CfnAliasProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.CfnAliasProps.Builder();
        }

        /**
         * @return {@code this}
         * @param functionName `AWS::Lambda::Alias.FunctionName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * @return {@code this}
         * @param functionVersion `AWS::Lambda::Alias.FunctionVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder functionVersion(final java.lang.String functionVersion) {
            this.props.functionVersion(functionVersion);
            return this;
        }

        /**
         * @return {@code this}
         * @param name `AWS::Lambda::Alias.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * @return {@code this}
         * @param description `AWS::Lambda::Alias.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param routingConfig `AWS::Lambda::Alias.RoutingConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routingConfig(final software.amazon.awscdk.core.IResolvable routingConfig) {
            this.props.routingConfig(routingConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @param routingConfig `AWS::Lambda::Alias.RoutingConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routingConfig(final software.amazon.awscdk.services.lambda.CfnAlias.AliasRoutingConfigurationProperty routingConfig) {
            this.props.routingConfig(routingConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.CfnAlias}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.lambda.CfnAlias build() {
            return new software.amazon.awscdk.services.lambda.CfnAlias(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
