package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a `AWS::Lambda::Function`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.872Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnFunctionProps")
@software.amazon.jsii.Jsii.Proxy(CfnFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnFunctionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Lambda::Function.Code`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-code
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getCode();

    /**
     * `AWS::Lambda::Function.Handler`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-handler
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getHandler();

    /**
     * `AWS::Lambda::Function.Role`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRole();

    /**
     * `AWS::Lambda::Function.Runtime`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-runtime
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRuntime();

    /**
     * `AWS::Lambda::Function.DeadLetterConfig`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-deadletterconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getDeadLetterConfig() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.Environment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-environment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getEnvironment() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.FunctionName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-functionname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getFunctionName() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.KmsKeyArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-kmskeyarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.Layers`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-layers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<java.lang.String> getLayers() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.MemorySize`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-memorysize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Number getMemorySize() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.ReservedConcurrentExecutions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-reservedconcurrentexecutions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Number getReservedConcurrentExecutions() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.Timeout`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Number getTimeout() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.TracingConfig`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tracingconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getTracingConfig() {
        return null;
    }

    /**
     * `AWS::Lambda::Function.VpcConfig`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-vpcconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Object code;
        private java.lang.String handler;
        private java.lang.String role;
        private java.lang.String runtime;
        private java.lang.Object deadLetterConfig;
        private java.lang.String description;
        private java.lang.Object environment;
        private java.lang.String functionName;
        private java.lang.String kmsKeyArn;
        private java.util.List<java.lang.String> layers;
        private java.lang.Number memorySize;
        private java.lang.Number reservedConcurrentExecutions;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.Number timeout;
        private java.lang.Object tracingConfig;
        private java.lang.Object vpcConfig;

        /**
         * Sets the value of Code
         * @param code `AWS::Lambda::Function.Code`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder code(software.amazon.awscdk.services.lambda.CfnFunction.CodeProperty code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of Code
         * @param code `AWS::Lambda::Function.Code`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder code(software.amazon.awscdk.core.IResolvable code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of Handler
         * @param handler `AWS::Lambda::Function.Handler`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder handler(java.lang.String handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of Role
         * @param role `AWS::Lambda::Function.Role`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of Runtime
         * @param runtime `AWS::Lambda::Function.Runtime`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder runtime(java.lang.String runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of DeadLetterConfig
         * @param deadLetterConfig `AWS::Lambda::Function.DeadLetterConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deadLetterConfig(software.amazon.awscdk.core.IResolvable deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        /**
         * Sets the value of DeadLetterConfig
         * @param deadLetterConfig `AWS::Lambda::Function.DeadLetterConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deadLetterConfig(software.amazon.awscdk.services.lambda.CfnFunction.DeadLetterConfigProperty deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::Lambda::Function.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of Environment
         * @param environment `AWS::Lambda::Function.Environment`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of Environment
         * @param environment `AWS::Lambda::Function.Environment`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder environment(software.amazon.awscdk.services.lambda.CfnFunction.EnvironmentProperty environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of FunctionName
         * @param functionName `AWS::Lambda::Function.FunctionName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of KmsKeyArn
         * @param kmsKeyArn `AWS::Lambda::Function.KmsKeyArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of Layers
         * @param layers `AWS::Lambda::Function.Layers`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder layers(java.util.List<java.lang.String> layers) {
            this.layers = layers;
            return this;
        }

        /**
         * Sets the value of MemorySize
         * @param memorySize `AWS::Lambda::Function.MemorySize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder memorySize(java.lang.Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of ReservedConcurrentExecutions
         * @param reservedConcurrentExecutions `AWS::Lambda::Function.ReservedConcurrentExecutions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder reservedConcurrentExecutions(java.lang.Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::Lambda::Function.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of Timeout
         * @param timeout `AWS::Lambda::Function.Timeout`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder timeout(java.lang.Number timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of TracingConfig
         * @param tracingConfig `AWS::Lambda::Function.TracingConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingConfig(software.amazon.awscdk.core.IResolvable tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        /**
         * Sets the value of TracingConfig
         * @param tracingConfig `AWS::Lambda::Function.TracingConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingConfig(software.amazon.awscdk.services.lambda.CfnFunction.TracingConfigProperty tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        /**
         * Sets the value of VpcConfig
         * @param vpcConfig `AWS::Lambda::Function.VpcConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcConfig(software.amazon.awscdk.core.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of VpcConfig
         * @param vpcConfig `AWS::Lambda::Function.VpcConfig`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcConfig(software.amazon.awscdk.services.lambda.CfnFunction.VpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnFunctionProps build() {
            return new Jsii$Proxy(code, handler, role, runtime, deadLetterConfig, description, environment, functionName, kmsKeyArn, layers, memorySize, reservedConcurrentExecutions, tags, timeout, tracingConfig, vpcConfig);
        }
    }

    /**
     * An implementation for {@link CfnFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFunctionProps {
        private final java.lang.Object code;
        private final java.lang.String handler;
        private final java.lang.String role;
        private final java.lang.String runtime;
        private final java.lang.Object deadLetterConfig;
        private final java.lang.String description;
        private final java.lang.Object environment;
        private final java.lang.String functionName;
        private final java.lang.String kmsKeyArn;
        private final java.util.List<java.lang.String> layers;
        private final java.lang.Number memorySize;
        private final java.lang.Number reservedConcurrentExecutions;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Number timeout;
        private final java.lang.Object tracingConfig;
        private final java.lang.Object vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.code = this.jsiiGet("code", java.lang.Object.class);
            this.handler = this.jsiiGet("handler", java.lang.String.class);
            this.role = this.jsiiGet("role", java.lang.String.class);
            this.runtime = this.jsiiGet("runtime", java.lang.String.class);
            this.deadLetterConfig = this.jsiiGet("deadLetterConfig", java.lang.Object.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.environment = this.jsiiGet("environment", java.lang.Object.class);
            this.functionName = this.jsiiGet("functionName", java.lang.String.class);
            this.kmsKeyArn = this.jsiiGet("kmsKeyArn", java.lang.String.class);
            this.layers = this.jsiiGet("layers", java.util.List.class);
            this.memorySize = this.jsiiGet("memorySize", java.lang.Number.class);
            this.reservedConcurrentExecutions = this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
            this.timeout = this.jsiiGet("timeout", java.lang.Number.class);
            this.tracingConfig = this.jsiiGet("tracingConfig", java.lang.Object.class);
            this.vpcConfig = this.jsiiGet("vpcConfig", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object code, final java.lang.String handler, final java.lang.String role, final java.lang.String runtime, final java.lang.Object deadLetterConfig, final java.lang.String description, final java.lang.Object environment, final java.lang.String functionName, final java.lang.String kmsKeyArn, final java.util.List<java.lang.String> layers, final java.lang.Number memorySize, final java.lang.Number reservedConcurrentExecutions, final java.util.List<software.amazon.awscdk.core.CfnTag> tags, final java.lang.Number timeout, final java.lang.Object tracingConfig, final java.lang.Object vpcConfig) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.code = java.util.Objects.requireNonNull(code, "code is required");
            this.handler = java.util.Objects.requireNonNull(handler, "handler is required");
            this.role = java.util.Objects.requireNonNull(role, "role is required");
            this.runtime = java.util.Objects.requireNonNull(runtime, "runtime is required");
            this.deadLetterConfig = deadLetterConfig;
            this.description = description;
            this.environment = environment;
            this.functionName = functionName;
            this.kmsKeyArn = kmsKeyArn;
            this.layers = layers;
            this.memorySize = memorySize;
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            this.tags = tags;
            this.timeout = timeout;
            this.tracingConfig = tracingConfig;
            this.vpcConfig = vpcConfig;
        }

        @Override
        public java.lang.Object getCode() {
            return this.code;
        }

        @Override
        public java.lang.String getHandler() {
            return this.handler;
        }

        @Override
        public java.lang.String getRole() {
            return this.role;
        }

        @Override
        public java.lang.String getRuntime() {
            return this.runtime;
        }

        @Override
        public java.lang.Object getDeadLetterConfig() {
            return this.deadLetterConfig;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Object getEnvironment() {
            return this.environment;
        }

        @Override
        public java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public java.util.List<java.lang.String> getLayers() {
            return this.layers;
        }

        @Override
        public java.lang.Number getMemorySize() {
            return this.memorySize;
        }

        @Override
        public java.lang.Number getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Number getTimeout() {
            return this.timeout;
        }

        @Override
        public java.lang.Object getTracingConfig() {
            return this.tracingConfig;
        }

        @Override
        public java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("code", om.valueToTree(this.getCode()));
            data.set("handler", om.valueToTree(this.getHandler()));
            data.set("role", om.valueToTree(this.getRole()));
            data.set("runtime", om.valueToTree(this.getRuntime()));
            if (this.getDeadLetterConfig() != null) {
                data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getLayers() != null) {
                data.set("layers", om.valueToTree(this.getLayers()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getReservedConcurrentExecutions() != null) {
                data.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTracingConfig() != null) {
                data.set("tracingConfig", om.valueToTree(this.getTracingConfig()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFunctionProps.Jsii$Proxy that = (CfnFunctionProps.Jsii$Proxy) o;

            if (!code.equals(that.code)) return false;
            if (!handler.equals(that.handler)) return false;
            if (!role.equals(that.role)) return false;
            if (!runtime.equals(that.runtime)) return false;
            if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.layers != null ? !this.layers.equals(that.layers) : that.layers != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.reservedConcurrentExecutions != null ? !this.reservedConcurrentExecutions.equals(that.reservedConcurrentExecutions) : that.reservedConcurrentExecutions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.tracingConfig != null ? !this.tracingConfig.equals(that.tracingConfig) : that.tracingConfig != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public int hashCode() {
            int result = this.code.hashCode();
            result = 31 * result + (this.handler.hashCode());
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.runtime.hashCode());
            result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.layers != null ? this.layers.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.reservedConcurrentExecutions != null ? this.reservedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tracingConfig != null ? this.tracingConfig.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
