package software.amazon.awscdk.services.lambda;

/**
 * Construction properties for {@link CfnParametersCode}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.874Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnParametersCodeProps")
@software.amazon.jsii.Jsii.Proxy(CfnParametersCodeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnParametersCodeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CloudFormation parameter that represents the name of the S3 Bucket where the Lambda code will be located in. Must be of type 'String'.
     * 
     * Default: a new parameter will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.CfnParameter getBucketNameParam() {
        return null;
    }

    /**
     * The CloudFormation parameter that represents the path inside the S3 Bucket where the Lambda code will be located at. Must be of type 'String'.
     * 
     * Default: a new parameter will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.CfnParameter getObjectKeyParam() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnParametersCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnParametersCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.core.CfnParameter bucketNameParam;
        private software.amazon.awscdk.core.CfnParameter objectKeyParam;

        /**
         * Sets the value of BucketNameParam
         * @param bucketNameParam The CloudFormation parameter that represents the name of the S3 Bucket where the Lambda code will be located in. Must be of type 'String'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNameParam(software.amazon.awscdk.core.CfnParameter bucketNameParam) {
            this.bucketNameParam = bucketNameParam;
            return this;
        }

        /**
         * Sets the value of ObjectKeyParam
         * @param objectKeyParam The CloudFormation parameter that represents the path inside the S3 Bucket where the Lambda code will be located at. Must be of type 'String'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKeyParam(software.amazon.awscdk.core.CfnParameter objectKeyParam) {
            this.objectKeyParam = objectKeyParam;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnParametersCodeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnParametersCodeProps build() {
            return new Jsii$Proxy(bucketNameParam, objectKeyParam);
        }
    }

    /**
     * An implementation for {@link CfnParametersCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnParametersCodeProps {
        private final software.amazon.awscdk.core.CfnParameter bucketNameParam;
        private final software.amazon.awscdk.core.CfnParameter objectKeyParam;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketNameParam = this.jsiiGet("bucketNameParam", software.amazon.awscdk.core.CfnParameter.class);
            this.objectKeyParam = this.jsiiGet("objectKeyParam", software.amazon.awscdk.core.CfnParameter.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.core.CfnParameter bucketNameParam, final software.amazon.awscdk.core.CfnParameter objectKeyParam) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketNameParam = bucketNameParam;
            this.objectKeyParam = objectKeyParam;
        }

        @Override
        public software.amazon.awscdk.core.CfnParameter getBucketNameParam() {
            return this.bucketNameParam;
        }

        @Override
        public software.amazon.awscdk.core.CfnParameter getObjectKeyParam() {
            return this.objectKeyParam;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucketNameParam() != null) {
                data.set("bucketNameParam", om.valueToTree(this.getBucketNameParam()));
            }
            if (this.getObjectKeyParam() != null) {
                data.set("objectKeyParam", om.valueToTree(this.getObjectKeyParam()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnParametersCodeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnParametersCodeProps.Jsii$Proxy that = (CfnParametersCodeProps.Jsii$Proxy) o;

            if (this.bucketNameParam != null ? !this.bucketNameParam.equals(that.bucketNameParam) : that.bucketNameParam != null) return false;
            return this.objectKeyParam != null ? this.objectKeyParam.equals(that.objectKeyParam) : that.objectKeyParam == null;
        }

        @Override
        public int hashCode() {
            int result = this.bucketNameParam != null ? this.bucketNameParam.hashCode() : 0;
            result = 31 * result + (this.objectKeyParam != null ? this.objectKeyParam.hashCode() : 0);
            return result;
        }
    }
}
