package software.amazon.awscdk.services.lambda;

/**
 * Defines a Lambda EventSourceMapping resource.
 * 
 * <p>Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:</p>
 * <pre><code>import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 * lambda.addEventSource(new SqsEventSource(sqs));
 * </code></pre>
 * <p>The <code>SqsEventSource</code> class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.875Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.EventSourceMapping")
public class EventSourceMapping extends software.amazon.awscdk.core.Resource {

    protected EventSourceMapping(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventSourceMapping(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventSourceMapping(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.EventSourceMappingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.EventSourceMapping}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.EventSourceMappingProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.EventSourceMappingProps.Builder();
        }

        /**
         * @return {@code this}
         * @param eventSourceArn The Amazon Resource Name (ARN) of the event source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceArn(final java.lang.String eventSourceArn) {
            this.props.eventSourceArn(eventSourceArn);
            return this;
        }

        /**
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * @return {@code this}
         * @param enabled Set to false to disable the event source upon creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. Maximum of Duration.minutes(5). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(final software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * @return {@code this}
         * @param startingPosition The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * @return {@code this}
         * @param target The target AWS Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.lambda.IFunction target) {
            this.props.target(target);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.EventSourceMapping}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.EventSourceMapping build() {
            return new software.amazon.awscdk.services.lambda.EventSourceMapping(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
