package software.amazon.awscdk.services.lambda;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.876Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.EventSourceMappingOptions")
@software.amazon.jsii.Jsii.Proxy(EventSourceMappingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventSourceMappingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the event source.
     * 
     * <p>Any record added to
     * this stream can invoke the Lambda function.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getEventSourceArn();

    /**
     * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
     * 
     * <p>Your function receives an
     * event with all the retrieved records.</p>
     * <p>Valid Range: Minimum value of 1. Maximum value of 10000.</p>
     * 
     * Default: - Amazon Kinesis and Amazon DynamoDB is 100 records.
     * Both the default and maximum for Amazon SQS are 10 messages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getBatchSize() {
        return null;
    }

    /**
     * Set to false to disable the event source upon creation.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The maximum amount of time to gather records before invoking the function. Maximum of Duration.minutes(5).
     * 
     * Default: Duration.seconds(0)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
        return null;
    }

    /**
     * The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading.
     * 
     * Default: - Required for Amazon Kinesis and Amazon DynamoDB Streams sources.
     * 
     * @see https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String eventSourceArn;
        private java.lang.Number batchSize;
        private java.lang.Boolean enabled;
        private software.amazon.awscdk.core.Duration maxBatchingWindow;
        private software.amazon.awscdk.services.lambda.StartingPosition startingPosition;

        /**
         * Sets the value of EventSourceArn
         * @param eventSourceArn The Amazon Resource Name (ARN) of the event source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceArn(java.lang.String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        /**
         * Sets the value of BatchSize
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of Enabled
         * @param enabled Set to false to disable the event source upon creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of MaxBatchingWindow
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. Maximum of Duration.minutes(5).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Sets the value of StartingPosition
         * @param startingPosition The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventSourceMappingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public EventSourceMappingOptions build() {
            return new Jsii$Proxy(eventSourceArn, batchSize, enabled, maxBatchingWindow, startingPosition);
        }
    }

    /**
     * An implementation for {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceMappingOptions {
        private final java.lang.String eventSourceArn;
        private final java.lang.Number batchSize;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.core.Duration maxBatchingWindow;
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventSourceArn = this.jsiiGet("eventSourceArn", java.lang.String.class);
            this.batchSize = this.jsiiGet("batchSize", java.lang.Number.class);
            this.enabled = this.jsiiGet("enabled", java.lang.Boolean.class);
            this.maxBatchingWindow = this.jsiiGet("maxBatchingWindow", software.amazon.awscdk.core.Duration.class);
            this.startingPosition = this.jsiiGet("startingPosition", software.amazon.awscdk.services.lambda.StartingPosition.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String eventSourceArn, final java.lang.Number batchSize, final java.lang.Boolean enabled, final software.amazon.awscdk.core.Duration maxBatchingWindow, final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventSourceArn = java.util.Objects.requireNonNull(eventSourceArn, "eventSourceArn is required");
            this.batchSize = batchSize;
            this.enabled = enabled;
            this.maxBatchingWindow = maxBatchingWindow;
            this.startingPosition = startingPosition;
        }

        @Override
        public java.lang.String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventSourceArn", om.valueToTree(this.getEventSourceArn()));
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }
            if (this.getStartingPosition() != null) {
                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.EventSourceMappingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventSourceMappingOptions.Jsii$Proxy that = (EventSourceMappingOptions.Jsii$Proxy) o;

            if (!eventSourceArn.equals(that.eventSourceArn)) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.maxBatchingWindow != null ? !this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow != null) return false;
            return this.startingPosition != null ? this.startingPosition.equals(that.startingPosition) : that.startingPosition == null;
        }

        @Override
        public int hashCode() {
            int result = this.eventSourceArn.hashCode();
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
            return result;
        }
    }
}
