package software.amazon.awscdk.services.lambda;

/**
 * Deploys a file from from inside the construct library as a function.
 * 
 * <p>The supplied file is subject to the 4096 bytes limit of being embedded in a
 * CloudFormation template.</p>
 * <p>The construct includes an associated role with the lambda.</p>
 * <p>This construct does not yet reproduce all features from the underlying resource
 * library.</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.876Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.Function")
public class Function extends software.amazon.awscdk.services.lambda.FunctionBase {

    protected Function(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Function(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Function(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.FunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param functionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.IFunction fromFunctionArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String functionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "fromFunctionArn", software.amazon.awscdk.services.lambda.IFunction.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(functionArn, "functionArn is required") });
    }

    /**
     * Creates a Lambda function object which represents a function not defined within this stack.
     * 
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the lambda construct. This parameter is required.
     * @param attrs the attributes of the function to import. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.IFunction fromFunctionAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.FunctionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "fromFunctionAttributes", software.amazon.awscdk.services.lambda.IFunction.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Return the given named metric for this Lambda.
     * 
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAll(final java.lang.String metricName, final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAll", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Lambda.
     * 
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAll(final java.lang.String metricName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAll", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the number of concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllConcurrentExecutions(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllConcurrentExecutions() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the Duration executing all Lambdas.
     * 
     * Default: average over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllDuration(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllDuration", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the Duration executing all Lambdas.
     * 
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllDuration() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllDuration", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of Errors executing all Lambdas.
     * 
     * Default: sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllErrors", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of Errors executing all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllErrors", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllInvocations(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllInvocations", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllInvocations() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllInvocations", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of throttled invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottles(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllThrottles", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of throttled invocations of all Lambdas.
     * 
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottles() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllThrottles", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of unreserved concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     * 
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllUnreservedConcurrentExecutions(final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllUnreservedConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of unreserved concurrent executions across all Lambdas.
     * 
     * Default: max over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.cloudwatch.Metric metricAllUnreservedConcurrentExecutions() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Function.class, "metricAllUnreservedConcurrentExecutions", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Adds an environment variable to this Lambda function. If this is a ref to a Lambda function, this operation results in a no-op.
     * 
     * @param key The environment variable key. This parameter is required.
     * @param value The environment variable's value. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Function addEnvironment(final java.lang.String key, final java.lang.String value) {
        return this.jsiiCall("addEnvironment", software.amazon.awscdk.services.lambda.Function.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Adds one or more Lambda Layers to this Lambda function.
     * 
     * @param layers the layers to be added. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLayers(final software.amazon.awscdk.services.lambda.ILayerVersion... layers) {
        this.jsiiCall("addLayers", Void.class, java.util.Arrays.<Object>stream(layers).toArray(Object[]::new));
    }

    /**
     * Add a new version for this Lambda.
     * 
     * <p>If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.</p>
     * <p>All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.</p>
     * 
     * @return A new Version object.
     * @param name A unique name for this version. This parameter is required.
     * @param codeSha256 The SHA-256 hash of the most recently deployed Lambda source code, or omit to skip validation.
     * @param description A description for this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name, final java.lang.String codeSha256, final java.lang.String description) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), codeSha256, description });
    }

    /**
     * Add a new version for this Lambda.
     * 
     * <p>If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.</p>
     * <p>All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.</p>
     * 
     * @return A new Version object.
     * @param name A unique name for this version. This parameter is required.
     * @param codeSha256 The SHA-256 hash of the most recently deployed Lambda source code, or omit to skip validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name, final java.lang.String codeSha256) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), codeSha256 });
    }

    /**
     * Add a new version for this Lambda.
     * 
     * <p>If you want to deploy through CloudFormation and use aliases, you need to
     * add a new version (with a new name) to your Lambda every time you want
     * to deploy an update. An alias can then refer to the newly created Version.</p>
     * <p>All versions should have distinct names, and you should not delete versions
     * as long as your Alias needs to refer to them.</p>
     * 
     * @return A new Version object.
     * @param name A unique name for this version. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Version addVersion(final java.lang.String name) {
        return this.jsiiCall("addVersion", software.amazon.awscdk.services.lambda.Version.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Whether the addPermission() call adds any permissions.
     * 
     * <p>True for new Lambdas, false for imported Lambdas (they might live in different accounts).</p>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getCanCreatePermissions() {
        return this.jsiiGet("canCreatePermissions", java.lang.Boolean.class);
    }

    /**
     * ARN of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFunctionArn() {
        return this.jsiiGet("functionArn", java.lang.String.class);
    }

    /**
     * Name of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * The principal this Lambda Function is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * The construct node where permissions are attached.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ConstructNode getPermissionsNode() {
        return this.jsiiGet("permissionsNode", software.amazon.awscdk.core.ConstructNode.class);
    }

    /**
     * The runtime configured for this lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
        return this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
    }

    /**
     * Execution role associated with this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.Function}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.FunctionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.FunctionProps.Builder();
        }

        /**
         * @return {@code this}
         * @param code The source code of your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.lambda.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * @return {@code this}
         * @param handler The name of the function (within your source code) that Lambda calls to start running your code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final java.lang.String handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * @return {@code this}
         * @param runtime The runtime environment for the Lambda function that you are uploading. For valid values, see the Runtime property in the AWS Lambda Developer Guide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * @return {@code this}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * @return {@code this}
         * @param deadLetterQueueEnabled Enabled DLQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(final java.lang.Boolean deadLetterQueueEnabled) {
            this.props.deadLetterQueueEnabled(deadLetterQueueEnabled);
            return this;
        }

        /**
         * @return {@code this}
         * @param description A description of the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * @return {@code this}
         * @param events Event sources for this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.props.events(events);
            return this;
        }

        /**
         * @return {@code this}
         * @param functionName A name for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * @return {@code this}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialPolicy(final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.props.initialPolicy(initialPolicy);
            return this;
        }

        /**
         * @return {@code this}
         * @param layers A list of layers to add to the function's execution environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.props.layers(layers);
            return this;
        }

        /**
         * @return {@code this}
         * @param logRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * @return {@code this}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(final software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.props.logRetentionRole(logRetentionRole);
            return this;
        }

        /**
         * @return {@code this}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function. Lambda uses this value to proportionally allocate the amount of CPU power. For more information, see Resource Model in the AWS Lambda Developer Guide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(final java.lang.Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        /**
         * @return {@code this}
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(final java.lang.Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        /**
         * @return {@code this}
         * @param role Lambda execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return {@code this}
         * @param securityGroup What security group to associate with the Lambda's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * @return {@code this}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @return {@code this}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(final software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.props.tracing(tracing);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpc VPC network to place Lambda network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpcSubnets Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.Function}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.Function build() {
            return new software.amazon.awscdk.services.lambda.Function(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
