package software.amazon.awscdk.services.lambda;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.878Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.FunctionProps")
@software.amazon.jsii.Jsii.Proxy(FunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The source code of your Lambda function.
     * 
     * <p>You can point to a file in an
     * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
     * code as inline text.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.Code getCode();

    /**
     * The name of the function (within your source code) that Lambda calls to start running your code.
     * 
     * <p>For more information, see the Handler property
     * in the AWS Lambda Developer Guide.</p>
     * <p>NOTE: If you specify your source code as inline text by specifying the
     * ZipFile property within the Code property, specify index.function_name as
     * the handler.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getHandler();

    /**
     * The runtime environment for the Lambda function that you are uploading. For valid values, see the Runtime property in the AWS Lambda Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.Runtime getRuntime();

    /**
     * Whether to allow the Lambda to send all network traffic.
     * 
     * <p>If set to false, you must individually add traffic rules to allow the
     * Lambda to connect to network targets.</p>
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * The SQS queue to use if DLQ is enabled.
     * 
     * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * Enabled DLQ.
     * 
     * <p>If <code>deadLetterQueue</code> is undefined,
     * an SQS queue with default options will be defined for your Function.</p>
     * 
     * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getDeadLetterQueueEnabled() {
        return null;
    }

    /**
     * A description of the function.
     * 
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * Key-value pairs that Lambda caches and makes available for your Lambda functions.
     * 
     * <p>Use environment variables to apply configuration changes, such
     * as test and production environment configurations, without changing your
     * Lambda function source code.</p>
     * 
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * Event sources for this function.
     * 
     * <p>You can also add event sources using <code>addEventSource</code>.</p>
     * 
     * Default: - No event sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
        return null;
    }

    /**
     * A name for the function.
     * 
     * Default: - AWS CloudFormation generates a unique physical ID and uses that
     * ID for the function's name. For more information, see Name Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getFunctionName() {
        return null;
    }

    /**
     * Initial policy statements to add to the created Lambda Role.
     * 
     * <p>You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.</p>
     * 
     * Default: - No policy statements are added to the created Lambda role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
        return null;
    }

    /**
     * A list of layers to add to the function's execution environment.
     * 
     * <p>You can configure your Lambda function to pull in
     * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
     * that can be used by mulitple functions.</p>
     * 
     * Default: - No layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * 
     * <p>When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>Infinity</code>.</p>
     * 
     * Default: - Logs never expire.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * 
     * Default: - A new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
        return null;
    }

    /**
     * The amount of memory, in MB, that is allocated to your Lambda function. Lambda uses this value to proportionally allocate the amount of CPU power. For more information, see Resource Model in the AWS Lambda Developer Guide.
     * 
     * Default: 128
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getMemorySize() {
        return null;
    }

    /**
     * The maximum of concurrent executions you want to reserve for the function.
     * 
     * Default: - No specific limit - account limit.
     * 
     * @see https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getReservedConcurrentExecutions() {
        return null;
    }

    /**
     * Lambda execution role.
     * 
     * <p>This is the role that will be assumed by the function upon execution.
     * It controls the permissions that the function will have. The Role must
     * be assumable by the 'lambda.amazonaws.com' service principal.</p>
     * 
     * Default: - A unique role will be generated for this lambda function.
     * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * What security group to associate with the Lambda's network interfaces.
     * 
     * <p>Only used if 'vpc' is supplied.</p>
     * 
     * Default: - If the function is placed within a VPC and a security group is
     * not specified, a dedicated security group will be created for this
     * function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     * 
     * <p>Because the execution time affects cost, set this value
     * based on the function's expected execution time.</p>
     * 
     * Default: Duration.seconds(3)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * Enable AWS X-Ray Tracing for Lambda Function.
     * 
     * Default: Tracing.Disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.lambda.Tracing getTracing() {
        return null;
    }

    /**
     * VPC network to place Lambda network interfaces.
     * 
     * <p>Specify this if the Lambda function needs to access resources in a VPC.</p>
     * 
     * Default: - Function is not placed within a VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Where to place the network interfaces within the VPC.
     * 
     * <p>Only used if 'vpc' is supplied. Note: internet access for Lambdas
     * requires a NAT gateway, so picking Public subnets is not allowed.</p>
     * 
     * Default: - Private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.lambda.Code code;
        private java.lang.String handler;
        private software.amazon.awscdk.services.lambda.Runtime runtime;
        private java.lang.Boolean allowAllOutbound;
        private software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private java.lang.Boolean deadLetterQueueEnabled;
        private java.lang.String description;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        private java.lang.String functionName;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        private java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        private software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private java.lang.Number memorySize;
        private java.lang.Number reservedConcurrentExecutions;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private software.amazon.awscdk.core.Duration timeout;
        private software.amazon.awscdk.services.lambda.Tracing tracing;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of Code
         * @param code The source code of your Lambda function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.lambda.Code code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of Handler
         * @param handler The name of the function (within your source code) that Lambda calls to start running your code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(java.lang.String handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of Runtime
         * @param runtime The runtime environment for the Lambda function that you are uploading. For valid values, see the Runtime property in the AWS Lambda Developer Guide. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of AllowAllOutbound
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of DeadLetterQueue
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of DeadLetterQueueEnabled
         * @param deadLetterQueueEnabled Enabled DLQ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(java.lang.Boolean deadLetterQueueEnabled) {
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of Environment
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of Events
         * @param events Event sources for this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of FunctionName
         * @param functionName A name for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of InitialPolicy
         * @param initialPolicy Initial policy statements to add to the created Lambda Role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialPolicy(java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.initialPolicy = initialPolicy;
            return this;
        }

        /**
         * Sets the value of Layers
         * @param layers A list of layers to add to the function's execution environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.layers = layers;
            return this;
        }

        /**
         * Sets the value of LogRetention
         * @param logRetention The number of days log events are kept in CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of LogRetentionRole
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.logRetentionRole = logRetentionRole;
            return this;
        }

        /**
         * Sets the value of MemorySize
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function. Lambda uses this value to proportionally allocate the amount of CPU power. For more information, see Resource Model in the AWS Lambda Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(java.lang.Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of ReservedConcurrentExecutions
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(java.lang.Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of Role
         * @param role Lambda execution role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of SecurityGroup
         * @param securityGroup What security group to associate with the Lambda's network interfaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of Timeout
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of Tracing
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.tracing = tracing;
            return this;
        }

        /**
         * Sets the value of Vpc
         * @param vpc VPC network to place Lambda network interfaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of VpcSubnets
         * @param vpcSubnets Where to place the network interfaces within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public FunctionProps build() {
            return new Jsii$Proxy(code, handler, runtime, allowAllOutbound, deadLetterQueue, deadLetterQueueEnabled, description, environment, events, functionName, initialPolicy, layers, logRetention, logRetentionRole, memorySize, reservedConcurrentExecutions, role, securityGroup, timeout, tracing, vpc, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link FunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionProps {
        private final software.amazon.awscdk.services.lambda.Code code;
        private final java.lang.String handler;
        private final software.amazon.awscdk.services.lambda.Runtime runtime;
        private final java.lang.Boolean allowAllOutbound;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.lang.Boolean deadLetterQueueEnabled;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        private final java.lang.String functionName;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        private final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private final java.lang.Number memorySize;
        private final java.lang.Number reservedConcurrentExecutions;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.core.Duration timeout;
        private final software.amazon.awscdk.services.lambda.Tracing tracing;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.code = this.jsiiGet("code", software.amazon.awscdk.services.lambda.Code.class);
            this.handler = this.jsiiGet("handler", java.lang.String.class);
            this.runtime = this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
            this.allowAllOutbound = this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
            this.deadLetterQueue = this.jsiiGet("deadLetterQueue", software.amazon.awscdk.services.sqs.IQueue.class);
            this.deadLetterQueueEnabled = this.jsiiGet("deadLetterQueueEnabled", java.lang.Boolean.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.environment = this.jsiiGet("environment", java.util.Map.class);
            this.events = this.jsiiGet("events", java.util.List.class);
            this.functionName = this.jsiiGet("functionName", java.lang.String.class);
            this.initialPolicy = this.jsiiGet("initialPolicy", java.util.List.class);
            this.layers = this.jsiiGet("layers", java.util.List.class);
            this.logRetention = this.jsiiGet("logRetention", software.amazon.awscdk.services.logs.RetentionDays.class);
            this.logRetentionRole = this.jsiiGet("logRetentionRole", software.amazon.awscdk.services.iam.IRole.class);
            this.memorySize = this.jsiiGet("memorySize", java.lang.Number.class);
            this.reservedConcurrentExecutions = this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
            this.tracing = this.jsiiGet("tracing", software.amazon.awscdk.services.lambda.Tracing.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.Code code, final java.lang.String handler, final software.amazon.awscdk.services.lambda.Runtime runtime, final java.lang.Boolean allowAllOutbound, final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue, final java.lang.Boolean deadLetterQueueEnabled, final java.lang.String description, final java.util.Map<java.lang.String, java.lang.String> environment, final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events, final java.lang.String functionName, final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy, final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers, final software.amazon.awscdk.services.logs.RetentionDays logRetention, final software.amazon.awscdk.services.iam.IRole logRetentionRole, final java.lang.Number memorySize, final java.lang.Number reservedConcurrentExecutions, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final software.amazon.awscdk.core.Duration timeout, final software.amazon.awscdk.services.lambda.Tracing tracing, final software.amazon.awscdk.services.ec2.IVpc vpc, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.code = java.util.Objects.requireNonNull(code, "code is required");
            this.handler = java.util.Objects.requireNonNull(handler, "handler is required");
            this.runtime = java.util.Objects.requireNonNull(runtime, "runtime is required");
            this.allowAllOutbound = allowAllOutbound;
            this.deadLetterQueue = deadLetterQueue;
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            this.description = description;
            this.environment = environment;
            this.events = events;
            this.functionName = functionName;
            this.initialPolicy = initialPolicy;
            this.layers = layers;
            this.logRetention = logRetention;
            this.logRetentionRole = logRetentionRole;
            this.memorySize = memorySize;
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            this.role = role;
            this.securityGroup = securityGroup;
            this.timeout = timeout;
            this.tracing = tracing;
            this.vpc = vpc;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Code getCode() {
            return this.code;
        }

        @Override
        public java.lang.String getHandler() {
            return this.handler;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
            return this.runtime;
        }

        @Override
        public java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public java.lang.Boolean getDeadLetterQueueEnabled() {
            return this.deadLetterQueueEnabled;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
            return this.events;
        }

        @Override
        public java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
            return this.initialPolicy;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
            return this.layers;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
            return this.logRetentionRole;
        }

        @Override
        public java.lang.Number getMemorySize() {
            return this.memorySize;
        }

        @Override
        public java.lang.Number getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Tracing getTracing() {
            return this.tracing;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("code", om.valueToTree(this.getCode()));
            data.set("handler", om.valueToTree(this.getHandler()));
            data.set("runtime", om.valueToTree(this.getRuntime()));
            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getDeadLetterQueueEnabled() != null) {
                data.set("deadLetterQueueEnabled", om.valueToTree(this.getDeadLetterQueueEnabled()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getInitialPolicy() != null) {
                data.set("initialPolicy", om.valueToTree(this.getInitialPolicy()));
            }
            if (this.getLayers() != null) {
                data.set("layers", om.valueToTree(this.getLayers()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getLogRetentionRole() != null) {
                data.set("logRetentionRole", om.valueToTree(this.getLogRetentionRole()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getReservedConcurrentExecutions() != null) {
                data.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTracing() != null) {
                data.set("tracing", om.valueToTree(this.getTracing()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.FunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionProps.Jsii$Proxy that = (FunctionProps.Jsii$Proxy) o;

            if (!code.equals(that.code)) return false;
            if (!handler.equals(that.handler)) return false;
            if (!runtime.equals(that.runtime)) return false;
            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.deadLetterQueueEnabled != null ? !this.deadLetterQueueEnabled.equals(that.deadLetterQueueEnabled) : that.deadLetterQueueEnabled != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.initialPolicy != null ? !this.initialPolicy.equals(that.initialPolicy) : that.initialPolicy != null) return false;
            if (this.layers != null ? !this.layers.equals(that.layers) : that.layers != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.logRetentionRole != null ? !this.logRetentionRole.equals(that.logRetentionRole) : that.logRetentionRole != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.reservedConcurrentExecutions != null ? !this.reservedConcurrentExecutions.equals(that.reservedConcurrentExecutions) : that.reservedConcurrentExecutions != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.tracing != null ? !this.tracing.equals(that.tracing) : that.tracing != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.code.hashCode();
            result = 31 * result + (this.handler.hashCode());
            result = 31 * result + (this.runtime.hashCode());
            result = 31 * result + (this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueueEnabled != null ? this.deadLetterQueueEnabled.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.initialPolicy != null ? this.initialPolicy.hashCode() : 0);
            result = 31 * result + (this.layers != null ? this.layers.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.logRetentionRole != null ? this.logRetentionRole.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.reservedConcurrentExecutions != null ? this.reservedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tracing != null ? this.tracing.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
