package software.amazon.awscdk.services.lambda;

/**
 * Defines a new Lambda Layer version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.881Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.LayerVersion")
public class LayerVersion extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.lambda.ILayerVersion {

    protected LayerVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LayerVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LayerVersion(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.LayerVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a layer version by ARN.
     * 
     * <p>Assumes it is compatible with all Lambda runtimes.</p>
     * 
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param layerVersionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.ILayerVersion fromLayerVersionArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String layerVersionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.LayerVersion.class, "fromLayerVersionArn", software.amazon.awscdk.services.lambda.ILayerVersion.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(layerVersionArn, "layerVersionArn is required") });
    }

    /**
     * Imports a Layer that has been defined externally.
     * 
     * @param scope the parent Construct that will use the imported layer. This parameter is required.
     * @param id the id of the imported layer in the construct tree. This parameter is required.
     * @param attrs the properties of the imported layer. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.ILayerVersion fromLayerVersionAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.LayerVersionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.LayerVersion.class, "fromLayerVersionAttributes", software.amazon.awscdk.services.lambda.ILayerVersion.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add permission for this layer version to specific entities.
     * 
     * <p>Usage within
     * the same account where the layer is defined is always allowed and does not
     * require calling this method. Note that the principal that creates the
     * Lambda function using the layer (for example, a CloudFormation changeset
     * execution role) also needs to have the <code>lambda:GetLayerVersion</code>
     * permission on the layer version.</p>
     * 
     * @param id This parameter is required.
     * @param permission This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addPermission(final java.lang.String id, final software.amazon.awscdk.services.lambda.LayerVersionPermission permission) {
        this.jsiiCall("addPermission", Void.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * The ARN of the Lambda Layer version that this Layer defines.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLayerVersionArn() {
        return this.jsiiGet("layerVersionArn", java.lang.String.class);
    }

    /**
     * The runtimes compatible with this Layer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.services.lambda.Runtime> getCompatibleRuntimes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.lambda.Runtime>)(this.jsiiGet("compatibleRuntimes", java.util.List.class))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.LayerVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.LayerVersionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.LayerVersionProps.Builder();
        }

        /**
         * @return {@code this}
         * @param code The content of this Layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.lambda.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * @return {@code this}
         * @param compatibleRuntimes The runtimes compatible with this Layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibleRuntimes(final java.util.List<software.amazon.awscdk.services.lambda.Runtime> compatibleRuntimes) {
            this.props.compatibleRuntimes(compatibleRuntimes);
            return this;
        }

        /**
         * @return {@code this}
         * @param description The description the this Lambda Layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param layerVersionName The name of the layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerVersionName(final java.lang.String layerVersionName) {
            this.props.layerVersionName(layerVersionName);
            return this;
        }

        /**
         * @return {@code this}
         * @param license The SPDX licence identifier or URL to the license file for this layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder license(final java.lang.String license) {
            this.props.license(license);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.LayerVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.LayerVersion build() {
            return new software.amazon.awscdk.services.lambda.LayerVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
