package software.amazon.awscdk.services.lambda;

/**
 * Construction properties for a LogRetention.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.882Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.LogRetentionProps")
@software.amazon.jsii.Jsii.Proxy(LogRetentionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogRetentionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLogGroupName();

    /**
     * The number of days log events are kept in CloudWatch Logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.logs.RetentionDays getRetention();

    /**
     * The IAM role for the Lambda function associated with the custom resource.
     * 
     * Default: - A new role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String logGroupName;
        private software.amazon.awscdk.services.logs.RetentionDays retention;
        private software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of LogGroupName
         * @param logGroupName The log group name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Sets the value of Retention
         * @param retention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Sets the value of Role
         * @param role The IAM role for the Lambda function associated with the custom resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogRetentionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LogRetentionProps build() {
            return new Jsii$Proxy(logGroupName, retention, role);
        }
    }

    /**
     * An implementation for {@link LogRetentionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogRetentionProps {
        private final java.lang.String logGroupName;
        private final software.amazon.awscdk.services.logs.RetentionDays retention;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroupName = this.jsiiGet("logGroupName", java.lang.String.class);
            this.retention = this.jsiiGet("retention", software.amazon.awscdk.services.logs.RetentionDays.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String logGroupName, final software.amazon.awscdk.services.logs.RetentionDays retention, final software.amazon.awscdk.services.iam.IRole role) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroupName = java.util.Objects.requireNonNull(logGroupName, "logGroupName is required");
            this.retention = java.util.Objects.requireNonNull(retention, "retention is required");
            this.role = role;
        }

        @Override
        public java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getRetention() {
            return this.retention;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            data.set("retention", om.valueToTree(this.getRetention()));
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.LogRetentionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogRetentionProps.Jsii$Proxy that = (LogRetentionProps.Jsii$Proxy) o;

            if (!logGroupName.equals(that.logGroupName)) return false;
            if (!retention.equals(that.retention)) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public int hashCode() {
            int result = this.logGroupName.hashCode();
            result = 31 * result + (this.retention.hashCode());
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
