package software.amazon.awscdk.services.lambda;

/**
 * A single newly-deployed version of a Lambda function.
 * 
 * <p>This object exists to--at deploy time--query the &quot;then-current&quot; version of
 * the Lambda function that it refers to. This Version object can then be
 * used in <code>Alias</code> to refer to a particular deployment of a Lambda.</p>
 * <p>This means that for every new update you deploy to your Lambda (using the
 * CDK and Aliases), you must always create a new Version object. In
 * particular, it must have a different name, so that a new resource is
 * created.</p>
 * <p>If you want to ensure that you're associating the right version with
 * the right deployment, specify the <code>codeSha256</code> property while
 * creating the `Version.</p>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.886Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.Version")
public class Version extends software.amazon.awscdk.services.lambda.QualifiedFunctionBase implements software.amazon.awscdk.services.lambda.IVersion {

    protected Version(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Version(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Version(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.VersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Construct a Version object from a Version ARN.
     * 
     * @param scope The cdk scope creating this resource. This parameter is required.
     * @param id The cdk id of this resource. This parameter is required.
     * @param versionArn The version ARN to create this version from. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.IVersion fromVersionArn(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String versionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Version.class, "fromVersionArn", software.amazon.awscdk.services.lambda.IVersion.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(versionArn, "versionArn is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.lambda.IVersion fromVersionAttributes(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.lambda.VersionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Version.class, "fromVersionAttributes", software.amazon.awscdk.services.lambda.IVersion.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Return the given named metric for this Function.
     * 
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, final software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Function.
     * 
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Whether the addPermission() call adds any permissions.
     * 
     * <p>True for new Lambdas, false for imported Lambdas (they might live in different accounts).</p>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.Boolean getCanCreatePermissions() {
        return this.jsiiGet("canCreatePermissions", java.lang.Boolean.class);
    }

    /**
     * The ARN fo the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFunctionArn() {
        return this.jsiiGet("functionArn", java.lang.String.class);
    }

    /**
     * The name of the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * The principal this Lambda Function is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * The underlying AWS Lambda function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.lambda.IFunction getLambda() {
        return this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.IFunction.class);
    }

    /**
     * The most recently deployed version of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getVersion() {
        return this.jsiiGet("version", java.lang.String.class);
    }

    /**
     * The IAM role associated with this function.
     * 
     * <p>Undefined if the function was imported without a role.</p>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.Version}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.VersionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.VersionProps.Builder();
        }

        /**
         * @return {@code this}
         * @param lambda Function to get the value of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambda(final software.amazon.awscdk.services.lambda.IFunction lambda) {
            this.props.lambda(lambda);
            return this;
        }

        /**
         * @return {@code this}
         * @param codeSha256 SHA256 of the version of the Lambda source code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSha256(final java.lang.String codeSha256) {
            this.props.codeSha256(codeSha256);
            return this;
        }

        /**
         * @return {@code this}
         * @param description Description of the version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.Version}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.Version build() {
            return new software.amazon.awscdk.services.lambda.Version(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
