package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:24.886Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.VersionProps")
@software.amazon.jsii.Jsii.Proxy(VersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Function to get the value of.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.lambda.IFunction getLambda();

    /**
     * SHA256 of the version of the Lambda source code.
     * 
     * <p>Specify to validate that you're deploying the right version.</p>
     * 
     * Default: No validation is performed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getCodeSha256() {
        return null;
    }

    /**
     * Description of the version.
     * 
     * Default: Description of the Lambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.lambda.IFunction lambda;
        private java.lang.String codeSha256;
        private java.lang.String description;

        /**
         * Sets the value of Lambda
         * @param lambda Function to get the value of. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambda(software.amazon.awscdk.services.lambda.IFunction lambda) {
            this.lambda = lambda;
            return this;
        }

        /**
         * Sets the value of CodeSha256
         * @param codeSha256 SHA256 of the version of the Lambda source code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSha256(java.lang.String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description Description of the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VersionProps build() {
            return new Jsii$Proxy(lambda, codeSha256, description);
        }
    }

    /**
     * An implementation for {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersionProps {
        private final software.amazon.awscdk.services.lambda.IFunction lambda;
        private final java.lang.String codeSha256;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lambda = this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.IFunction.class);
            this.codeSha256 = this.jsiiGet("codeSha256", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction lambda, final java.lang.String codeSha256, final java.lang.String description) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lambda = java.util.Objects.requireNonNull(lambda, "lambda is required");
            this.codeSha256 = codeSha256;
            this.description = description;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getLambda() {
            return this.lambda;
        }

        @Override
        public java.lang.String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lambda", om.valueToTree(this.getLambda()));
            if (this.getCodeSha256() != null) {
                data.set("codeSha256", om.valueToTree(this.getCodeSha256()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.VersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VersionProps.Jsii$Proxy that = (VersionProps.Jsii$Proxy) o;

            if (!lambda.equals(that.lambda)) return false;
            if (this.codeSha256 != null ? !this.codeSha256.equals(that.codeSha256) : that.codeSha256 != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public int hashCode() {
            int result = this.lambda.hashCode();
            result = 31 * result + (this.codeSha256 != null ? this.codeSha256.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
