package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a `CfnCodeSigningConfig`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnCodeSigningConfigProps cfnCodeSigningConfigProps = CfnCodeSigningConfigProps.builder()
 *         .allowedPublishers(AllowedPublishersProperty.builder()
 *                 .signingProfileVersionArns(List.of("signingProfileVersionArns"))
 *                 .build())
 *         // the properties below are optional
 *         .codeSigningPolicies(CodeSigningPoliciesProperty.builder()
 *                 .untrustedArtifactOnDeployment("untrustedArtifactOnDeployment")
 *                 .build())
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-27T09:48:17.935Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnCodeSigningConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnCodeSigningConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeSigningConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of allowed publishers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAllowedPublishers();

    /**
     * The code signing policy controls the validation failure action for signature mismatch or expiry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCodeSigningPolicies() {
        return null;
    }

    /**
     * Code signing configuration description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCodeSigningConfigProps> {
        java.lang.Object allowedPublishers;
        java.lang.Object codeSigningPolicies;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getAllowedPublishers}
         * @param allowedPublishers List of allowed publishers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPublishers(software.amazon.awscdk.core.IResolvable allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getAllowedPublishers}
         * @param allowedPublishers List of allowed publishers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPublishers(software.amazon.awscdk.services.lambda.CfnCodeSigningConfig.AllowedPublishersProperty allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getCodeSigningPolicies}
         * @param codeSigningPolicies The code signing policy controls the validation failure action for signature mismatch or expiry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningPolicies(software.amazon.awscdk.core.IResolvable codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getCodeSigningPolicies}
         * @param codeSigningPolicies The code signing policy controls the validation failure action for signature mismatch or expiry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningPolicies(software.amazon.awscdk.services.lambda.CfnCodeSigningConfig.CodeSigningPoliciesProperty codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getDescription}
         * @param description Code signing configuration description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeSigningConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCodeSigningConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeSigningConfigProps {
        private final java.lang.Object allowedPublishers;
        private final java.lang.Object codeSigningPolicies;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedPublishers = software.amazon.jsii.Kernel.get(this, "allowedPublishers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.codeSigningPolicies = software.amazon.jsii.Kernel.get(this, "codeSigningPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedPublishers = java.util.Objects.requireNonNull(builder.allowedPublishers, "allowedPublishers is required");
            this.codeSigningPolicies = builder.codeSigningPolicies;
            this.description = builder.description;
        }

        @Override
        public final java.lang.Object getAllowedPublishers() {
            return this.allowedPublishers;
        }

        @Override
        public final java.lang.Object getCodeSigningPolicies() {
            return this.codeSigningPolicies;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowedPublishers", om.valueToTree(this.getAllowedPublishers()));
            if (this.getCodeSigningPolicies() != null) {
                data.set("codeSigningPolicies", om.valueToTree(this.getCodeSigningPolicies()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnCodeSigningConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeSigningConfigProps.Jsii$Proxy that = (CfnCodeSigningConfigProps.Jsii$Proxy) o;

            if (!allowedPublishers.equals(that.allowedPublishers)) return false;
            if (this.codeSigningPolicies != null ? !this.codeSigningPolicies.equals(that.codeSigningPolicies) : that.codeSigningPolicies != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedPublishers.hashCode();
            result = 31 * result + (this.codeSigningPolicies != null ? this.codeSigningPolicies.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
