package software.amazon.awscdk.services.lambda;

/**
 * Options to add a url to a Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Can be a Function or an Alias
 * Function fn;
 * FunctionUrl fnUrl = fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.NONE)
 *         .build());
 * CfnOutput.Builder.create(this, "TheUrl")
 *         .value(fnUrl.getUrl())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-27T09:48:18.102Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.FunctionUrlOptions")
@software.amazon.jsii.Jsii.Proxy(FunctionUrlOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionUrlOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of authentication that your function URL uses.
     * <p>
     * Default: FunctionUrlAuthType.AWS_IAM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionUrlAuthType getAuthType() {
        return null;
    }

    /**
     * The cross-origin resource sharing (CORS) settings for your function URL.
     * <p>
     * Default: - No CORS configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions getCors() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FunctionUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionUrlOptions> {
        software.amazon.awscdk.services.lambda.FunctionUrlAuthType authType;
        software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions cors;

        /**
         * Sets the value of {@link FunctionUrlOptions#getAuthType}
         * @param authType The type of authentication that your function URL uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(software.amazon.awscdk.services.lambda.FunctionUrlAuthType authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlOptions#getCors}
         * @param cors The cross-origin resource sharing (CORS) settings for your function URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionUrlOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionUrlOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionUrlOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionUrlOptions {
        private final software.amazon.awscdk.services.lambda.FunctionUrlAuthType authType;
        private final software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions cors;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrlAuthType.class));
            this.cors = software.amazon.jsii.Kernel.get(this, "cors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authType = builder.authType;
            this.cors = builder.cors;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionUrlAuthType getAuthType() {
            return this.authType;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions getCors() {
            return this.cors;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthType() != null) {
                data.set("authType", om.valueToTree(this.getAuthType()));
            }
            if (this.getCors() != null) {
                data.set("cors", om.valueToTree(this.getCors()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.FunctionUrlOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionUrlOptions.Jsii$Proxy that = (FunctionUrlOptions.Jsii$Proxy) o;

            if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
            return this.cors != null ? this.cors.equals(that.cors) : that.cors == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authType != null ? this.authType.hashCode() : 0;
            result = 31 * result + (this.cors != null ? this.cors.hashCode() : 0);
            return result;
        }
    }
}
