package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda alias.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T12:03:18.633Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.AliasProps")
@software.amazon.jsii.Jsii.Proxy(AliasProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AliasProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.AliasOptions {

    /**
     * Name of this alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAliasName();

    /**
     * Function version this alias refers to.
     * <p>
     * Use lambda.addVersion() to obtain a new lambda version to refer to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getVersion();

    /**
     * @return a {@link Builder} of {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AliasProps> {
        private java.lang.String aliasName;
        private software.amazon.awscdk.services.lambda.IVersion version;
        private java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions;
        private java.lang.String description;
        private java.lang.Number provisionedConcurrentExecutions;
        private software.amazon.awscdk.core.Duration maxEventAge;
        private software.amazon.awscdk.services.lambda.IDestination onFailure;
        private software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link AliasProps#getAliasName}
         * @param aliasName Name of this alias. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasName(java.lang.String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getVersion}
         * @param version Function version this alias refers to. This parameter is required.
         *                Use lambda.addVersion() to obtain a new lambda version to refer to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(software.amazon.awscdk.services.lambda.IVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getAdditionalVersions}
         * @param additionalVersions Additional versions with individual weights this alias points to.
         *                           Individual additional version weights specified here should add up to
         *                           (less than) one. All remaining weight is routed to the default
         *                           version.
         *                           <p>
         *                           For example, the config is
         *                           <p>
         *                           <blockquote><pre>
         *                           version: "1"
         *                           additionalVersions: [{ version: "2", weight: 0.05 }]
         *                           </pre></blockquote>
         *                           <p>
         *                           Then 5% of traffic will be routed to function version 2, while
         *                           the remaining 95% of traffic will be routed to function version 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalVersions(java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions) {
            this.additionalVersions = additionalVersions;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getDescription}
         * @param description Description for the alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getProvisionedConcurrentExecutions}
         * @param provisionedConcurrentExecutions Specifies a provisioned concurrency configuration for a function's alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrentExecutions(java.lang.Number provisionedConcurrentExecutions) {
            this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum: 60 seconds
         *                    Maximum: 6 hours
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.core.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getOnFailure}
         * @param onFailure The destination for failed invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getOnSuccess}
         * @param onSuccess The destination for successful invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link AliasProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum: 0
         *                      Maximum: 2
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AliasProps build() {
            return new Jsii$Proxy(aliasName, version, additionalVersions, description, provisionedConcurrentExecutions, maxEventAge, onFailure, onSuccess, retryAttempts);
        }
    }

    /**
     * An implementation for {@link AliasProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasProps {
        private final java.lang.String aliasName;
        private final software.amazon.awscdk.services.lambda.IVersion version;
        private final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions;
        private final java.lang.String description;
        private final java.lang.Number provisionedConcurrentExecutions;
        private final software.amazon.awscdk.core.Duration maxEventAge;
        private final software.amazon.awscdk.services.lambda.IDestination onFailure;
        private final software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aliasName = this.jsiiGet("aliasName", java.lang.String.class);
            this.version = this.jsiiGet("version", software.amazon.awscdk.services.lambda.IVersion.class);
            this.additionalVersions = this.jsiiGet("additionalVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.VersionWeight.class)));
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.provisionedConcurrentExecutions = this.jsiiGet("provisionedConcurrentExecutions", java.lang.Number.class);
            this.maxEventAge = this.jsiiGet("maxEventAge", software.amazon.awscdk.core.Duration.class);
            this.onFailure = this.jsiiGet("onFailure", software.amazon.awscdk.services.lambda.IDestination.class);
            this.onSuccess = this.jsiiGet("onSuccess", software.amazon.awscdk.services.lambda.IDestination.class);
            this.retryAttempts = this.jsiiGet("retryAttempts", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String aliasName, final software.amazon.awscdk.services.lambda.IVersion version, final java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> additionalVersions, final java.lang.String description, final java.lang.Number provisionedConcurrentExecutions, final software.amazon.awscdk.core.Duration maxEventAge, final software.amazon.awscdk.services.lambda.IDestination onFailure, final software.amazon.awscdk.services.lambda.IDestination onSuccess, final java.lang.Number retryAttempts) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aliasName = java.util.Objects.requireNonNull(aliasName, "aliasName is required");
            this.version = java.util.Objects.requireNonNull(version, "version is required");
            this.additionalVersions = additionalVersions;
            this.description = description;
            this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
            this.maxEventAge = maxEventAge;
            this.onFailure = onFailure;
            this.onSuccess = onSuccess;
            this.retryAttempts = retryAttempts;
        }

        @Override
        public java.lang.String getAliasName() {
            return this.aliasName;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IVersion getVersion() {
            return this.version;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.VersionWeight> getAdditionalVersions() {
            return this.additionalVersions;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Number getProvisionedConcurrentExecutions() {
            return this.provisionedConcurrentExecutions;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
            return this.onFailure;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aliasName", om.valueToTree(this.getAliasName()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getAdditionalVersions() != null) {
                data.set("additionalVersions", om.valueToTree(this.getAdditionalVersions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getProvisionedConcurrentExecutions() != null) {
                data.set("provisionedConcurrentExecutions", om.valueToTree(this.getProvisionedConcurrentExecutions()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.AliasProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AliasProps.Jsii$Proxy that = (AliasProps.Jsii$Proxy) o;

            if (!aliasName.equals(that.aliasName)) return false;
            if (!version.equals(that.version)) return false;
            if (this.additionalVersions != null ? !this.additionalVersions.equals(that.additionalVersions) : that.additionalVersions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.provisionedConcurrentExecutions != null ? !this.provisionedConcurrentExecutions.equals(that.provisionedConcurrentExecutions) : that.provisionedConcurrentExecutions != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public int hashCode() {
            int result = this.aliasName.hashCode();
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.additionalVersions != null ? this.additionalVersions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.provisionedConcurrentExecutions != null ? this.provisionedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
