package software.amazon.awscdk.services.lambda;

/**
 * A CloudFormation `AWS::Lambda::Version`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T12:03:18.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnVersion")
public class CfnVersion extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CfnVersion.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Lambda::Version`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnVersion fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.CfnVersion.class, "fromCloudFormation", software.amazon.awscdk.services.lambda.CfnVersion.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return this.jsiiGet("attrVersion", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Lambda::Version.FunctionName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return this.jsiiGet("functionName", java.lang.String.class);
    }

    /**
     * `AWS::Lambda::Version.FunctionName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("functionName", java.util.Objects.requireNonNull(value, "functionName is required"));
    }

    /**
     * `AWS::Lambda::Version.CodeSha256`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCodeSha256() {
        return this.jsiiGet("codeSha256", java.lang.String.class);
    }

    /**
     * `AWS::Lambda::Version.CodeSha256`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCodeSha256(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("codeSha256", value);
    }

    /**
     * `AWS::Lambda::Version.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::Lambda::Version.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedConcurrencyConfig() {
        return this.jsiiGet("provisionedConcurrencyConfig", java.lang.Object.class);
    }

    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedConcurrencyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("provisionedConcurrencyConfig", value);
    }

    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedConcurrencyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CfnVersion.ProvisionedConcurrencyConfigurationProperty value) {
        this.jsiiSet("provisionedConcurrencyConfig", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.CfnVersion.ProvisionedConcurrencyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedConcurrencyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedConcurrencyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnVersion.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html#cfn-lambda-version-provisionedconcurrencyconfiguration-provisionedconcurrentexecutions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getProvisionedConcurrentExecutions();

        /**
         * @return a {@link Builder} of {@link ProvisionedConcurrencyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedConcurrencyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedConcurrencyConfigurationProperty> {
            private java.lang.Number provisionedConcurrentExecutions;

            /**
             * Sets the value of {@link ProvisionedConcurrencyConfigurationProperty#getProvisionedConcurrentExecutions}
             * @param provisionedConcurrentExecutions `CfnVersion.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedConcurrentExecutions(java.lang.Number provisionedConcurrentExecutions) {
                this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedConcurrencyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedConcurrencyConfigurationProperty build() {
                return new Jsii$Proxy(provisionedConcurrentExecutions);
            }
        }

        /**
         * An implementation for {@link ProvisionedConcurrencyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedConcurrencyConfigurationProperty {
            private final java.lang.Number provisionedConcurrentExecutions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.provisionedConcurrentExecutions = this.jsiiGet("provisionedConcurrentExecutions", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number provisionedConcurrentExecutions) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.provisionedConcurrentExecutions = java.util.Objects.requireNonNull(provisionedConcurrentExecutions, "provisionedConcurrentExecutions is required");
            }

            @Override
            public java.lang.Number getProvisionedConcurrentExecutions() {
                return this.provisionedConcurrentExecutions;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("provisionedConcurrentExecutions", om.valueToTree(this.getProvisionedConcurrentExecutions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.CfnVersion.ProvisionedConcurrencyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedConcurrencyConfigurationProperty.Jsii$Proxy that = (ProvisionedConcurrencyConfigurationProperty.Jsii$Proxy) o;

                return this.provisionedConcurrentExecutions.equals(that.provisionedConcurrentExecutions);
            }

            @Override
            public int hashCode() {
                int result = this.provisionedConcurrentExecutions.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CfnVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.CfnVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.CfnVersionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.CfnVersionProps.Builder();
        }

        /**
         * `AWS::Lambda::Version.FunctionName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
         * @param functionName `AWS::Lambda::Version.FunctionName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * `AWS::Lambda::Version.CodeSha256`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
         * @param codeSha256 `AWS::Lambda::Version.CodeSha256`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSha256(final java.lang.String codeSha256) {
            this.props.codeSha256(codeSha256);
            return this;
        }

        /**
         * `AWS::Lambda::Version.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
         * @param description `AWS::Lambda::Version.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
         * @param provisionedConcurrencyConfig `AWS::Lambda::Version.ProvisionedConcurrencyConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(final software.amazon.awscdk.core.IResolvable provisionedConcurrencyConfig) {
            this.props.provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }
        /**
         * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
         * @param provisionedConcurrencyConfig `AWS::Lambda::Version.ProvisionedConcurrencyConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrencyConfig(final software.amazon.awscdk.services.lambda.CfnVersion.ProvisionedConcurrencyConfigurationProperty provisionedConcurrencyConfig) {
            this.props.provisionedConcurrencyConfig(provisionedConcurrencyConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.CfnVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.CfnVersion build() {
            return new software.amazon.awscdk.services.lambda.CfnVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
