package software.amazon.awscdk.services.lambda;

/**
 * Options to add an EventInvokeConfig to a function.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T12:03:18.649Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.EventInvokeConfigOptions")
@software.amazon.jsii.Jsii.Proxy(EventInvokeConfigOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventInvokeConfigOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum age of a request that Lambda sends to a function for processing.
     * <p>
     * Minimum: 60 seconds
     * Maximum: 6 hours
     * <p>
     * Default: Duration.hours(6)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxEventAge() {
        return null;
    }

    /**
     * The destination for failed invocations.
     * <p>
     * Default: - no destination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
        return null;
    }

    /**
     * The destination for successful invocations.
     * <p>
     * Default: - no destination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
        return null;
    }

    /**
     * The maximum number of times to retry when the function returns an error.
     * <p>
     * Minimum: 0
     * Maximum: 2
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventInvokeConfigOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventInvokeConfigOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventInvokeConfigOptions> {
        private software.amazon.awscdk.core.Duration maxEventAge;
        private software.amazon.awscdk.services.lambda.IDestination onFailure;
        private software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link EventInvokeConfigOptions#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum: 60 seconds
         *                    Maximum: 6 hours
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.core.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link EventInvokeConfigOptions#getOnFailure}
         * @param onFailure The destination for failed invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link EventInvokeConfigOptions#getOnSuccess}
         * @param onSuccess The destination for successful invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link EventInvokeConfigOptions#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum: 0
         *                      Maximum: 2
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventInvokeConfigOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventInvokeConfigOptions build() {
            return new Jsii$Proxy(maxEventAge, onFailure, onSuccess, retryAttempts);
        }
    }

    /**
     * An implementation for {@link EventInvokeConfigOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventInvokeConfigOptions {
        private final software.amazon.awscdk.core.Duration maxEventAge;
        private final software.amazon.awscdk.services.lambda.IDestination onFailure;
        private final software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxEventAge = this.jsiiGet("maxEventAge", software.amazon.awscdk.core.Duration.class);
            this.onFailure = this.jsiiGet("onFailure", software.amazon.awscdk.services.lambda.IDestination.class);
            this.onSuccess = this.jsiiGet("onSuccess", software.amazon.awscdk.services.lambda.IDestination.class);
            this.retryAttempts = this.jsiiGet("retryAttempts", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.core.Duration maxEventAge, final software.amazon.awscdk.services.lambda.IDestination onFailure, final software.amazon.awscdk.services.lambda.IDestination onSuccess, final java.lang.Number retryAttempts) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxEventAge = maxEventAge;
            this.onFailure = onFailure;
            this.onSuccess = onSuccess;
            this.retryAttempts = retryAttempts;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
            return this.onFailure;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.EventInvokeConfigOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventInvokeConfigOptions.Jsii$Proxy that = (EventInvokeConfigOptions.Jsii$Proxy) o;

            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public int hashCode() {
            int result = this.maxEventAge != null ? this.maxEventAge.hashCode() : 0;
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
