package software.amazon.awscdk.services.lambda;

/**
 * Properties for a new Lambda version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T12:03:18.686Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.VersionProps")
@software.amazon.jsii.Jsii.Proxy(VersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VersionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.VersionOptions {

    /**
     * Function to get the value of.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getLambda();

    /**
     * @return a {@link Builder} of {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VersionProps> {
        private software.amazon.awscdk.services.lambda.IFunction lambda;
        private java.lang.String codeSha256;
        private java.lang.String description;
        private java.lang.Number provisionedConcurrentExecutions;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private software.amazon.awscdk.core.Duration maxEventAge;
        private software.amazon.awscdk.services.lambda.IDestination onFailure;
        private software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link VersionProps#getLambda}
         * @param lambda Function to get the value of. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambda(software.amazon.awscdk.services.lambda.IFunction lambda) {
            this.lambda = lambda;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getCodeSha256}
         * @param codeSha256 SHA256 of the version of the Lambda source code.
         *                   Specify to validate that you're deploying the right version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSha256(java.lang.String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getDescription}
         * @param description Description of the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getProvisionedConcurrentExecutions}
         * @param provisionedConcurrentExecutions Specifies a provisioned concurrency configuration for a function's version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrentExecutions(java.lang.Number provisionedConcurrentExecutions) {
            this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getRemovalPolicy}
         * @param removalPolicy Whether to retain old versions of this function when a new version is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum: 60 seconds
         *                    Maximum: 6 hours
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.core.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getOnFailure}
         * @param onFailure The destination for failed invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getOnSuccess}
         * @param onSuccess The destination for successful invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link VersionProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum: 0
         *                      Maximum: 2
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VersionProps build() {
            return new Jsii$Proxy(lambda, codeSha256, description, provisionedConcurrentExecutions, removalPolicy, maxEventAge, onFailure, onSuccess, retryAttempts);
        }
    }

    /**
     * An implementation for {@link VersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VersionProps {
        private final software.amazon.awscdk.services.lambda.IFunction lambda;
        private final java.lang.String codeSha256;
        private final java.lang.String description;
        private final java.lang.Number provisionedConcurrentExecutions;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.core.Duration maxEventAge;
        private final software.amazon.awscdk.services.lambda.IDestination onFailure;
        private final software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lambda = this.jsiiGet("lambda", software.amazon.awscdk.services.lambda.IFunction.class);
            this.codeSha256 = this.jsiiGet("codeSha256", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.provisionedConcurrentExecutions = this.jsiiGet("provisionedConcurrentExecutions", java.lang.Number.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.maxEventAge = this.jsiiGet("maxEventAge", software.amazon.awscdk.core.Duration.class);
            this.onFailure = this.jsiiGet("onFailure", software.amazon.awscdk.services.lambda.IDestination.class);
            this.onSuccess = this.jsiiGet("onSuccess", software.amazon.awscdk.services.lambda.IDestination.class);
            this.retryAttempts = this.jsiiGet("retryAttempts", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction lambda, final java.lang.String codeSha256, final java.lang.String description, final java.lang.Number provisionedConcurrentExecutions, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final software.amazon.awscdk.core.Duration maxEventAge, final software.amazon.awscdk.services.lambda.IDestination onFailure, final software.amazon.awscdk.services.lambda.IDestination onSuccess, final java.lang.Number retryAttempts) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lambda = java.util.Objects.requireNonNull(lambda, "lambda is required");
            this.codeSha256 = codeSha256;
            this.description = description;
            this.provisionedConcurrentExecutions = provisionedConcurrentExecutions;
            this.removalPolicy = removalPolicy;
            this.maxEventAge = maxEventAge;
            this.onFailure = onFailure;
            this.onSuccess = onSuccess;
            this.retryAttempts = retryAttempts;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IFunction getLambda() {
            return this.lambda;
        }

        @Override
        public java.lang.String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Number getProvisionedConcurrentExecutions() {
            return this.provisionedConcurrentExecutions;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
            return this.onFailure;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lambda", om.valueToTree(this.getLambda()));
            if (this.getCodeSha256() != null) {
                data.set("codeSha256", om.valueToTree(this.getCodeSha256()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getProvisionedConcurrentExecutions() != null) {
                data.set("provisionedConcurrentExecutions", om.valueToTree(this.getProvisionedConcurrentExecutions()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.VersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VersionProps.Jsii$Proxy that = (VersionProps.Jsii$Proxy) o;

            if (!lambda.equals(that.lambda)) return false;
            if (this.codeSha256 != null ? !this.codeSha256.equals(that.codeSha256) : that.codeSha256 != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.provisionedConcurrentExecutions != null ? !this.provisionedConcurrentExecutions.equals(that.provisionedConcurrentExecutions) : that.provisionedConcurrentExecutions != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public int hashCode() {
            int result = this.lambda.hashCode();
            result = 31 * result + (this.codeSha256 != null ? this.codeSha256.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.provisionedConcurrentExecutions != null ? this.provisionedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
