/**
 * <h2>AWS Lambda Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This construct library allows you to define AWS Lambda Functions.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.*;
 * import path.*;
 * 
 * Function fn = new Function(this, "MyFunction", new FunctionProps()
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromAsset(path.join(__dirname, "lambda-handler"))));
 * </pre></blockquote>
 * <p>
 * <h3>Handler Code</h3>
 * <p>
 * The <code>lambda.Code</code> class includes static convenience methods for various types of
 * runtime code.
 * <p>
 * <ul>
 * <li><code>lambda.Code.fromBucket(bucket, key[, objectVersion])</code> - specify an S3 object
 * that contains the archive of your runtime code.</li>
 * <li><code>lambda.Code.fromInline(code)</code> - inline the handle code as a string. This is
 * limited to supported runtimes and the code cannot exceed 4KiB.</li>
 * <li><code>lambda.Code.fromAsset(path)</code> - specify a directory or a .zip file in the local
 * filesystem which will be zipped and uploaded to S3 before deployment. See also
 * <a href="#Bundling-Asset-Code">bundling asset code</a>.</li>
 * </ul>
 * <p>
 * The following example shows how to define a Python function and deploy the code
 * from the local directory <code>my-lambda-handler</code> to it:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new Function(this, "MyLambda", new FunctionProps()
 *         .code(lambda.Code.fromAsset(path.join(__dirname, "my-lambda-handler")))
 *         .handler("index.main")
 *         .runtime(lambda.Runtime.getPYTHON_3_6()));
 * </pre></blockquote>
 * <p>
 * When deploying a stack that contains this code, the directory will be zip
 * archived and then uploaded to an S3 bucket, then the exact location of the S3
 * objects will be passed when the stack is deployed.
 * <p>
 * During synthesis, the CDK expects to find a directory on disk at the asset
 * directory specified. Note that we are referencing the asset directory relatively
 * to our CDK project directory. This is especially important when we want to share
 * this construct through a library. Different programming languages will have
 * different techniques for bundling resources into libraries.
 * <p>
 * <h3>Execution Role</h3>
 * <p>
 * Lambda functions assume an IAM role during execution. In CDK by default, Lambda
 * functions will use an autogenerated Role if one is not provided.
 * <p>
 * The autogenerated Role is automatically given permissions to execute the Lambda
 * function. To reference the autogenerated Role:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromAsset(path.join(__dirname, "lambda-handler")))
 * 
 *         .fn(fn).(.getRole())
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can also provide your own IAM role. Provided IAM roles will not automatically
 * be given permissions to execute the Lambda function. To provide a role and grant
 * it appropriate permissions:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromAsset(path.join(__dirname, "lambda-handler")))
 *         .role(myRole)
 *         .build();
 * 
 * myRole.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaBasicExecutionRole"));
 * myRole.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaVPCAccessExecutionRole"));
 * </pre></blockquote>
 * <p>
 * <h3>Versions and Aliases</h3>
 * <p>
 * You can use
 * <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html">versions</a>
 * to manage the deployment of your AWS Lambda functions. For example, you can
 * publish a new version of a function for beta testing without affecting users of
 * the stable production version.
 * <p>
 * The function version includes the following information:
 * <p>
 * <ul>
 * <li>The function code and all associated dependencies.</li>
 * <li>The Lambda runtime that executes the function.</li>
 * <li>All of the function settings, including the environment variables.</li>
 * <li>A unique Amazon Resource Name (ARN) to identify this version of the function.</li>
 * </ul>
 * <p>
 * You can define one or more
 * <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a>
 * for your AWS Lambda function. A Lambda alias is like a pointer to a specific
 * Lambda function version. Users can access the function version using the alias
 * ARN.
 * <p>
 * The <code>fn.currentVersion</code> property can be used to obtain a <code>lambda.Version</code>
 * resource that represents the AWS Lambda function defined in your application.
 * Any change to your function's code or configuration will result in the creation
 * of a new version resource. You can specify options for this version through the
 * <code>currentVersionOptions</code> property.
 * <p>
 * <blockquote>
 * <p>
 * The <code>currentVersion</code> property is only supported when your AWS Lambda function
 * uses either <code>lambda.Code.fromAsset</code> or <code>lambda.Code.fromInline</code>. Other types
 * of code providers (such as <code>lambda.Code.fromBucket</code>) require that you define a
 * <code>lambda.Version</code> resource directly since the CDK is unable to determine if
 * their contents had changed.
 * <p>
 * </blockquote>
 * <p>
 * The <code>version.addAlias()</code> method can be used to define an AWS Lambda alias that
 * points to a specific version.
 * <p>
 * The following example defines an alias named <code>live</code> which will always point to a
 * version that represents the function as defined in your CDK app. When you change
 * your lambda code or configuration, a new resource will be created. You can
 * specify options for the current version through the <code>currentVersionOptions</code>
 * property.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fn = Function.Builder.create(this, "MyFunction")
 *         .currentVersionOptions(Map.of(
 *                 "removalPolicy", RemovalPolicy.getRETAIN(), // retain old versions
 *                 "retryAttempts", 1))
 *         .build();
 * 
 * fn.currentVersion.addAlias("live");
 * </pre></blockquote>
 * <p>
 * <blockquote>
 * <p>
 * NOTE: The <code>fn.latestVersion</code> property returns a <code>lambda.IVersion</code> which
 * represents the <code>$LATEST</code> pseudo-version. Most AWS services require a specific
 * AWS Lambda version, and won't allow you to use <code>$LATEST</code>. Therefore, you would
 * normally want to use <code>lambda.currentVersion</code>.
 * <p>
 * </blockquote>
 * <p>
 * <h3>Layers</h3>
 * <p>
 * The <code>lambda.LayerVersion</code> class can be used to define Lambda layers and manage
 * granting permissions to other AWS accounts or organizations.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * LayerVersion layer = new LayerVersion(stack, "MyLayer", new LayerVersionProps()
 *         .code(lambda.Code.fromAsset(path.join(__dirname, "layer-code")))
 *         .compatibleRuntimes(asList(lambda.Runtime.getNODEJS_10_X()))
 *         .license("Apache-2.0")
 *         .description("A layer to test the L2 construct"));
 * 
 * // To grant usage by other AWS accounts
 * layer.addPermission("remote-account-grant", new LayerVersionPermission().accountId(awsAccountId));
 * 
 * // To grant usage to all accounts in some AWS Ogranization
 * // layer.grantUsage({ accountId: '*', organizationId });
 * 
 * // To grant usage to all accounts in some AWS Ogranization
 * // layer.grantUsage({ accountId: '*', organizationId });
 * new Function(stack, "MyLayeredLambda", new FunctionProps()
 *         .code(new InlineCode("foo"))
 *         .handler("index.handler")
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .layers(asList(layer)));
 * </pre></blockquote>
 * <p>
 * <h3>Event Rule Target</h3>
 * <p>
 * You can use an AWS Lambda function as a target for an Amazon CloudWatch event
 * rule:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.events.targets.*;
 * rule.addTarget(new LambdaFunction(myFunction));
 * </pre></blockquote>
 * <p>
 * <h3>Event Sources</h3>
 * <p>
 * AWS Lambda supports a <a href="https://docs.aws.amazon.com/lambda/latest/dg/invoking-lambda-function.html">variety of event sources</a>.
 * <p>
 * In most cases, it is possible to trigger a function as a result of an event by
 * using one of the <code>add&lt;Event&gt;Notification</code> methods on the source construct. For
 * example, the <code>s3.Bucket</code> construct has an <code>onEvent</code> method which can be used to
 * trigger a Lambda when an event, such as PutObject occurs on an S3 bucket.
 * <p>
 * An alternative way to add event sources to a function is to use <code>function.addEventSource(source)</code>.
 * This method accepts an <code>IEventSource</code> object. The module <strong>&#64;aws-cdk/aws-lambda-event-sources</strong>
 * includes classes for the various event sources supported by AWS Lambda.
 * <p>
 * For example, the following code adds an SQS queue as an event source for a function:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.eventsources.SqsEventSource;
 * fn.addEventSource(new SqsEventSource(queue));
 * </pre></blockquote>
 * <p>
 * The following code adds an S3 bucket notification as an event source:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.eventsources.S3EventSource;
 * fn.addEventSource(new S3EventSource(bucket, new S3EventSourceProps()
 *         .events(asList(s3.EventType.getOBJECT_CREATED(), s3.EventType.getOBJECT_DELETED()))
 *         .filters(asList(new NotificationKeyFilter().prefix("subdir/")))));
 * </pre></blockquote>
 * <p>
 * See the documentation for the <strong>&#64;aws-cdk/aws-lambda-event-sources</strong> module for more details.
 * <p>
 * <h3>Lambda with DLQ</h3>
 * <p>
 * A dead-letter queue can be automatically created for a Lambda function by
 * setting the <code>deadLetterQueueEnabled: true</code> configuration.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.*;
 * 
 * Function fn = new Function(this, "MyFunction", new FunctionProps()
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .deadLetterQueueEnabled(true));
 * </pre></blockquote>
 * <p>
 * It is also possible to provide a dead-letter queue instead of getting a new queue created:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.sqs.*;
 * 
 * Queue dlq = new Queue(this, "DLQ");
 * Function fn = new Function(this, "MyFunction", new FunctionProps()
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .deadLetterQueue(dlq));
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">the AWS documentation</a>
 * to learn more about AWS Lambdas and DLQs.
 * <p>
 * <h3>Lambda with X-Ray Tracing</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.*;
 * 
 * Function fn = new Function(this, "MyFunction", new FunctionProps()
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .tracing(lambda.Tracing.getACTIVE()));
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">the AWS documentation</a>
 * to learn more about AWS Lambda's X-Ray support.
 * <p>
 * <h3>Lambda with Reserved Concurrent Executions</h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.lambda.*;
 * 
 * Function fn = new Function(this, "MyFunction", new FunctionProps()
 *         .runtime(lambda.Runtime.getNODEJS_10_X())
 *         .handler("index.handler")
 *         .code(lambda.Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .reservedConcurrentExecutions(100));
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">the AWS documentation</a>
 * managing concurrency.
 * <p>
 * <h3>Log Group</h3>
 * <p>
 * Lambda functions automatically create a log group with the name <code>/aws/lambda/&lt;function-name&gt;</code> upon first execution with
 * log data set to never expire.
 * <p>
 * The <code>logRetention</code> property can be used to set a different expiration period.
 * <p>
 * It is possible to obtain the function's log group as a <code>logs.ILogGroup</code> by calling the <code>logGroup</code> property of the
 * <code>Function</code> construct.
 * <p>
 * By default, CDK uses the AWS SDK retry options when creating a log group. The <code>logRetentionRetryOptions</code> property
 * allows you to customize the maximum number of retries and base backoff duration.
 * <p>
 * <em>Note</em> that, if either <code>logRetention</code> is set or <code>logGroup</code> property is called, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html">CloudFormation custom
 * resource</a> is added
 * to the stack that pre-creates the log group as part of the stack deployment, if it already doesn't exist, and sets the
 * correct log retention period (never expire, by default).
 * <p>
 * <em>Further note</em> that, if the log group already exists and the <code>logRetention</code> is not set, the custom resource will reset
 * the log retention to never expire even if it was configured with a different value.
 * <p>
 * <h3>Singleton Function</h3>
 * <p>
 * The <code>SingletonFunction</code> construct is a way to guarantee that a lambda function will be guaranteed to be part of the stack,
 * once and only once, irrespective of how many times the construct is declared to be part of the stack. This is guaranteed
 * as long as the <code>uuid</code> property and the optional <code>lambdaPurpose</code> property stay the same whenever they're declared into the
 * stack.
 * <p>
 * A typical use case of this function is when a higher level construct needs to declare a Lambda function as part of it but
 * needs to guarantee that the function is declared once. However, a user of this higher level construct can declare it any
 * number of times and with different properties. Using <code>SingletonFunction</code> here with a fixed <code>uuid</code> will guarantee this.
 * <p>
 * For example, the <code>LogRetention</code> construct requires only one single lambda function for all different log groups whose
 * retention it seeks to manage.
 * <p>
 * <h3>Bundling Asset Code</h3>
 * <p>
 * When using <code>lambda.Code.fromAsset(path)</code> it is possible to bundle the code by running a
 * command in a Docker container. The asset path will be mounted at <code>/asset-input</code>. The
 * Docker container is responsible for putting content at <code>/asset-output</code>. The content at
 * <code>/asset-output</code> will be zipped and used as Lambda code.
 * <p>
 * Example with Python:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Function.Builder.create(this, "Function")
 *         .code(lambda.Code.fromAsset(path.join(__dirname, "my-python-handler"), Map.of(
 *                 "bundling", Map.of(
 *                         "image", lambda.Runtime.PYTHON_3_6.getBundlingDockerImage(),
 *                         "command", asList("bash", "-c", "\n        pip install -r requirements.txt -t /asset-output &amp;&amp;\n        rsync -r . /asset-output\n        ")))))
 *         .runtime(lambda.Runtime.getPYTHON_3_6())
 *         .handler("index.handler")
 *         .build();
 * </pre></blockquote>
 * <p>
 * Runtimes expose a <code>bundlingDockerImage</code> property that points to the <a href="https://hub.docker.com/r/lambci/lambda/">lambci/lambda</a> build image.
 * <p>
 * Use <code>cdk.BundlingDockerImage.fromRegistry(image)</code> to use an existing image or
 * <code>cdk.BundlingDockerImage.fromAsset(path)</code> to build a specific image:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.core.*;
 * 
 * Function.Builder.create(this, "Function")
 *         .code(lambda.Code.fromAsset("/path/to/handler", Map.of(
 *                 "bundling", Map.of(
 *                         "image", cdk.BundlingDockerImage.fromAsset("/path/to/dir/with/DockerFile", new DockerBuildOptions()
 *                                 .buildArgs(Map.of(
 *                                         "ARG1", "value1"))),
 *                         "command", asList("my", "cool", "command")))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Language-specific APIs</h3>
 * <p>
 * Language-specific higher level constructs are provided in separate modules:
 * <p>
 * <ul>
 * <li>Node.js: <a href="https://github.com/aws/aws-cdk/tree/master/packages/%40aws-cdk/aws-lambda-nodejs"><code>&#64;aws-cdk/aws-lambda-nodejs</code></a></li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.lambda;
