package software.amazon.awscdk.services.lambda;

/**
 * FileSystem configurations for the Lambda function.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-09T13:05:26.237Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.FileSystemConfig")
@software.amazon.jsii.Jsii.Proxy(FileSystemConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FileSystemConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN of the access point.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * mount path in the lambda runtime environment.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalMountPath();

    /**
     * connections object used to allow ingress traffic from lambda function.
     * <p>
     * Default: - no connections required to add extra ingress rules for Lambda function
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Connections getConnections() {
        return null;
    }

    /**
     * array of IDependable that lambda function depends on.
     * <p>
     * Default: - no dependency
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.IDependable> getDependency() {
        return null;
    }

    /**
     * additional IAM policies required for the lambda function.
     * <p>
     * Default: - no additional policies required
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicies() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileSystemConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemConfig> {
        private java.lang.String arn;
        private java.lang.String localMountPath;
        private software.amazon.awscdk.services.ec2.Connections connections;
        private java.util.List<software.amazon.awscdk.core.IDependable> dependency;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policies;

        /**
         * Sets the value of {@link FileSystemConfig#getArn}
         * @param arn ARN of the access point. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemConfig#getLocalMountPath}
         * @param localMountPath mount path in the lambda runtime environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder localMountPath(java.lang.String localMountPath) {
            this.localMountPath = localMountPath;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemConfig#getConnections}
         * @param connections connections object used to allow ingress traffic from lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connections(software.amazon.awscdk.services.ec2.Connections connections) {
            this.connections = connections;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemConfig#getDependency}
         * @param dependency array of IDependable that lambda function depends on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dependency(java.util.List<software.amazon.awscdk.core.IDependable> dependency) {
            this.dependency = dependency;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemConfig#getPolicies}
         * @param policies additional IAM policies required for the lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder policies(java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FileSystemConfig build() {
            return new Jsii$Proxy(arn, localMountPath, connections, dependency, policies);
        }
    }

    /**
     * An implementation for {@link FileSystemConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemConfig {
        private final java.lang.String arn;
        private final java.lang.String localMountPath;
        private final software.amazon.awscdk.services.ec2.Connections connections;
        private final java.util.List<software.amazon.awscdk.core.IDependable> dependency;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policies;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = this.jsiiGet("arn", java.lang.String.class);
            this.localMountPath = this.jsiiGet("localMountPath", java.lang.String.class);
            this.connections = this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
            this.dependency = this.jsiiGet("dependency", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class)));
            this.policies = this.jsiiGet("policies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String arn, final java.lang.String localMountPath, final software.amazon.awscdk.services.ec2.Connections connections, final java.util.List<software.amazon.awscdk.core.IDependable> dependency, final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policies) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = java.util.Objects.requireNonNull(arn, "arn is required");
            this.localMountPath = java.util.Objects.requireNonNull(localMountPath, "localMountPath is required");
            this.connections = connections;
            this.dependency = dependency;
            this.policies = policies;
        }

        @Override
        public java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public java.lang.String getLocalMountPath() {
            return this.localMountPath;
        }

        @Override
        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.connections;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.IDependable> getDependency() {
            return this.dependency;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicies() {
            return this.policies;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("arn", om.valueToTree(this.getArn()));
            data.set("localMountPath", om.valueToTree(this.getLocalMountPath()));
            if (this.getConnections() != null) {
                data.set("connections", om.valueToTree(this.getConnections()));
            }
            if (this.getDependency() != null) {
                data.set("dependency", om.valueToTree(this.getDependency()));
            }
            if (this.getPolicies() != null) {
                data.set("policies", om.valueToTree(this.getPolicies()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.FileSystemConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemConfig.Jsii$Proxy that = (FileSystemConfig.Jsii$Proxy) o;

            if (!arn.equals(that.arn)) return false;
            if (!localMountPath.equals(that.localMountPath)) return false;
            if (this.connections != null ? !this.connections.equals(that.connections) : that.connections != null) return false;
            if (this.dependency != null ? !this.dependency.equals(that.dependency) : that.dependency != null) return false;
            return this.policies != null ? this.policies.equals(that.policies) : that.policies == null;
        }

        @Override
        public int hashCode() {
            int result = this.arn.hashCode();
            result = 31 * result + (this.localMountPath.hashCode());
            result = 31 * result + (this.connections != null ? this.connections.hashCode() : 0);
            result = 31 * result + (this.dependency != null ? this.dependency.hashCode() : 0);
            result = 31 * result + (this.policies != null ? this.policies.hashCode() : 0);
            return result;
        }
    }
}
