package software.amazon.awscdk.services.lambda;

/**
 * Non runtime options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.8.0 (build 4a047ac)", date = "2020-07-09T13:05:26.242Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.FunctionOptions")
@software.amazon.jsii.Jsii.Proxy(FunctionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.EventInvokeConfigOptions {

    /**
     * Whether to allow the Lambda to send all network traffic.
     * <p>
     * If set to false, you must individually add traffic rules to allow the
     * Lambda to connect to network targets.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
     * <p>
     * Default: - default options as described in `VersionOptions`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.VersionOptions getCurrentVersionOptions() {
        return null;
    }

    /**
     * The SQS queue to use if DLQ is enabled.
     * <p>
     * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * Enabled DLQ.
     * <p>
     * If <code>deadLetterQueue</code> is undefined,
     * an SQS queue with default options will be defined for your Function.
     * <p>
     * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeadLetterQueueEnabled() {
        return null;
    }

    /**
     * A description of the function.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Key-value pairs that Lambda caches and makes available for your Lambda functions.
     * <p>
     * Use environment variables to apply configuration changes, such
     * as test and production environment configurations, without changing your
     * Lambda function source code.
     * <p>
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * Event sources for this function.
     * <p>
     * You can also add event sources using <code>addEventSource</code>.
     * <p>
     * Default: - No event sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
        return null;
    }

    /**
     * A name for the function.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that
     * ID for the function's name. For more information, see Name Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return null;
    }

    /**
     * Initial policy statements to add to the created Lambda Role.
     * <p>
     * You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
     * <p>
     * Default: - No policy statements are added to the created Lambda role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
        return null;
    }

    /**
     * A list of layers to add to the function's execution environment.
     * <p>
     * You can configure your Lambda function to pull in
     * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
     * that can be used by mulitple functions.
     * <p>
     * Default: - No layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * <p>
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>INFINITE</code>.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * When log retention is specified, a custom resource attempts to create the CloudWatch log group.
     * <p>
     * These options control the retry policy when interacting with CloudWatch APIs.
     * <p>
     * Default: - Default AWS SDK retry options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.LogRetentionRetryOptions getLogRetentionRetryOptions() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * <p>
     * Default: - A new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
        return null;
    }

    /**
     * The amount of memory, in MB, that is allocated to your Lambda function.
     * <p>
     * Lambda uses this value to proportionally allocate the amount of CPU
     * power. For more information, see Resource Model in the AWS Lambda
     * Developer Guide.
     * <p>
     * Default: 128
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
        return null;
    }

    /**
     * The maximum of concurrent executions you want to reserve for the function.
     * <p>
     * Default: - No specific limit - account limit.
     * <p>
     * @see https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReservedConcurrentExecutions() {
        return null;
    }

    /**
     * Lambda execution role.
     * <p>
     * This is the role that will be assumed by the function upon execution.
     * It controls the permissions that the function will have. The Role must
     * be assumable by the 'lambda.amazonaws.com' service principal.
     * <p>
     * The default Role automatically has permissions granted for Lambda execution. If you
     * provide a Role, you must add the relevant AWS managed policies yourself.
     * <p>
     * The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
     * "service-role/AWSLambdaVPCAccessExecutionRole".
     * <p>
     * Default: - A unique role will be generated for this lambda function.
     * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * What security group to associate with the Lambda's network interfaces. This property is being deprecated, consider using securityGroups instead.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Use securityGroups property instead.
     * Function constructor will throw an error if both are specified.
     * <p>
     * Default: - If the function is placed within a VPC and a security group is
     * not specified, either by this or securityGroups prop, a dedicated security
     * group will be created for this function.
     * <p>
     * @deprecated - This property is deprecated, use securityGroups instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * The list of security groups to associate with the Lambda's network interfaces.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - If the function is placed within a VPC and a security group is
     * not specified, either by this or securityGroup prop, a dedicated security
     * group will be created for this function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * The function execution time (in seconds) after which Lambda terminates the function.
     * <p>
     * Because the execution time affects cost, set this value
     * based on the function's expected execution time.
     * <p>
     * Default: Duration.seconds(3)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * Enable AWS X-Ray Tracing for Lambda Function.
     * <p>
     * Default: Tracing.Disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Tracing getTracing() {
        return null;
    }

    /**
     * VPC network to place Lambda network interfaces.
     * <p>
     * Specify this if the Lambda function needs to access resources in a VPC.
     * <p>
     * Default: - Function is not placed within a VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Where to place the network interfaces within the VPC.
     * <p>
     * Only used if 'vpc' is supplied. Note: internet access for Lambdas
     * requires a NAT gateway, so picking Public subnets is not allowed.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionOptions> {
        private java.lang.Boolean allowAllOutbound;
        private software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions;
        private software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private java.lang.Boolean deadLetterQueueEnabled;
        private java.lang.String description;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        private java.lang.String functionName;
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        private java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        private software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions;
        private software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private java.lang.Number memorySize;
        private java.lang.Number reservedConcurrentExecutions;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.core.Duration timeout;
        private software.amazon.awscdk.services.lambda.Tracing tracing;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private software.amazon.awscdk.core.Duration maxEventAge;
        private software.amazon.awscdk.services.lambda.IDestination onFailure;
        private software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link FunctionOptions#getAllowAllOutbound}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic.
         *                         If set to false, you must individually add traffic rules to allow the
         *                         Lambda to connect to network targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getCurrentVersionOptions}
         * @param currentVersionOptions Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersionOptions(software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions) {
            this.currentVersionOptions = currentVersionOptions;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getDeadLetterQueueEnabled}
         * @param deadLetterQueueEnabled Enabled DLQ.
         *                               If <code>deadLetterQueue</code> is undefined,
         *                               an SQS queue with default options will be defined for your Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueueEnabled(java.lang.Boolean deadLetterQueueEnabled) {
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getDescription}
         * @param description A description of the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getEnvironment}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions.
         *                    Use environment variables to apply configuration changes, such
         *                    as test and production environment configurations, without changing your
         *                    Lambda function source code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getEvents}
         * @param events Event sources for this function.
         *               You can also add event sources using <code>addEventSource</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getFunctionName}
         * @param functionName A name for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getInitialPolicy}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role.
         *                      You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialPolicy(java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.initialPolicy = initialPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLayers}
         * @param layers A list of layers to add to the function's execution environment.
         *               You can configure your Lambda function to pull in
         *               additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         *               that can be used by mulitple functions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layers(java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.layers = layers;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLogRetention}
         * @param logRetention The number of days log events are kept in CloudWatch Logs.
         *                     When updating
         *                     this property, unsetting it doesn't remove the log retention policy. To
         *                     remove the retention policy, set the value to <code>INFINITE</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLogRetentionRetryOptions}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         *                                 These options control the retry policy when interacting with CloudWatch APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.logRetentionRetryOptions = logRetentionRetryOptions;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getLogRetentionRole}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.logRetentionRole = logRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getMemorySize}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function.
         *                   Lambda uses this value to proportionally allocate the amount of CPU
         *                   power. For more information, see Resource Model in the AWS Lambda
         *                   Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(java.lang.Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getReservedConcurrentExecutions}
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reservedConcurrentExecutions(java.lang.Number reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getRole}
         * @param role Lambda execution role.
         *             This is the role that will be assumed by the function upon execution.
         *             It controls the permissions that the function will have. The Role must
         *             be assumable by the 'lambda.amazonaws.com' service principal.
         *             <p>
         *             The default Role automatically has permissions granted for Lambda execution. If you
         *             provide a Role, you must add the relevant AWS managed policies yourself.
         *             <p>
         *             The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
         *             "service-role/AWSLambdaVPCAccessExecutionRole".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getSecurityGroup}
         * @param securityGroup What security group to associate with the Lambda's network interfaces. This property is being deprecated, consider using securityGroups instead.
         *                      Only used if 'vpc' is supplied.
         *                      <p>
         *                      Use securityGroups property instead.
         *                      Function constructor will throw an error if both are specified.
         * @return {@code this}
         * @deprecated - This property is deprecated, use securityGroups instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getSecurityGroups}
         * @param securityGroups The list of security groups to associate with the Lambda's network interfaces.
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getTimeout}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function.
         *                Because the execution time affects cost, set this value
         *                based on the function's expected execution time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getTracing}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracing(software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.tracing = tracing;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getVpc}
         * @param vpc VPC network to place Lambda network interfaces.
         *            Specify this if the Lambda function needs to access resources in a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getVpcSubnets}
         * @param vpcSubnets Where to place the network interfaces within the VPC.
         *                   Only used if 'vpc' is supplied. Note: internet access for Lambdas
         *                   requires a NAT gateway, so picking Public subnets is not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum: 60 seconds
         *                    Maximum: 6 hours
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.core.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getOnFailure}
         * @param onFailure The destination for failed invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getOnSuccess}
         * @param onSuccess The destination for successful invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        /**
         * Sets the value of {@link FunctionOptions#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum: 0
         *                      Maximum: 2
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionOptions build() {
            return new Jsii$Proxy(allowAllOutbound, currentVersionOptions, deadLetterQueue, deadLetterQueueEnabled, description, environment, events, functionName, initialPolicy, layers, logRetention, logRetentionRetryOptions, logRetentionRole, memorySize, reservedConcurrentExecutions, role, securityGroup, securityGroups, timeout, tracing, vpc, vpcSubnets, maxEventAge, onFailure, onSuccess, retryAttempts);
        }
    }

    /**
     * An implementation for {@link FunctionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionOptions {
        private final java.lang.Boolean allowAllOutbound;
        private final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.lang.Boolean deadLetterQueueEnabled;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events;
        private final java.lang.String functionName;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy;
        private final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions;
        private final software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private final java.lang.Number memorySize;
        private final java.lang.Number reservedConcurrentExecutions;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.core.Duration timeout;
        private final software.amazon.awscdk.services.lambda.Tracing tracing;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final software.amazon.awscdk.core.Duration maxEventAge;
        private final software.amazon.awscdk.services.lambda.IDestination onFailure;
        private final software.amazon.awscdk.services.lambda.IDestination onSuccess;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
            this.currentVersionOptions = this.jsiiGet("currentVersionOptions", software.amazon.awscdk.services.lambda.VersionOptions.class);
            this.deadLetterQueue = this.jsiiGet("deadLetterQueue", software.amazon.awscdk.services.sqs.IQueue.class);
            this.deadLetterQueueEnabled = this.jsiiGet("deadLetterQueueEnabled", java.lang.Boolean.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.events = this.jsiiGet("events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSource.class)));
            this.functionName = this.jsiiGet("functionName", java.lang.String.class);
            this.initialPolicy = this.jsiiGet("initialPolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.layers = this.jsiiGet("layers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class)));
            this.logRetention = this.jsiiGet("logRetention", software.amazon.awscdk.services.logs.RetentionDays.class);
            this.logRetentionRetryOptions = this.jsiiGet("logRetentionRetryOptions", software.amazon.awscdk.services.lambda.LogRetentionRetryOptions.class);
            this.logRetentionRole = this.jsiiGet("logRetentionRole", software.amazon.awscdk.services.iam.IRole.class);
            this.memorySize = this.jsiiGet("memorySize", java.lang.Number.class);
            this.reservedConcurrentExecutions = this.jsiiGet("reservedConcurrentExecutions", java.lang.Number.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.securityGroups = this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
            this.tracing = this.jsiiGet("tracing", software.amazon.awscdk.services.lambda.Tracing.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
            this.maxEventAge = this.jsiiGet("maxEventAge", software.amazon.awscdk.core.Duration.class);
            this.onFailure = this.jsiiGet("onFailure", software.amazon.awscdk.services.lambda.IDestination.class);
            this.onSuccess = this.jsiiGet("onSuccess", software.amazon.awscdk.services.lambda.IDestination.class);
            this.retryAttempts = this.jsiiGet("retryAttempts", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean allowAllOutbound, final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions, final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue, final java.lang.Boolean deadLetterQueueEnabled, final java.lang.String description, final java.util.Map<java.lang.String, java.lang.String> environment, final java.util.List<software.amazon.awscdk.services.lambda.IEventSource> events, final java.lang.String functionName, final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy, final java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> layers, final software.amazon.awscdk.services.logs.RetentionDays logRetention, final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions, final software.amazon.awscdk.services.iam.IRole logRetentionRole, final java.lang.Number memorySize, final java.lang.Number reservedConcurrentExecutions, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.core.Duration timeout, final software.amazon.awscdk.services.lambda.Tracing tracing, final software.amazon.awscdk.services.ec2.IVpc vpc, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets, final software.amazon.awscdk.core.Duration maxEventAge, final software.amazon.awscdk.services.lambda.IDestination onFailure, final software.amazon.awscdk.services.lambda.IDestination onSuccess, final java.lang.Number retryAttempts) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = allowAllOutbound;
            this.currentVersionOptions = currentVersionOptions;
            this.deadLetterQueue = deadLetterQueue;
            this.deadLetterQueueEnabled = deadLetterQueueEnabled;
            this.description = description;
            this.environment = environment;
            this.events = events;
            this.functionName = functionName;
            this.initialPolicy = initialPolicy;
            this.layers = layers;
            this.logRetention = logRetention;
            this.logRetentionRetryOptions = logRetentionRetryOptions;
            this.logRetentionRole = logRetentionRole;
            this.memorySize = memorySize;
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            this.role = role;
            this.securityGroup = securityGroup;
            this.securityGroups = securityGroups;
            this.timeout = timeout;
            this.tracing = tracing;
            this.vpc = vpc;
            this.vpcSubnets = vpcSubnets;
            this.maxEventAge = maxEventAge;
            this.onFailure = onFailure;
            this.onSuccess = onSuccess;
            this.retryAttempts = retryAttempts;
        }

        @Override
        public java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public software.amazon.awscdk.services.lambda.VersionOptions getCurrentVersionOptions() {
            return this.currentVersionOptions;
        }

        @Override
        public software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public java.lang.Boolean getDeadLetterQueueEnabled() {
            return this.deadLetterQueueEnabled;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.IEventSource> getEvents() {
            return this.events;
        }

        @Override
        public java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getInitialPolicy() {
            return this.initialPolicy;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.lambda.ILayerVersion> getLayers() {
            return this.layers;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public software.amazon.awscdk.services.lambda.LogRetentionRetryOptions getLogRetentionRetryOptions() {
            return this.logRetentionRetryOptions;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
            return this.logRetentionRole;
        }

        @Override
        public java.lang.Number getMemorySize() {
            return this.memorySize;
        }

        @Override
        public java.lang.Number getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Tracing getTracing() {
            return this.tracing;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnFailure() {
            return this.onFailure;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IDestination getOnSuccess() {
            return this.onSuccess;
        }

        @Override
        public java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getCurrentVersionOptions() != null) {
                data.set("currentVersionOptions", om.valueToTree(this.getCurrentVersionOptions()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getDeadLetterQueueEnabled() != null) {
                data.set("deadLetterQueueEnabled", om.valueToTree(this.getDeadLetterQueueEnabled()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }
            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getInitialPolicy() != null) {
                data.set("initialPolicy", om.valueToTree(this.getInitialPolicy()));
            }
            if (this.getLayers() != null) {
                data.set("layers", om.valueToTree(this.getLayers()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getLogRetentionRetryOptions() != null) {
                data.set("logRetentionRetryOptions", om.valueToTree(this.getLogRetentionRetryOptions()));
            }
            if (this.getLogRetentionRole() != null) {
                data.set("logRetentionRole", om.valueToTree(this.getLogRetentionRole()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getReservedConcurrentExecutions() != null) {
                data.set("reservedConcurrentExecutions", om.valueToTree(this.getReservedConcurrentExecutions()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTracing() != null) {
                data.set("tracing", om.valueToTree(this.getTracing()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getOnSuccess() != null) {
                data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.FunctionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionOptions.Jsii$Proxy that = (FunctionOptions.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.currentVersionOptions != null ? !this.currentVersionOptions.equals(that.currentVersionOptions) : that.currentVersionOptions != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.deadLetterQueueEnabled != null ? !this.deadLetterQueueEnabled.equals(that.deadLetterQueueEnabled) : that.deadLetterQueueEnabled != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.initialPolicy != null ? !this.initialPolicy.equals(that.initialPolicy) : that.initialPolicy != null) return false;
            if (this.layers != null ? !this.layers.equals(that.layers) : that.layers != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.logRetentionRetryOptions != null ? !this.logRetentionRetryOptions.equals(that.logRetentionRetryOptions) : that.logRetentionRetryOptions != null) return false;
            if (this.logRetentionRole != null ? !this.logRetentionRole.equals(that.logRetentionRole) : that.logRetentionRole != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.reservedConcurrentExecutions != null ? !this.reservedConcurrentExecutions.equals(that.reservedConcurrentExecutions) : that.reservedConcurrentExecutions != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.tracing != null ? !this.tracing.equals(that.tracing) : that.tracing != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.onSuccess != null ? !this.onSuccess.equals(that.onSuccess) : that.onSuccess != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.currentVersionOptions != null ? this.currentVersionOptions.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueueEnabled != null ? this.deadLetterQueueEnabled.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.initialPolicy != null ? this.initialPolicy.hashCode() : 0);
            result = 31 * result + (this.layers != null ? this.layers.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.logRetentionRetryOptions != null ? this.logRetentionRetryOptions.hashCode() : 0);
            result = 31 * result + (this.logRetentionRole != null ? this.logRetentionRole.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.reservedConcurrentExecutions != null ? this.reservedConcurrentExecutions.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tracing != null ? this.tracing.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
