/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.lambda.$Module;
import software.amazon.awscdk.services.lambda.CfnFunction;
import software.amazon.awscdk.services.lambda.CfnFunctionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunction")
public class CfnFunction
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFunction.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnFunction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFunction(@NotNull Construct scope, @NotNull String id, @NotNull CfnFunctionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static CfnFunction fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnFunction)((Object)JsiiObject.jsiiStaticCall(CfnFunction.class, (String)"fromCloudFormation", CfnFunction.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")}));
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public Object getCode() {
        return this.jsiiGet("code", Object.class);
    }

    public void setCode(@NotNull CodeProperty value) {
        this.jsiiSet("code", Objects.requireNonNull(value, "code is required"));
    }

    public void setCode(@NotNull IResolvable value) {
        this.jsiiSet("code", Objects.requireNonNull(value, "code is required"));
    }

    @NotNull
    public String getHandler() {
        return (String)this.jsiiGet("handler", String.class);
    }

    public void setHandler(@NotNull String value) {
        this.jsiiSet("handler", Objects.requireNonNull(value, "handler is required"));
    }

    @NotNull
    public String getRole() {
        return (String)this.jsiiGet("role", String.class);
    }

    public void setRole(@NotNull String value) {
        this.jsiiSet("role", Objects.requireNonNull(value, "role is required"));
    }

    @NotNull
    public String getRuntime() {
        return (String)this.jsiiGet("runtime", String.class);
    }

    public void setRuntime(@NotNull String value) {
        this.jsiiSet("runtime", Objects.requireNonNull(value, "runtime is required"));
    }

    @Nullable
    public Object getDeadLetterConfig() {
        return this.jsiiGet("deadLetterConfig", Object.class);
    }

    public void setDeadLetterConfig(@Nullable IResolvable value) {
        this.jsiiSet("deadLetterConfig", value);
    }

    public void setDeadLetterConfig(@Nullable DeadLetterConfigProperty value) {
        this.jsiiSet("deadLetterConfig", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getEnvironment() {
        return this.jsiiGet("environment", Object.class);
    }

    public void setEnvironment(@Nullable IResolvable value) {
        this.jsiiSet("environment", value);
    }

    public void setEnvironment(@Nullable EnvironmentProperty value) {
        this.jsiiSet("environment", value);
    }

    @Nullable
    public Object getFileSystemConfigs() {
        return this.jsiiGet("fileSystemConfigs", Object.class);
    }

    public void setFileSystemConfigs(@Nullable IResolvable value) {
        this.jsiiSet("fileSystemConfigs", value);
    }

    public void setFileSystemConfigs(@Nullable List<Object> value) {
        this.jsiiSet("fileSystemConfigs", value);
    }

    @Nullable
    public String getFunctionName() {
        return (String)this.jsiiGet("functionName", String.class);
    }

    public void setFunctionName(@Nullable String value) {
        this.jsiiSet("functionName", value);
    }

    @Nullable
    public String getKmsKeyArn() {
        return (String)this.jsiiGet("kmsKeyArn", String.class);
    }

    public void setKmsKeyArn(@Nullable String value) {
        this.jsiiSet("kmsKeyArn", value);
    }

    @Nullable
    public List<String> getLayers() {
        return Optional.ofNullable((List)this.jsiiGet("layers", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setLayers(@Nullable List<String> value) {
        this.jsiiSet("layers", value);
    }

    @Nullable
    public Number getMemorySize() {
        return (Number)this.jsiiGet("memorySize", Number.class);
    }

    public void setMemorySize(@Nullable Number value) {
        this.jsiiSet("memorySize", value);
    }

    @Nullable
    public Number getReservedConcurrentExecutions() {
        return (Number)this.jsiiGet("reservedConcurrentExecutions", Number.class);
    }

    public void setReservedConcurrentExecutions(@Nullable Number value) {
        this.jsiiSet("reservedConcurrentExecutions", value);
    }

    @Nullable
    public Number getTimeout() {
        return (Number)this.jsiiGet("timeout", Number.class);
    }

    public void setTimeout(@Nullable Number value) {
        this.jsiiSet("timeout", value);
    }

    @Nullable
    public Object getTracingConfig() {
        return this.jsiiGet("tracingConfig", Object.class);
    }

    public void setTracingConfig(@Nullable IResolvable value) {
        this.jsiiSet("tracingConfig", value);
    }

    public void setTracingConfig(@Nullable TracingConfigProperty value) {
        this.jsiiSet("tracingConfig", value);
    }

    @Nullable
    public Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", Object.class);
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    public void setVpcConfig(@Nullable VpcConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFunction> {
        private final Construct scope;
        private final String id;
        private final CfnFunctionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFunctionProps.Builder();
        }

        public Builder code(CodeProperty code) {
            this.props.code(code);
            return this;
        }

        public Builder code(IResolvable code) {
            this.props.code(code);
            return this;
        }

        public Builder handler(String handler) {
            this.props.handler(handler);
            return this;
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder runtime(String runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Builder deadLetterConfig(IResolvable deadLetterConfig) {
            this.props.deadLetterConfig(deadLetterConfig);
            return this;
        }

        public Builder deadLetterConfig(DeadLetterConfigProperty deadLetterConfig) {
            this.props.deadLetterConfig(deadLetterConfig);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environment(IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environment(EnvironmentProperty environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder fileSystemConfigs(IResolvable fileSystemConfigs) {
            this.props.fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder fileSystemConfigs(List<Object> fileSystemConfigs) {
            this.props.fileSystemConfigs(fileSystemConfigs);
            return this;
        }

        public Builder functionName(String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        public Builder kmsKeyArn(String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        public Builder layers(List<String> layers) {
            this.props.layers(layers);
            return this;
        }

        public Builder memorySize(Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        public Builder reservedConcurrentExecutions(Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder tracingConfig(IResolvable tracingConfig) {
            this.props.tracingConfig(tracingConfig);
            return this;
        }

        public Builder tracingConfig(TracingConfigProperty tracingConfig) {
            this.props.tracingConfig(tracingConfig);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnFunction build() {
            return new CfnFunction(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunction.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            private List<String> securityGroupIds;
            private List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnetIds, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunction.TracingConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TracingConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TracingConfigProperty> {
            private String mode;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public TracingConfigProperty build() {
                return new Jsii.Proxy(this.mode, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunction.FileSystemConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FileSystemConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @NotNull
        public String getLocalMountPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FileSystemConfigProperty> {
            private String arn;
            private String localMountPath;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder localMountPath(String localMountPath) {
                this.localMountPath = localMountPath;
                return this;
            }

            public FileSystemConfigProperty build() {
                return new Jsii.Proxy(this.arn, this.localMountPath, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunction.EnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getVariables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentProperty> {
            private Object variables;

            public Builder variables(IResolvable variables) {
                this.variables = variables;
                return this;
            }

            public Builder variables(Map<String, String> variables) {
                this.variables = variables;
                return this;
            }

            public EnvironmentProperty build() {
                return new Jsii.Proxy(this.variables, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunction.DeadLetterConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeadLetterConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getTargetArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeadLetterConfigProperty> {
            private String targetArn;

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public DeadLetterConfigProperty build() {
                return new Jsii.Proxy(this.targetArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda.CfnFunction.CodeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Bucket() {
            return null;
        }

        @Nullable
        default public String getS3Key() {
            return null;
        }

        @Nullable
        default public String getS3ObjectVersion() {
            return null;
        }

        @Nullable
        default public String getZipFile() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeProperty> {
            private String s3Bucket;
            private String s3Key;
            private String s3ObjectVersion;
            private String zipFile;

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder s3Key(String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3ObjectVersion(String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            public Builder zipFile(String zipFile) {
                this.zipFile = zipFile;
                return this;
            }

            public CodeProperty build() {
                return new Jsii.Proxy(this.s3Bucket, this.s3Key, this.s3ObjectVersion, this.zipFile, null);
            }
        }
    }
}

