package software.amazon.awscdk.services.lambda;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:44.560Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.EventSourceMappingOptions")
@software.amazon.jsii.Jsii.Proxy(EventSourceMappingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventSourceMappingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the event source.
     * <p>
     * Any record added to
     * this stream can invoke the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEventSourceArn();

    /**
     * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
     * <p>
     * Your function receives an
     * event with all the retrieved records.
     * <p>
     * Valid Range: Minimum value of 1. Maximum value of 10000.
     * <p>
     * Default: - Amazon Kinesis, Amazon DynamoDB, and Amazon MSK is 100 records.
     * Both the default and maximum for Amazon SQS are 10 messages.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
        return null;
    }

    /**
     * If the function returns an error, split the batch in two and retry.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBisectBatchOnError() {
        return null;
    }

    /**
     * Set to false to disable the event source upon creation.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The name of the Kafka topic.
     * <p>
     * Default: - no topic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKafkaTopic() {
        return null;
    }

    /**
     * The maximum amount of time to gather records before invoking the function.
     * <p>
     * Maximum of Duration.minutes(5)
     * <p>
     * Default: Duration.seconds(0)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
        return null;
    }

    /**
     * The maximum age of a record that Lambda sends to a function for processing.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 60 seconds</li>
     * <li>Maximum value of 7 days</li>
     * </ul>
     * <p>
     * Default: - infinite or until the record expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxRecordAge() {
        return null;
    }

    /**
     * An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     * <p>
     * Default: discarded records are ignored
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
        return null;
    }

    /**
     * The number of batches to process from each shard concurrently.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 1</li>
     * <li>Maximum value of 10</li>
     * </ul>
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
        return null;
    }

    /**
     * The maximum number of times to retry when the function returns an error.
     * <p>
     * Set to <code>undefined</code> if you want lambda to keep retrying infinitely or until
     * the record expires.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 0</li>
     * <li>Maximum value of 10000</li>
     * </ul>
     * <p>
     * Default: - infinite or until the record expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return null;
    }

    /**
     * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
     * <p>
     * Default: - Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources.
     * <p>
     * @see https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventSourceMappingOptions> {
        private java.lang.String eventSourceArn;
        private java.lang.Number batchSize;
        private java.lang.Boolean bisectBatchOnError;
        private java.lang.Boolean enabled;
        private java.lang.String kafkaTopic;
        private software.amazon.awscdk.core.Duration maxBatchingWindow;
        private software.amazon.awscdk.core.Duration maxRecordAge;
        private software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private java.lang.Number parallelizationFactor;
        private java.lang.Number retryAttempts;
        private software.amazon.awscdk.services.lambda.StartingPosition startingPosition;

        /**
         * Sets the value of {@link EventSourceMappingOptions#getEventSourceArn}
         * @param eventSourceArn The Amazon Resource Name (ARN) of the event source. This parameter is required.
         *                       Any record added to
         *                       this stream can invoke the Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceArn(java.lang.String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getBatchSize}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         *                  Your function receives an
         *                  event with all the retrieved records.
         *                  <p>
         *                  Valid Range: Minimum value of 1. Maximum value of 10000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getBisectBatchOnError}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(java.lang.Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getEnabled}
         * @param enabled Set to false to disable the event source upon creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getKafkaTopic}
         * @param kafkaTopic The name of the Kafka topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaTopic(java.lang.String kafkaTopic) {
            this.kafkaTopic = kafkaTopic;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getMaxBatchingWindow}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function.
         *                          Maximum of Duration.minutes(5)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getMaxRecordAge}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing.
         *                     Valid Range:
         *                     <p>
         *                     <ul>
         *                     <li>Minimum value of 60 seconds</li>
         *                     <li>Maximum value of 7 days</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(software.amazon.awscdk.core.Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getOnFailure}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getParallelizationFactor}
         * @param parallelizationFactor The number of batches to process from each shard concurrently.
         *                              Valid Range:
         *                              <p>
         *                              <ul>
         *                              <li>Minimum value of 1</li>
         *                              <li>Maximum value of 10</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Set to <code>undefined</code> if you want lambda to keep retrying infinitely or until
         *                      the record expires.
         *                      <p>
         *                      Valid Range:
         *                      <p>
         *                      <ul>
         *                      <li>Minimum value of 0</li>
         *                      <li>Maximum value of 10000</li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link EventSourceMappingOptions#getStartingPosition}
         * @param startingPosition The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventSourceMappingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventSourceMappingOptions build() {
            return new Jsii$Proxy(eventSourceArn, batchSize, bisectBatchOnError, enabled, kafkaTopic, maxBatchingWindow, maxRecordAge, onFailure, parallelizationFactor, retryAttempts, startingPosition);
        }
    }

    /**
     * An implementation for {@link EventSourceMappingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceMappingOptions {
        private final java.lang.String eventSourceArn;
        private final java.lang.Number batchSize;
        private final java.lang.Boolean bisectBatchOnError;
        private final java.lang.Boolean enabled;
        private final java.lang.String kafkaTopic;
        private final software.amazon.awscdk.core.Duration maxBatchingWindow;
        private final software.amazon.awscdk.core.Duration maxRecordAge;
        private final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private final java.lang.Number parallelizationFactor;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventSourceArn = software.amazon.jsii.Kernel.get(this, "eventSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.bisectBatchOnError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnError", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.kafkaTopic = software.amazon.jsii.Kernel.get(this, "kafkaTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxBatchingWindow = software.amazon.jsii.Kernel.get(this, "maxBatchingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.maxRecordAge = software.amazon.jsii.Kernel.get(this, "maxRecordAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSourceDlq.class));
            this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.StartingPosition.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String eventSourceArn, final java.lang.Number batchSize, final java.lang.Boolean bisectBatchOnError, final java.lang.Boolean enabled, final java.lang.String kafkaTopic, final software.amazon.awscdk.core.Duration maxBatchingWindow, final software.amazon.awscdk.core.Duration maxRecordAge, final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure, final java.lang.Number parallelizationFactor, final java.lang.Number retryAttempts, final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventSourceArn = java.util.Objects.requireNonNull(eventSourceArn, "eventSourceArn is required");
            this.batchSize = batchSize;
            this.bisectBatchOnError = bisectBatchOnError;
            this.enabled = enabled;
            this.kafkaTopic = kafkaTopic;
            this.maxBatchingWindow = maxBatchingWindow;
            this.maxRecordAge = maxRecordAge;
            this.onFailure = onFailure;
            this.parallelizationFactor = parallelizationFactor;
            this.retryAttempts = retryAttempts;
            this.startingPosition = startingPosition;
        }

        @Override
        public final java.lang.String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final java.lang.Boolean getBisectBatchOnError() {
            return this.bisectBatchOnError;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getKafkaTopic() {
            return this.kafkaTopic;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxRecordAge() {
            return this.maxRecordAge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventSourceArn", om.valueToTree(this.getEventSourceArn()));
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getBisectBatchOnError() != null) {
                data.set("bisectBatchOnError", om.valueToTree(this.getBisectBatchOnError()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getKafkaTopic() != null) {
                data.set("kafkaTopic", om.valueToTree(this.getKafkaTopic()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }
            if (this.getMaxRecordAge() != null) {
                data.set("maxRecordAge", om.valueToTree(this.getMaxRecordAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getStartingPosition() != null) {
                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.EventSourceMappingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventSourceMappingOptions.Jsii$Proxy that = (EventSourceMappingOptions.Jsii$Proxy) o;

            if (!eventSourceArn.equals(that.eventSourceArn)) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.bisectBatchOnError != null ? !this.bisectBatchOnError.equals(that.bisectBatchOnError) : that.bisectBatchOnError != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.kafkaTopic != null ? !this.kafkaTopic.equals(that.kafkaTopic) : that.kafkaTopic != null) return false;
            if (this.maxBatchingWindow != null ? !this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow != null) return false;
            if (this.maxRecordAge != null ? !this.maxRecordAge.equals(that.maxRecordAge) : that.maxRecordAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            return this.startingPosition != null ? this.startingPosition.equals(that.startingPosition) : that.startingPosition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventSourceArn.hashCode();
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.bisectBatchOnError != null ? this.bisectBatchOnError.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.kafkaTopic != null ? this.kafkaTopic.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            result = 31 * result + (this.maxRecordAge != null ? this.maxRecordAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
            return result;
        }
    }
}
