package software.amazon.awscdk.services.managedblockchain;

/**
 * Properties for defining a `CfnMember`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.managedblockchain.*;
 * CfnMemberProps cfnMemberProps = CfnMemberProps.builder()
 *         .memberConfiguration(MemberConfigurationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .memberFrameworkConfiguration(MemberFrameworkConfigurationProperty.builder()
 *                         .memberFabricConfiguration(MemberFabricConfigurationProperty.builder()
 *                                 .adminPassword("adminPassword")
 *                                 .adminUsername("adminUsername")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .invitationId("invitationId")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .framework("framework")
 *                 .frameworkVersion("frameworkVersion")
 *                 .name("name")
 *                 .votingPolicy(VotingPolicyProperty.builder()
 *                         .approvalThresholdPolicy(ApprovalThresholdPolicyProperty.builder()
 *                                 .proposalDurationInHours(123)
 *                                 .thresholdComparator("thresholdComparator")
 *                                 .thresholdPercentage(123)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .networkFrameworkConfiguration(NetworkFrameworkConfigurationProperty.builder()
 *                         .networkFabricConfiguration(NetworkFabricConfigurationProperty.builder()
 *                                 .edition("edition")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .networkId("networkId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-17T17:31:11.024Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.managedblockchain.$Module.class, fqn = "@aws-cdk/aws-managedblockchain.CfnMemberProps")
@software.amazon.jsii.Jsii.Proxy(CfnMemberProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMemberProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration properties of the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMemberConfiguration();

    /**
     * The unique identifier of the invitation to join the network sent to the account that creates the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInvitationId() {
        return null;
    }

    /**
     * Configuration properties of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return null;
    }

    /**
     * The unique identifier of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMemberProps> {
        java.lang.Object memberConfiguration;
        java.lang.String invitationId;
        java.lang.Object networkConfiguration;
        java.lang.String networkId;

        /**
         * Sets the value of {@link CfnMemberProps#getMemberConfiguration}
         * @param memberConfiguration Configuration properties of the member. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.MemberConfigurationProperty memberConfiguration) {
            this.memberConfiguration = memberConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getMemberConfiguration}
         * @param memberConfiguration Configuration properties of the member. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberConfiguration(software.amazon.awscdk.core.IResolvable memberConfiguration) {
            this.memberConfiguration = memberConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getInvitationId}
         * @param invitationId The unique identifier of the invitation to join the network sent to the account that creates the member.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invitationId(java.lang.String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getNetworkConfiguration}
         * @param networkConfiguration Configuration properties of the network to which the member belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.core.IResolvable networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getNetworkConfiguration}
         * @param networkConfiguration Configuration properties of the network to which the member belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkConfigurationProperty networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getNetworkId}
         * @param networkId The unique identifier of the network to which the member belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkId(java.lang.String networkId) {
            this.networkId = networkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMemberProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMemberProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMemberProps {
        private final java.lang.Object memberConfiguration;
        private final java.lang.String invitationId;
        private final java.lang.Object networkConfiguration;
        private final java.lang.String networkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.memberConfiguration = software.amazon.jsii.Kernel.get(this, "memberConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.invitationId = software.amazon.jsii.Kernel.get(this, "invitationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkId = software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.memberConfiguration = java.util.Objects.requireNonNull(builder.memberConfiguration, "memberConfiguration is required");
            this.invitationId = builder.invitationId;
            this.networkConfiguration = builder.networkConfiguration;
            this.networkId = builder.networkId;
        }

        @Override
        public final java.lang.Object getMemberConfiguration() {
            return this.memberConfiguration;
        }

        @Override
        public final java.lang.String getInvitationId() {
            return this.invitationId;
        }

        @Override
        public final java.lang.Object getNetworkConfiguration() {
            return this.networkConfiguration;
        }

        @Override
        public final java.lang.String getNetworkId() {
            return this.networkId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("memberConfiguration", om.valueToTree(this.getMemberConfiguration()));
            if (this.getInvitationId() != null) {
                data.set("invitationId", om.valueToTree(this.getInvitationId()));
            }
            if (this.getNetworkConfiguration() != null) {
                data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
            }
            if (this.getNetworkId() != null) {
                data.set("networkId", om.valueToTree(this.getNetworkId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-managedblockchain.CfnMemberProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMemberProps.Jsii$Proxy that = (CfnMemberProps.Jsii$Proxy) o;

            if (!memberConfiguration.equals(that.memberConfiguration)) return false;
            if (this.invitationId != null ? !this.invitationId.equals(that.invitationId) : that.invitationId != null) return false;
            if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
            return this.networkId != null ? this.networkId.equals(that.networkId) : that.networkId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.memberConfiguration.hashCode();
            result = 31 * result + (this.invitationId != null ? this.invitationId.hashCode() : 0);
            result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
            result = 31 * result + (this.networkId != null ? this.networkId.hashCode() : 0);
            return result;
        }
    }
}
