package software.amazon.awscdk.services.s3objectlambda;

/**
 * (experimental) An S3 object lambda access point for intercepting and transforming `GetObject` requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.s3objectlambda.*;
 * import software.amazon.awscdk.core.*;
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .payload(Map.of(
 *                 "prop", "value"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-22T09:25:21.119Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3objectlambda.$Module.class, fqn = "@aws-cdk/aws-s3objectlambda.AccessPoint")
public class AccessPoint extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.s3objectlambda.IAccessPoint {

    protected AccessPoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessPoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AccessPoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3objectlambda.AccessPointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Reference an existing AccessPoint defined outside of the CDK code.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3objectlambda.IAccessPoint fromAccessPointAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3objectlambda.AccessPointAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3objectlambda.AccessPoint.class, "fromAccessPointAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3objectlambda.IAccessPoint.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Implement the {@link IAccessPoint.virtualHostedUrlForObject} method.
     * <p>
     * @param key
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.VirtualHostedStyleUrlOptions options) {
        return software.amazon.jsii.Kernel.call(this, "virtualHostedUrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key, options });
    }

    /**
     * (experimental) Implement the {@link IAccessPoint.virtualHostedUrlForObject} method.
     * <p>
     * @param key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject(final @org.jetbrains.annotations.Nullable java.lang.String key) {
        return software.amazon.jsii.Kernel.call(this, "virtualHostedUrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { key });
    }

    /**
     * (experimental) Implement the {@link IAccessPoint.virtualHostedUrlForObject} method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String virtualHostedUrlForObject() {
        return software.amazon.jsii.Kernel.call(this, "virtualHostedUrlForObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN of the access point.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessPointArn() {
        return software.amazon.jsii.Kernel.get(this, "accessPointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The creation data of the access point.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessPointCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "accessPointCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN of the access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessPointName() {
        return software.amazon.jsii.Kernel.get(this, "accessPointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Implement the {@link IAccessPoint.domainName} field.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Implement the {@link IAccessPoint.regionalDomainName} field.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRegionalDomainName() {
        return software.amazon.jsii.Kernel.get(this, "regionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.s3objectlambda.AccessPoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3objectlambda.AccessPoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3objectlambda.AccessPointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3objectlambda.AccessPointProps.Builder();
        }

        /**
         * (experimental) The bucket to which this access point belongs.
         * <p>
         * @return {@code this}
         * @param bucket The bucket to which this access point belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * (experimental) The Lambda function used to transform objects.
         * <p>
         * @return {@code this}
         * @param handler The Lambda function used to transform objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder handler(final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * (experimental) The name of the S3 object lambda access point.
         * <p>
         * Default: a unique name will be generated
         * <p>
         * @return {@code this}
         * @param accessPointName The name of the S3 object lambda access point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessPointName(final java.lang.String accessPointName) {
            this.props.accessPointName(accessPointName);
            return this;
        }

        /**
         * (experimental) Whether CloudWatch metrics are enabled for the access point.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param cloudWatchMetricsEnabled Whether CloudWatch metrics are enabled for the access point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudWatchMetricsEnabled(final java.lang.Boolean cloudWatchMetricsEnabled) {
            this.props.cloudWatchMetricsEnabled(cloudWatchMetricsEnabled);
            return this;
        }

        /**
         * (experimental) Additional JSON that provides supplemental data passed to the Lambda function on every request.
         * <p>
         * Default: - No data.
         * <p>
         * @return {@code this}
         * @param payload Additional JSON that provides supplemental data passed to the Lambda function on every request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payload(final java.util.Map<java.lang.String, ? extends java.lang.Object> payload) {
            this.props.payload(payload);
            return this;
        }

        /**
         * (experimental) Whether the Lambda function can process `GetObject-PartNumber` requests.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param supportsGetObjectPartNumber Whether the Lambda function can process `GetObject-PartNumber` requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportsGetObjectPartNumber(final java.lang.Boolean supportsGetObjectPartNumber) {
            this.props.supportsGetObjectPartNumber(supportsGetObjectPartNumber);
            return this;
        }

        /**
         * (experimental) Whether the Lambda function can process `GetObject-Range` requests.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param supportsGetObjectRange Whether the Lambda function can process `GetObject-Range` requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder supportsGetObjectRange(final java.lang.Boolean supportsGetObjectRange) {
            this.props.supportsGetObjectRange(supportsGetObjectRange);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3objectlambda.AccessPoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.s3objectlambda.AccessPoint build() {
            return new software.amazon.awscdk.services.s3objectlambda.AccessPoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
