/**
 * <h1>AWS::S3ObjectLambda Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This construct library allows you to define S3 object lambda access points.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.s3objectlambda.*;
 * import software.amazon.awscdk.core.*;
 * 
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .payload(Map.of(
 *                 "prop", "value"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Handling range and part number requests</h2>
 * <p>
 * Lambdas are currently limited to only transforming <code>GetObject</code> requests. However, they can additionally support <code>GetObject-Range</code> and <code>GetObject-PartNumber</code> requests, which needs to be specified in the access point configuration:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.s3objectlambda.*;
 * import software.amazon.awscdk.core.*;
 * 
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .supportsGetObjectRange(true)
 *         .supportsGetObjectPartNumber(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Pass additional data to Lambda function</h2>
 * <p>
 * You can specify an additional object that provides supplemental data to the Lambda function used to transform objects. The data is delivered as a JSON payload to the Lambda:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.s3objectlambda.*;
 * import software.amazon.awscdk.core.*;
 * 
 * Stack stack = new Stack();
 * Bucket bucket = new Bucket(stack, "MyBucket");
 * Function handler = Function.Builder.create(stack, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset("lambda.zip"))
 *         .build();
 * AccessPoint.Builder.create(stack, "MyObjectLambda")
 *         .bucket(bucket)
 *         .handler(handler)
 *         .accessPointName("my-access-point")
 *         .payload(Map.of(
 *                 "prop", "value"))
 *         .build();
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.s3objectlambda;
