package software.amazon.awscdk.services.s3objectlambda;

/**
 * Properties for defining a `CfnAccessPointPolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3objectlambda.*;
 * Object policyDocument;
 * CfnAccessPointPolicyProps cfnAccessPointPolicyProps = CfnAccessPointPolicyProps.builder()
 *         .objectLambdaAccessPoint("objectLambdaAccessPoint")
 *         .policyDocument(policyDocument)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:55.654Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.s3objectlambda.$Module.class, fqn = "@aws-cdk/aws-s3objectlambda.CfnAccessPointPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessPointPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessPointPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An access point with an attached AWS Lambda function used to access transformed data from an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectLambdaAccessPoint();

    /**
     * Object Lambda Access Point resource policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDocument();

    /**
     * @return a {@link Builder} of {@link CfnAccessPointPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessPointPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessPointPolicyProps> {
        java.lang.String objectLambdaAccessPoint;
        java.lang.Object policyDocument;

        /**
         * Sets the value of {@link CfnAccessPointPolicyProps#getObjectLambdaAccessPoint}
         * @param objectLambdaAccessPoint An access point with an attached AWS Lambda function used to access transformed data from an Amazon S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectLambdaAccessPoint(java.lang.String objectLambdaAccessPoint) {
            this.objectLambdaAccessPoint = objectLambdaAccessPoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointPolicyProps#getPolicyDocument}
         * @param policyDocument Object Lambda Access Point resource policy document. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessPointPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessPointPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccessPointPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessPointPolicyProps {
        private final java.lang.String objectLambdaAccessPoint;
        private final java.lang.Object policyDocument;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.objectLambdaAccessPoint = software.amazon.jsii.Kernel.get(this, "objectLambdaAccessPoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.objectLambdaAccessPoint = java.util.Objects.requireNonNull(builder.objectLambdaAccessPoint, "objectLambdaAccessPoint is required");
            this.policyDocument = java.util.Objects.requireNonNull(builder.policyDocument, "policyDocument is required");
        }

        @Override
        public final java.lang.String getObjectLambdaAccessPoint() {
            return this.objectLambdaAccessPoint;
        }

        @Override
        public final java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("objectLambdaAccessPoint", om.valueToTree(this.getObjectLambdaAccessPoint()));
            data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-s3objectlambda.CfnAccessPointPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessPointPolicyProps.Jsii$Proxy that = (CfnAccessPointPolicyProps.Jsii$Proxy) o;

            if (!objectLambdaAccessPoint.equals(that.objectLambdaAccessPoint)) return false;
            return this.policyDocument.equals(that.policyDocument);
        }

        @Override
        public final int hashCode() {
            int result = this.objectLambdaAccessPoint.hashCode();
            result = 31 * result + (this.policyDocument.hashCode());
            return result;
        }
    }
}
