package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Constructs `IS3Location` objects.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:08:14.722Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.S3Location")
public abstract class S3Location extends software.amazon.jsii.JsiiObject {

    protected S3Location(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Location(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected S3Location() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * An `IS3Location` built with a determined bucket and key prefix.
     * <p>
     * @param bucket is the bucket where the objects are to be stored. This parameter is required.
     * @param keyPrefix is the key prefix used by the location. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3Location fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String keyPrefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(keyPrefix, "keyPrefix is required") });
    }

    /**
     * An `IS3Location` determined fully by a JSON Path from the task input.
     * <p>
     * Due to the dynamic nature of those locations, the IAM grants that will be set by <code>grantRead</code> and <code>grantWrite</code>
     * apply to the <code>*</code> resource.
     * <p>
     * @param expression the JSON expression resolving to an S3 location URI. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3Location fromJsonExpression(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class, "fromJsonExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * Called when the S3Location is bound to a StepFunctions task.
     * <p>
     * @param task This parameter is required.
     * @param opts This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ISageMakerTask task, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationBindOptions opts);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.tasks.S3Location {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the S3Location is bound to a StepFunctions task.
         * <p>
         * @param task This parameter is required.
         * @param opts This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.ISageMakerTask task, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3LocationBindOptions opts) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3LocationConfig.class), new Object[] { java.util.Objects.requireNonNull(task, "task is required"), java.util.Objects.requireNonNull(opts, "opts is required") });
        }
    }
}
