package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for RunBatchJob.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:08:13.435Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.BatchSubmitJobProps")
@software.amazon.jsii.Jsii.Proxy(BatchSubmitJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BatchSubmitJobProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * The arn of the job definition used by this job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn();

    /**
     * The name of the job.
     * <p>
     * The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
     * numbers, hyphens, and underscores are allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobName();

    /**
     * The arn of the job queue into which the job is submitted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn();

    /**
     * The array size can be between 2 and 10,000.
     * <p>
     * If you specify array properties for a job, it becomes an array job.
     * For more information, see Array Jobs in the AWS Batch User Guide.
     * <p>
     * Default: - No array size
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getArraySize() {
        return null;
    }

    /**
     * The number of times to move a job to the RUNNABLE status.
     * <p>
     * You may specify between 1 and 10 attempts.
     * If the value of attempts is greater than one,
     * the job is retried on failure the same number of attempts as the value.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAttempts() {
        return null;
    }

    /**
     * A list of container overrides in JSON format that specify the name of a container in the specified job definition and the overrides it should receive.
     * <p>
     * Default: - No container overrides
     * <p>
     * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-containerOverrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides getContainerOverrides() {
        return null;
    }

    /**
     * A list of dependencies for the job.
     * <p>
     * A job can depend upon a maximum of 20 jobs.
     * <p>
     * Default: - No dependencies
     * <p>
     * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-dependsOn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency> getDependsOn() {
        return null;
    }

    /**
     * The payload to be passed as parameters to the batch job.
     * <p>
     * Default: - No parameters are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getPayload() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BatchSubmitJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BatchSubmitJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BatchSubmitJobProps> {
        private java.lang.String jobDefinitionArn;
        private java.lang.String jobName;
        private java.lang.String jobQueueArn;
        private java.lang.Number arraySize;
        private java.lang.Number attempts;
        private software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides containerOverrides;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency> dependsOn;
        private software.amazon.awscdk.services.stepfunctions.TaskInput payload;
        private java.lang.String comment;
        private software.amazon.awscdk.core.Duration heartbeat;
        private java.lang.String inputPath;
        private software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private java.lang.String outputPath;
        private java.lang.String resultPath;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link BatchSubmitJobProps#getJobDefinitionArn}
         * @param jobDefinitionArn The arn of the job definition used by this job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionArn(java.lang.String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getJobName}
         * @param jobName The name of the job. This parameter is required.
         *                The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
         *                numbers, hyphens, and underscores are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobName(java.lang.String jobName) {
            this.jobName = jobName;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getJobQueueArn}
         * @param jobQueueArn The arn of the job queue into which the job is submitted. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobQueueArn(java.lang.String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getArraySize}
         * @param arraySize The array size can be between 2 and 10,000.
         *                  If you specify array properties for a job, it becomes an array job.
         *                  For more information, see Array Jobs in the AWS Batch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arraySize(java.lang.Number arraySize) {
            this.arraySize = arraySize;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getAttempts}
         * @param attempts The number of times to move a job to the RUNNABLE status.
         *                 You may specify between 1 and 10 attempts.
         *                 If the value of attempts is greater than one,
         *                 the job is retried on failure the same number of attempts as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attempts(java.lang.Number attempts) {
            this.attempts = attempts;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getContainerOverrides}
         * @param containerOverrides A list of container overrides in JSON format that specify the name of a container in the specified job definition and the overrides it should receive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerOverrides(software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getDependsOn}
         * @param dependsOn A list of dependencies for the job.
         *                  A job can depend upon a maximum of 20 jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder dependsOn(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency> dependsOn) {
            this.dependsOn = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency>)dependsOn;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getPayload}
         * @param payload The payload to be passed as parameters to the batch job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payload(software.amazon.awscdk.services.stepfunctions.TaskInput payload) {
            this.payload = payload;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.core.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link BatchSubmitJobProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BatchSubmitJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BatchSubmitJobProps build() {
            return new Jsii$Proxy(jobDefinitionArn, jobName, jobQueueArn, arraySize, attempts, containerOverrides, dependsOn, payload, comment, heartbeat, inputPath, integrationPattern, outputPath, resultPath, timeout);
        }
    }

    /**
     * An implementation for {@link BatchSubmitJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchSubmitJobProps {
        private final java.lang.String jobDefinitionArn;
        private final java.lang.String jobName;
        private final java.lang.String jobQueueArn;
        private final java.lang.Number arraySize;
        private final java.lang.Number attempts;
        private final software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides containerOverrides;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency> dependsOn;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput payload;
        private final java.lang.String comment;
        private final software.amazon.awscdk.core.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobDefinitionArn = software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobName = software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobQueueArn = software.amazon.jsii.Kernel.get(this, "jobQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.arraySize = software.amazon.jsii.Kernel.get(this, "arraySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.attempts = software.amazon.jsii.Kernel.get(this, "attempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.containerOverrides = software.amazon.jsii.Kernel.get(this, "containerOverrides", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides.class));
            this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency.class)));
            this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String jobDefinitionArn, final java.lang.String jobName, final java.lang.String jobQueueArn, final java.lang.Number arraySize, final java.lang.Number attempts, final software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides containerOverrides, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency> dependsOn, final software.amazon.awscdk.services.stepfunctions.TaskInput payload, final java.lang.String comment, final software.amazon.awscdk.core.Duration heartbeat, final java.lang.String inputPath, final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern, final java.lang.String outputPath, final java.lang.String resultPath, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobDefinitionArn = java.util.Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required");
            this.jobName = java.util.Objects.requireNonNull(jobName, "jobName is required");
            this.jobQueueArn = java.util.Objects.requireNonNull(jobQueueArn, "jobQueueArn is required");
            this.arraySize = arraySize;
            this.attempts = attempts;
            this.containerOverrides = containerOverrides;
            this.dependsOn = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency>)dependsOn;
            this.payload = payload;
            this.comment = comment;
            this.heartbeat = heartbeat;
            this.inputPath = inputPath;
            this.integrationPattern = integrationPattern;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
            this.timeout = timeout;
        }

        @Override
        public final java.lang.String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        @Override
        public final java.lang.String getJobName() {
            return this.jobName;
        }

        @Override
        public final java.lang.String getJobQueueArn() {
            return this.jobQueueArn;
        }

        @Override
        public final java.lang.Number getArraySize() {
            return this.arraySize;
        }

        @Override
        public final java.lang.Number getAttempts() {
            return this.attempts;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides getContainerOverrides() {
            return this.containerOverrides;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getPayload() {
            return this.payload;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("jobDefinitionArn", om.valueToTree(this.getJobDefinitionArn()));
            data.set("jobName", om.valueToTree(this.getJobName()));
            data.set("jobQueueArn", om.valueToTree(this.getJobQueueArn()));
            if (this.getArraySize() != null) {
                data.set("arraySize", om.valueToTree(this.getArraySize()));
            }
            if (this.getAttempts() != null) {
                data.set("attempts", om.valueToTree(this.getAttempts()));
            }
            if (this.getContainerOverrides() != null) {
                data.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
            }
            if (this.getDependsOn() != null) {
                data.set("dependsOn", om.valueToTree(this.getDependsOn()));
            }
            if (this.getPayload() != null) {
                data.set("payload", om.valueToTree(this.getPayload()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.BatchSubmitJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BatchSubmitJobProps.Jsii$Proxy that = (BatchSubmitJobProps.Jsii$Proxy) o;

            if (!jobDefinitionArn.equals(that.jobDefinitionArn)) return false;
            if (!jobName.equals(that.jobName)) return false;
            if (!jobQueueArn.equals(that.jobQueueArn)) return false;
            if (this.arraySize != null ? !this.arraySize.equals(that.arraySize) : that.arraySize != null) return false;
            if (this.attempts != null ? !this.attempts.equals(that.attempts) : that.attempts != null) return false;
            if (this.containerOverrides != null ? !this.containerOverrides.equals(that.containerOverrides) : that.containerOverrides != null) return false;
            if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
            if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jobDefinitionArn.hashCode();
            result = 31 * result + (this.jobName.hashCode());
            result = 31 * result + (this.jobQueueArn.hashCode());
            result = 31 * result + (this.arraySize != null ? this.arraySize.hashCode() : 0);
            result = 31 * result + (this.attempts != null ? this.attempts.hashCode() : 0);
            result = 31 * result + (this.containerOverrides != null ? this.containerOverrides.hashCode() : 0);
            result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
            result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
