package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Specifies a limit to how long a model training job can run.
 * <p>
 * When the job reaches the time limit, Amazon SageMaker ends the training job.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:08:14.745Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.StoppingCondition")
@software.amazon.jsii.Jsii.Proxy(StoppingCondition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StoppingCondition extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum length of time, in seconds, that the training or compilation job can run.
     * <p>
     * Default: - 1 hour
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StoppingCondition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StoppingCondition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StoppingCondition> {
        private software.amazon.awscdk.core.Duration maxRuntime;

        /**
         * Sets the value of {@link StoppingCondition#getMaxRuntime}
         * @param maxRuntime The maximum length of time, in seconds, that the training or compilation job can run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRuntime(software.amazon.awscdk.core.Duration maxRuntime) {
            this.maxRuntime = maxRuntime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StoppingCondition}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StoppingCondition build() {
            return new Jsii$Proxy(maxRuntime);
        }
    }

    /**
     * An implementation for {@link StoppingCondition}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StoppingCondition {
        private final software.amazon.awscdk.core.Duration maxRuntime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxRuntime = software.amazon.jsii.Kernel.get(this, "maxRuntime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.core.Duration maxRuntime) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxRuntime = maxRuntime;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxRuntime() {
            return this.maxRuntime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxRuntime() != null) {
                data.set("maxRuntime", om.valueToTree(this.getMaxRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.StoppingCondition"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StoppingCondition.Jsii$Proxy that = (StoppingCondition.Jsii$Proxy) o;

            return this.maxRuntime != null ? this.maxRuntime.equals(that.maxRuntime) : that.maxRuntime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxRuntime != null ? this.maxRuntime.hashCode() : 0;
            return result;
        }
    }
}
