package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Dataset to be transformed and the Amazon S3 location where it is stored.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:08:14.745Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.TransformInput")
@software.amazon.jsii.Jsii.Proxy(TransformInput.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransformInput extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 location of the channel data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource getTransformDataSource();

    /**
     * The compression type of the transform data.
     * <p>
     * Default: NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
        return null;
    }

    /**
     * Multipurpose internet mail extension (MIME) type of the data.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * Method to use to split the transform job's data files into smaller batches.
     * <p>
     * Default: NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.SplitType getSplitType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransformInput> {
        private software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource;
        private software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private java.lang.String contentType;
        private software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType;

        /**
         * Sets the value of {@link TransformInput#getTransformDataSource}
         * @param transformDataSource S3 location of the channel data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformDataSource(software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource) {
            this.transformDataSource = transformDataSource;
            return this;
        }

        /**
         * Sets the value of {@link TransformInput#getCompressionType}
         * @param compressionType The compression type of the transform data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compressionType(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        /**
         * Sets the value of {@link TransformInput#getContentType}
         * @param contentType Multipurpose internet mail extension (MIME) type of the data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link TransformInput#getSplitType}
         * @param splitType Method to use to split the transform job's data files into smaller batches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitType(software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType) {
            this.splitType = splitType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformInput}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransformInput build() {
            return new Jsii$Proxy(transformDataSource, compressionType, contentType, splitType);
        }
    }

    /**
     * An implementation for {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformInput {
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource;
        private final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private final java.lang.String contentType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.transformDataSource = software.amazon.jsii.Kernel.get(this, "transformDataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource.class));
            this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.splitType = software.amazon.jsii.Kernel.get(this, "splitType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.SplitType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource, final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType, final java.lang.String contentType, final software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.transformDataSource = java.util.Objects.requireNonNull(transformDataSource, "transformDataSource is required");
            this.compressionType = compressionType;
            this.contentType = contentType;
            this.splitType = splitType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource getTransformDataSource() {
            return this.transformDataSource;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
            return this.compressionType;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.SplitType getSplitType() {
            return this.splitType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("transformDataSource", om.valueToTree(this.getTransformDataSource()));
            if (this.getCompressionType() != null) {
                data.set("compressionType", om.valueToTree(this.getCompressionType()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getSplitType() != null) {
                data.set("splitType", om.valueToTree(this.getSplitType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.TransformInput"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformInput.Jsii$Proxy that = (TransformInput.Jsii$Proxy) o;

            if (!transformDataSource.equals(that.transformDataSource)) return false;
            if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            return this.splitType != null ? this.splitType.equals(that.splitType) : that.splitType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.transformDataSource.hashCode();
            result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.splitType != null ? this.splitType.hashCode() : 0);
            return result;
        }
    }
}
