package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The size of the Elastic Inference (EI) instance to use for the production variant.
 * <p>
 * EI instances provide on-demand GPU computing for inference
 * <p>
 * @see https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-26T12:08:37.771Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.AcceleratorType")
public class AcceleratorType extends software.amazon.jsii.JsiiObject {

    protected AcceleratorType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AcceleratorType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instanceTypeIdentifier This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AcceleratorType(final @org.jetbrains.annotations.NotNull java.lang.String instanceTypeIdentifier) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceTypeIdentifier, "instanceTypeIdentifier is required") });
    }

    /**
     * AcceleratorType.
     * <p>
     * This class takes a combination of a class and size.
     * <p>
     * @param acceleratorClass This parameter is required.
     * @param instanceSize This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass acceleratorClass, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceSize instanceSize) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType.class), new Object[] { java.util.Objects.requireNonNull(acceleratorClass, "acceleratorClass is required"), java.util.Objects.requireNonNull(instanceSize, "instanceSize is required") });
    }

    /**
     * Return the accelerator type as a dotted string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
