package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Database and data catalog context in which the query execution occurs.
 * <p>
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_QueryExecutionContext.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-26T12:08:42.631Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.QueryExecutionContext")
@software.amazon.jsii.Jsii.Proxy(QueryExecutionContext.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueryExecutionContext extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of catalog used in query execution.
     * <p>
     * Default: - No catalog
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCatalogName() {
        return null;
    }

    /**
     * Name of database used in query execution.
     * <p>
     * Default: - No database
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueryExecutionContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueryExecutionContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueryExecutionContext> {
        private java.lang.String catalogName;
        private java.lang.String databaseName;

        /**
         * Sets the value of {@link QueryExecutionContext#getCatalogName}
         * @param catalogName Name of catalog used in query execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogName(java.lang.String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        /**
         * Sets the value of {@link QueryExecutionContext#getDatabaseName}
         * @param databaseName Name of database used in query execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueryExecutionContext}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueryExecutionContext build() {
            return new Jsii$Proxy(catalogName, databaseName);
        }
    }

    /**
     * An implementation for {@link QueryExecutionContext}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryExecutionContext {
        private final java.lang.String catalogName;
        private final java.lang.String databaseName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.catalogName = software.amazon.jsii.Kernel.get(this, "catalogName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String catalogName, final java.lang.String databaseName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.catalogName = catalogName;
            this.databaseName = databaseName;
        }

        @Override
        public final java.lang.String getCatalogName() {
            return this.catalogName;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCatalogName() != null) {
                data.set("catalogName", om.valueToTree(this.getCatalogName()));
            }
            if (this.getDatabaseName() != null) {
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.QueryExecutionContext"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueryExecutionContext.Jsii$Proxy that = (QueryExecutionContext.Jsii$Proxy) o;

            if (this.catalogName != null ? !this.catalogName.equals(that.catalogName) : that.catalogName != null) return false;
            return this.databaseName != null ? this.databaseName.equals(that.databaseName) : that.databaseName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.catalogName != null ? this.catalogName.hashCode() : 0;
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            return result;
        }
    }
}
