package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The data type set for the SNS message attributes.
 * <p>
 * @see https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.34.0 (build 9b72778)", date = "2021-09-29T20:31:22.021Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.MessageAttributeDataType")
public enum MessageAttributeDataType {
    /**
     * Strings are Unicode with UTF-8 binary encoding.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING,
    /**
     * An array, formatted as a string.
     * <p>
     * @see https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING_ARRAY,
    /**
     * Numbers are positive or negative integers or floating-point numbers.
     * <p>
     * @see https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NUMBER,
    /**
     * Binary type attributes can store any binary data.
     * <p>
     * @see https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BINARY,
}
