package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A message attribute to add to the SNS message.
 * <p>
 * @see https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.42.0 (build 5f6b62c)", date = "2021-11-09T12:19:38.912Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.MessageAttribute")
@software.amazon.jsii.Jsii.Proxy(MessageAttribute.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MessageAttribute extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value of the attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getValue();

    /**
     * The data type for the attribute.
     * <p>
     * Default: determined by type inspection if possible, fallback is String
     * <p>
     * @see https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType getDataType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MessageAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MessageAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MessageAttribute> {
        private java.lang.Object value;
        private software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType dataType;

        /**
         * Sets the value of {@link MessageAttribute#getValue}
         * @param value The value of the attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.Object value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link MessageAttribute#getDataType}
         * @param dataType The data type for the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MessageAttribute}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MessageAttribute build() {
            return new Jsii$Proxy(value, dataType);
        }
    }

    /**
     * An implementation for {@link MessageAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageAttribute {
        private final java.lang.Object value;
        private final software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType dataType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Object value, final software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType dataType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.value = java.util.Objects.requireNonNull(value, "value is required");
            this.dataType = dataType;
        }

        @Override
        public final java.lang.Object getValue() {
            return this.value;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType getDataType() {
            return this.dataType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("value", om.valueToTree(this.getValue()));
            if (this.getDataType() != null) {
                data.set("dataType", om.valueToTree(this.getDataType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.MessageAttribute"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MessageAttribute.Jsii$Proxy that = (MessageAttribute.Jsii$Proxy) o;

            if (!value.equals(that.value)) return false;
            return this.dataType != null ? this.dataType.equals(that.dataType) : that.dataType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
            return result;
        }
    }
}
