package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for StartExecution.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.42.0 (build 5f6b62c)", date = "2021-11-09T12:19:39.653Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.StepFunctionsStartExecutionProps")
@software.amazon.jsii.Jsii.Proxy(StepFunctionsStartExecutionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StepFunctionsStartExecutionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * The Step Functions state machine to start the execution on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine getStateMachine();

    /**
     * Pass the execution ID from the context object to the execution input.
     * <p>
     * This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
     * <p>
     * If you set this property to <code>true</code>, the <code>input</code> property must be an object (provided by <code>sfn.TaskInput.fromObject</code>) or omitted entirely.
     * <p>
     * Default: - false
     * <p>
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-nested-workflows.html#nested-execution-startid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssociateWithParent() {
        return null;
    }

    /**
     * The JSON input for the execution, same as that of StartExecution.
     * <p>
     * Default: - The state input (JSON path '$')
     * <p>
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getInput() {
        return null;
    }

    /**
     * The name of the execution, same as that of StartExecution.
     * <p>
     * Default: - None
     * <p>
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StepFunctionsStartExecutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StepFunctionsStartExecutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StepFunctionsStartExecutionProps> {
        private software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine;
        private java.lang.Boolean associateWithParent;
        private software.amazon.awscdk.services.stepfunctions.TaskInput input;
        private java.lang.String name;
        private java.lang.String comment;
        private software.amazon.awscdk.core.Duration heartbeat;
        private java.lang.String inputPath;
        private software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private java.lang.String outputPath;
        private java.lang.String resultPath;
        private java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getStateMachine}
         * @param stateMachine The Step Functions state machine to start the execution on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachine(software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
            this.stateMachine = stateMachine;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getAssociateWithParent}
         * @param associateWithParent Pass the execution ID from the context object to the execution input.
         *                            This allows the Step Functions UI to link child executions from parent executions, making it easier to trace execution flow across state machines.
         *                            <p>
         *                            If you set this property to <code>true</code>, the <code>input</code> property must be an object (provided by <code>sfn.TaskInput.fromObject</code>) or omitted entirely.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associateWithParent(java.lang.Boolean associateWithParent) {
            this.associateWithParent = associateWithParent;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getInput}
         * @param input The JSON input for the execution, same as that of StartExecution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.stepfunctions.TaskInput input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getName}
         * @param name The name of the execution, same as that of StartExecution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.core.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsStartExecutionProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepFunctionsStartExecutionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StepFunctionsStartExecutionProps build() {
            return new Jsii$Proxy(stateMachine, associateWithParent, input, name, comment, heartbeat, inputPath, integrationPattern, outputPath, resultPath, resultSelector, timeout);
        }
    }

    /**
     * An implementation for {@link StepFunctionsStartExecutionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepFunctionsStartExecutionProps {
        private final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine;
        private final java.lang.Boolean associateWithParent;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput input;
        private final java.lang.String name;
        private final java.lang.String comment;
        private final software.amazon.awscdk.core.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateMachine = software.amazon.jsii.Kernel.get(this, "stateMachine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IStateMachine.class));
            this.associateWithParent = software.amazon.jsii.Kernel.get(this, "associateWithParent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine, final java.lang.Boolean associateWithParent, final software.amazon.awscdk.services.stepfunctions.TaskInput input, final java.lang.String name, final java.lang.String comment, final software.amazon.awscdk.core.Duration heartbeat, final java.lang.String inputPath, final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern, final java.lang.String outputPath, final java.lang.String resultPath, final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateMachine = java.util.Objects.requireNonNull(stateMachine, "stateMachine is required");
            this.associateWithParent = associateWithParent;
            this.input = input;
            this.name = name;
            this.comment = comment;
            this.heartbeat = heartbeat;
            this.inputPath = inputPath;
            this.integrationPattern = integrationPattern;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            this.timeout = timeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IStateMachine getStateMachine() {
            return this.stateMachine;
        }

        @Override
        public final java.lang.Boolean getAssociateWithParent() {
            return this.associateWithParent;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getInput() {
            return this.input;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateMachine", om.valueToTree(this.getStateMachine()));
            if (this.getAssociateWithParent() != null) {
                data.set("associateWithParent", om.valueToTree(this.getAssociateWithParent()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.StepFunctionsStartExecutionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StepFunctionsStartExecutionProps.Jsii$Proxy that = (StepFunctionsStartExecutionProps.Jsii$Proxy) o;

            if (!stateMachine.equals(that.stateMachine)) return false;
            if (this.associateWithParent != null ? !this.associateWithParent.equals(that.associateWithParent) : that.associateWithParent != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stateMachine.hashCode();
            result = 31 * result + (this.associateWithParent != null ? this.associateWithParent.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
