package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The action to take when the cluster step fails.
 * <p>
 * Default: CONTINUE
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrAddStep.Builder.create(this, "Task")
 *         .clusterId("ClusterId")
 *         .name("StepName")
 *         .jar("Jar")
 *         .actionOnFailure(ActionOnFailure.CONTINUE)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
 * Here, they are named as TERMINATE_JOB_FLOW, TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE respectively.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-20T22:20:05.842Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.ActionOnFailure")
public enum ActionOnFailure {
    /**
     * Terminate the Cluster on Step Failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERMINATE_CLUSTER,
    /**
     * Cancel Step execution and enter WAITING state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CANCEL_AND_WAIT,
    /**
     * Continue to the next Step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONTINUE,
}
