package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Call HTTP API endpoint as a Task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi = new HttpApi(this, "MyHttpApi");
 * CallApiGatewayHttpApiEndpoint invokeTask = CallApiGatewayHttpApiEndpoint.Builder.create(this, "Call HTTP API")
 *         .apiId(httpApi.getApiId())
 *         .apiStack(Stack.of(httpApi))
 *         .method(HttpMethod.GET)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-api-gateway.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-20T22:20:05.877Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.CallApiGatewayHttpApiEndpoint")
public class CallApiGatewayHttpApiEndpoint extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected CallApiGatewayHttpApiEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CallApiGatewayHttpApiEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CallApiGatewayHttpApiEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> createPolicyStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "createPolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "apiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getArnForExecuteApi() {
        return software.amazon.jsii.Kernel.get(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpointProps.Builder();
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(final software.amazon.awscdk.core.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * Timeout for the state machine.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param timeout Timeout for the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Http method for the API.
         * <p>
         * @return {@code this}
         * @param method Http method for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(final software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod method) {
            this.props.method(method);
            return this;
        }

        /**
         * Path parameters appended after API endpoint.
         * <p>
         * Default: - No path
         * <p>
         * @return {@code this}
         * @param apiPath Path parameters appended after API endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiPath(final java.lang.String apiPath) {
            this.props.apiPath(apiPath);
            return this;
        }

        /**
         * Authentication methods.
         * <p>
         * Default: AuthType.NO_AUTH
         * <p>
         * @return {@code this}
         * @param authType Authentication methods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(final software.amazon.awscdk.services.stepfunctions.tasks.AuthType authType) {
            this.props.authType(authType);
            return this;
        }

        /**
         * HTTP request information that does not relate to contents of the request.
         * <p>
         * Default: - No headers
         * <p>
         * @return {@code this}
         * @param headers HTTP request information that does not relate to contents of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headers(final software.amazon.awscdk.services.stepfunctions.TaskInput headers) {
            this.props.headers(headers);
            return this;
        }

        /**
         * Query strings attatched to end of request.
         * <p>
         * Default: - No query parameters
         * <p>
         * @return {@code this}
         * @param queryParameters Query strings attatched to end of request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryParameters(final software.amazon.awscdk.services.stepfunctions.TaskInput queryParameters) {
            this.props.queryParameters(queryParameters);
            return this;
        }

        /**
         * HTTP Request body.
         * <p>
         * Default: - No request body
         * <p>
         * @return {@code this}
         * @param requestBody HTTP Request body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBody(final software.amazon.awscdk.services.stepfunctions.TaskInput requestBody) {
            this.props.requestBody(requestBody);
            return this;
        }

        /**
         * The Id of the API to call.
         * <p>
         * @return {@code this}
         * @param apiId The Id of the API to call. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * The Stack in which the API is defined.
         * <p>
         * @return {@code this}
         * @param apiStack The Stack in which the API is defined. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStack(final software.amazon.awscdk.core.Stack apiStack) {
            this.props.apiStack(apiStack);
            return this;
        }

        /**
         * Name of the stage where the API is deployed to in API Gateway.
         * <p>
         * Default: '$default'
         * <p>
         * @return {@code this}
         * @param stageName Name of the stage where the API is deployed to in API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpoint build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
