package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The generation of Elastic Inference (EI) instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * AcceleratorClass acceleratorClass = AcceleratorClass.of("version");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:13.964Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.AcceleratorClass")
public class AcceleratorClass extends software.amazon.jsii.JsiiObject {

    protected AcceleratorClass(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AcceleratorClass(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        EIA1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass.class, "EIA1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass.class));
        EIA2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass.class, "EIA2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass.class));
    }

    /**
     * Custom AcceleratorType.
     * <p>
     * @param version - Elastic Inference accelerator generation. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass of(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Elastic Inference accelerator 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass EIA1;

    /**
     * Elastic Inference accelerator 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorClass EIA2;

    /**
     * - Elastic Inference accelerator generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
