package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Invocation type of a Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * LambdaInvoke submitJob = LambdaInvoke.Builder.create(this, "Invoke Handler")
 *         .lambdaFunction(fn)
 *         .payload(TaskInput.fromJsonPathAt("$.input"))
 *         .invocationType(LambdaInvocationType.EVENT)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:14.200Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.LambdaInvocationType")
public enum LambdaInvocationType {
    /**
     * Invoke the function synchronously.
     * <p>
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUEST_RESPONSE,
    /**
     * Invoke the function asynchronously.
     * <p>
     * Send events that fail multiple times to the function's dead-letter queue (if it's configured).
     * The API response only includes a status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENT,
    /**
     * Validate parameter values and verify that the user or role has permission to invoke the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DRY_RUN,
}
