package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Encryption Options of the S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AthenaStartQueryExecution startQueryExecutionJob = AthenaStartQueryExecution.Builder.create(this, "Athena Start Query")
 *         .queryString(JsonPath.format("select contacts where year={};", JsonPath.stringAt("$.year")))
 *         .queryExecutionContext(QueryExecutionContext.builder()
 *                 .databaseName("interactions")
 *                 .build())
 *         .resultConfiguration(ResultConfiguration.builder()
 *                 .encryptionConfiguration(EncryptionConfiguration.builder()
 *                         .encryptionOption(EncryptionOption.S3_MANAGED)
 *                         .build())
 *                 .outputLocation(Location.builder()
 *                         .bucketName("mybucket")
 *                         .objectKey("myprefix")
 *                         .build())
 *                 .build())
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption">https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-19T23:09:34.517Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EncryptionOption")
public enum EncryptionOption {
    /**
     * Server side encryption (SSE) with an Amazon S3-managed key.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_MANAGED,
    /**
     * Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
    /**
     * Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLIENT_SIDE_KMS,
}
