package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Specify the driver that the EMR Containers job runs on.
 * <p>
 * The job driver is used to provide an input for the job that will be run.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobName("EMR-Containers-Job")
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .build())
 *                 .build())
 *         .applicationConfig(List.of(ApplicationConfiguration.builder()
 *                 .classification(Classification.SPARK_DEFAULTS)
 *                 .properties(Map.of(
 *                         "spark.executor.instances", "1",
 *                         "spark.executor.memory", "512M"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-19T23:09:34.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.JobDriver")
@software.amazon.jsii.Jsii.Proxy(JobDriver.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JobDriver extends software.amazon.jsii.JsiiSerializable {

    /**
     * The job driver parameters specified for spark submit.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_SparkSubmitJobDriver.html">https://docs.aws.amazon.com/emr-on-eks/latest/APIReference/API_SparkSubmitJobDriver.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.SparkSubmitJobDriver getSparkSubmitJobDriver();

    /**
     * @return a {@link Builder} of {@link JobDriver}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobDriver}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JobDriver> {
        software.amazon.awscdk.services.stepfunctions.tasks.SparkSubmitJobDriver sparkSubmitJobDriver;

        /**
         * Sets the value of {@link JobDriver#getSparkSubmitJobDriver}
         * @param sparkSubmitJobDriver The job driver parameters specified for spark submit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sparkSubmitJobDriver(software.amazon.awscdk.services.stepfunctions.tasks.SparkSubmitJobDriver sparkSubmitJobDriver) {
            this.sparkSubmitJobDriver = sparkSubmitJobDriver;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobDriver}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JobDriver build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobDriver}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobDriver {
        private final software.amazon.awscdk.services.stepfunctions.tasks.SparkSubmitJobDriver sparkSubmitJobDriver;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sparkSubmitJobDriver = software.amazon.jsii.Kernel.get(this, "sparkSubmitJobDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.SparkSubmitJobDriver.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sparkSubmitJobDriver = java.util.Objects.requireNonNull(builder.sparkSubmitJobDriver, "sparkSubmitJobDriver is required");
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.SparkSubmitJobDriver getSparkSubmitJobDriver() {
            return this.sparkSubmitJobDriver;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sparkSubmitJobDriver", om.valueToTree(this.getSparkSubmitJobDriver()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.JobDriver"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobDriver.Jsii$Proxy that = (JobDriver.Jsii$Proxy) o;

            return this.sparkSubmitJobDriver.equals(that.sparkSubmitJobDriver);
        }

        @Override
        public final int hashCode() {
            int result = this.sparkSubmitJobDriver.hashCode();
            return result;
        }
    }
}
