package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to create an EMR Cluster.
 * <p>
 * The ClusterConfiguration is defined as Parameters in the state machine definition.
 * <p>
 * OUTPUT: the ClusterId.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-10-01T01:50:03.815Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster")
public class EmrCreateCluster extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected EmrCreateCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrCreateCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EmrCreateCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The autoscaling role for the EMR Cluster.
     * <p>
     * Only available after task has been added to a state machine.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
        return this.jsiiGet("autoScalingRole", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * The instance role for the EMR Cluster.
     * <p>
     * Only available after task has been added to a state machine.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getClusterRole() {
        return this.jsiiGet("clusterRole", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * The service role for the EMR Cluster.
     * <p>
     * Only available after task has been added to a state machine.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return this.jsiiGet("serviceRole", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return this.jsiiGet("taskMetrics", software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class);
    }

    /**
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(this.jsiiGet("taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
    /**
     * Properties for the EMR Cluster Applications.
     * <p>
     * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching
     * the cluster.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_Application.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ApplicationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ApplicationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the application.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * This option is for advanced users only.
         * <p>
         * This is meta information about third-party applications that third-party vendors use
         * for testing purposes.
         * <p>
         * Default: No additionalInfo
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getAdditionalInfo() {
            return null;
        }

        /**
         * Arguments for Amazon EMR to pass to the application.
         * <p>
         * Default: No args
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * The version of the application.
         * <p>
         * Default: No version
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationConfigProperty> {
            private java.lang.String name;
            private java.util.Map<java.lang.String, java.lang.String> additionalInfo;
            private java.util.List<java.lang.String> args;
            private java.lang.String version;

            /**
             * Sets the value of {@link ApplicationConfigProperty#getName}
             * @param name The name of the application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigProperty#getAdditionalInfo}
             * @param additionalInfo This option is for advanced users only.
             *                       This is meta information about third-party applications that third-party vendors use
             *                       for testing purposes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder additionalInfo(java.util.Map<java.lang.String, java.lang.String> additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigProperty#getArgs}
             * @param args Arguments for Amazon EMR to pass to the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationConfigProperty#getVersion}
             * @param version The version of the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ApplicationConfigProperty build() {
                return new Jsii$Proxy(name, additionalInfo, args, version);
            }
        }

        /**
         * An implementation for {@link ApplicationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationConfigProperty {
            private final java.lang.String name;
            private final java.util.Map<java.lang.String, java.lang.String> additionalInfo;
            private final java.util.List<java.lang.String> args;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.additionalInfo = this.jsiiGet("additionalInfo", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.args = this.jsiiGet("args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.util.Map<java.lang.String, java.lang.String> additionalInfo, final java.util.List<java.lang.String> args, final java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.additionalInfo = additionalInfo;
                this.args = args;
                this.version = version;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.util.Map<java.lang.String, java.lang.String> getAdditionalInfo() {
                return this.additionalInfo;
            }

            @Override
            public java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getAdditionalInfo() != null) {
                    data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
                }
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ApplicationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationConfigProperty.Jsii$Proxy that = (ApplicationConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
                if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.additionalInfo != null ? this.additionalInfo.hashCode() : 0);
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_AutoScalingPolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface AutoScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper and lower EC2 instance limits for an automatic scaling policy.
         * <p>
         * Automatic scaling activity will not cause an instance
         * group to grow above or below these limits.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty getConstraints();

        /**
         * The scale-in and scale-out rules that comprise the automatic scaling policy.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> getRules();

        /**
         * @return a {@link Builder} of {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty constraints;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> rules;

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getConstraints}
             * @param constraints The upper and lower EC2 instance limits for an automatic scaling policy. This parameter is required.
             *                    Automatic scaling activity will not cause an instance
             *                    group to grow above or below these limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder constraints(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getRules}
             * @param rules The scale-in and scale-out rules that comprise the automatic scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder rules(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> rules) {
                this.rules = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty>)rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public AutoScalingPolicyProperty build() {
                return new Jsii$Proxy(constraints, rules);
            }
        }

        /**
         * An implementation for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingPolicyProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty constraints;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = this.jsiiGet("constraints", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty.class);
                this.rules = this.jsiiGet("rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty constraints, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> rules) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = java.util.Objects.requireNonNull(constraints, "constraints is required");
                this.rules = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty>)java.util.Objects.requireNonNull(rules, "rules is required");
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingConstraintsProperty getConstraints() {
                return this.constraints;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingRuleProperty> getRules() {
                return this.rules;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("constraints", om.valueToTree(this.getConstraints()));
                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.AutoScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingPolicyProperty.Jsii$Proxy that = (AutoScalingPolicyProperty.Jsii$Proxy) o;

                if (!constraints.equals(that.constraints)) return false;
                return this.rules.equals(that.rules);
            }

            @Override
            public int hashCode() {
                int result = this.constraints.hashCode();
                result = 31 * result + (this.rules.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration of a bootstrap action.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_BootstrapActionConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.BootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BootstrapActionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface BootstrapActionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the bootstrap action.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The script run by the bootstrap action.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty getScriptBootstrapAction();

        /**
         * @return a {@link Builder} of {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<BootstrapActionConfigProperty> {
            private java.lang.String name;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction;

            /**
             * Sets the value of {@link BootstrapActionConfigProperty#getName}
             * @param name The name of the bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BootstrapActionConfigProperty#getScriptBootstrapAction}
             * @param scriptBootstrapAction The script run by the bootstrap action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder scriptBootstrapAction(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BootstrapActionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public BootstrapActionConfigProperty build() {
                return new Jsii$Proxy(name, scriptBootstrapAction);
            }
        }

        /**
         * An implementation for {@link BootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BootstrapActionConfigProperty {
            private final java.lang.String name;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.scriptBootstrapAction = this.jsiiGet("scriptBootstrapAction", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty scriptBootstrapAction) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.scriptBootstrapAction = java.util.Objects.requireNonNull(scriptBootstrapAction, "scriptBootstrapAction is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty getScriptBootstrapAction() {
                return this.scriptBootstrapAction;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("scriptBootstrapAction", om.valueToTree(this.getScriptBootstrapAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.BootstrapActionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BootstrapActionConfigProperty.Jsii$Proxy that = (BootstrapActionConfigProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.scriptBootstrapAction.equals(that.scriptBootstrapAction);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.scriptBootstrapAction.hashCode());
                return result;
            }
        }
    }
    /**
     * CloudWatch Alarm Comparison Operators.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator")
    public enum CloudWatchAlarmComparisonOperator {
        /**
         * GREATER_THAN_OR_EQUAL.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GREATER_THAN_OR_EQUAL,
        /**
         * GREATER_THAN.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GREATER_THAN,
        /**
         * LESS_THAN.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        LESS_THAN,
        /**
         * LESS_THAN_OR_EQUAL.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        LESS_THAN_OR_EQUAL,
    }
    /**
     * The definition of a CloudWatch metric alarm, which determines when an automatic scaling activity is triggered.
     * <p>
     * When the defined alarm conditions
     * are satisfied, scaling activity begins.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_CloudWatchAlarmDefinition.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchAlarmDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface CloudWatchAlarmDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines how the metric specified by MetricName is compared to the value specified by Threshold.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator getComparisonOperator();

        /**
         * The name of the CloudWatch metric that is watched to determine an alarm condition.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The period, in seconds, over which the statistic is applied.
         * <p>
         * EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if
         * an EMR CloudWatch metric is specified, specify 300.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration getPeriod();

        /**
         * A CloudWatch metric dimension.
         * <p>
         * Default: - No dimensions
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> getDimensions() {
            return null;
        }

        /**
         * The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
         * <p>
         * Default: 1
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationPeriods() {
            return null;
        }

        /**
         * The namespace for the CloudWatch metric.
         * <p>
         * Default: 'AWS/ElasticMapReduce'
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The statistic to apply to the metric associated with the alarm.
         * <p>
         * Default: CloudWatchAlarmStatistic.AVERAGE
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic getStatistic() {
            return null;
        }

        /**
         * The value against which the specified statistic is compared.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreshold() {
            return null;
        }

        /**
         * The unit of measure associated with the CloudWatch metric being watched.
         * <p>
         * The value specified for Unit must correspond to the units
         * specified in the CloudWatch metric.
         * <p>
         * Default: CloudWatchAlarmUnit.NONE
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchAlarmDefinitionProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator comparisonOperator;
            private java.lang.String metricName;
            private software.amazon.awscdk.core.Duration period;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> dimensions;
            private java.lang.Number evaluationPeriods;
            private java.lang.String namespace;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic statistic;
            private java.lang.Number threshold;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit unit;

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getComparisonOperator}
             * @param comparisonOperator Determines how the metric specified by MetricName is compared to the value specified by Threshold. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder comparisonOperator(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getMetricName}
             * @param metricName The name of the CloudWatch metric that is watched to determine an alarm condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getPeriod}
             * @param period The period, in seconds, over which the statistic is applied. This parameter is required.
             *               EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if
             *               an EMR CloudWatch metric is specified, specify 300.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder period(software.amazon.awscdk.core.Duration period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getDimensions}
             * @param dimensions A CloudWatch metric dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder dimensions(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> dimensions) {
                this.dimensions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty>)dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getEvaluationPeriods}
             * @param evaluationPeriods The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getNamespace}
             * @param namespace The namespace for the CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getStatistic}
             * @param statistic The statistic to apply to the metric associated with the alarm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder statistic(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getThreshold}
             * @param threshold The value against which the specified statistic is compared.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getUnit}
             * @param unit The unit of measure associated with the CloudWatch metric being watched.
             *             The value specified for Unit must correspond to the units
             *             specified in the CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder unit(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchAlarmDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii$Proxy(comparisonOperator, metricName, period, dimensions, evaluationPeriods, namespace, statistic, threshold, unit);
            }
        }

        /**
         * An implementation for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchAlarmDefinitionProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator comparisonOperator;
            private final java.lang.String metricName;
            private final software.amazon.awscdk.core.Duration period;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> dimensions;
            private final java.lang.Number evaluationPeriods;
            private final java.lang.String namespace;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic statistic;
            private final java.lang.Number threshold;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = this.jsiiGet("comparisonOperator", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator.class);
                this.metricName = this.jsiiGet("metricName", java.lang.String.class);
                this.period = this.jsiiGet("period", software.amazon.awscdk.core.Duration.class);
                this.dimensions = this.jsiiGet("dimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty.class)));
                this.evaluationPeriods = this.jsiiGet("evaluationPeriods", java.lang.Number.class);
                this.namespace = this.jsiiGet("namespace", java.lang.String.class);
                this.statistic = this.jsiiGet("statistic", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic.class);
                this.threshold = this.jsiiGet("threshold", java.lang.Number.class);
                this.unit = this.jsiiGet("unit", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator comparisonOperator, final java.lang.String metricName, final software.amazon.awscdk.core.Duration period, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> dimensions, final java.lang.Number evaluationPeriods, final java.lang.String namespace, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic statistic, final java.lang.Number threshold, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit unit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(comparisonOperator, "comparisonOperator is required");
                this.metricName = java.util.Objects.requireNonNull(metricName, "metricName is required");
                this.period = java.util.Objects.requireNonNull(period, "period is required");
                this.dimensions = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty>)dimensions;
                this.evaluationPeriods = evaluationPeriods;
                this.namespace = namespace;
                this.statistic = statistic;
                this.threshold = threshold;
                this.unit = unit;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmComparisonOperator getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public software.amazon.awscdk.core.Duration getPeriod() {
                return this.period;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.MetricDimensionProperty> getDimensions() {
                return this.dimensions;
            }

            @Override
            public java.lang.Number getEvaluationPeriods() {
                return this.evaluationPeriods;
            }

            @Override
            public java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmStatistic getStatistic() {
                return this.statistic;
            }

            @Override
            public java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmUnit getUnit() {
                return this.unit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("period", om.valueToTree(this.getPeriod()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getEvaluationPeriods() != null) {
                    data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getStatistic() != null) {
                    data.set("statistic", om.valueToTree(this.getStatistic()));
                }
                if (this.getThreshold() != null) {
                    data.set("threshold", om.valueToTree(this.getThreshold()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchAlarmDefinitionProperty.Jsii$Proxy that = (CloudWatchAlarmDefinitionProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!metricName.equals(that.metricName)) return false;
                if (!period.equals(that.period)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
                if (this.threshold != null ? !this.threshold.equals(that.threshold) : that.threshold != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.period.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
                result = 31 * result + (this.threshold != null ? this.threshold.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * CloudWatch Alarm Statistics.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmStatistic")
    public enum CloudWatchAlarmStatistic {
        /**
         * SAMPLE_COUNT.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SAMPLE_COUNT,
        /**
         * AVERAGE.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        AVERAGE,
        /**
         * SUM.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SUM,
        /**
         * MINIMUM.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MINIMUM,
        /**
         * MAXIMUM.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MAXIMUM,
    }
    /**
     * CloudWatch Alarm Units.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.CloudWatchAlarmUnit")
    public enum CloudWatchAlarmUnit {
        /**
         * NONE.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        NONE,
        /**
         * SECONDS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SECONDS,
        /**
         * MICRO_SECONDS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MICRO_SECONDS,
        /**
         * MILLI_SECONDS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MILLI_SECONDS,
        /**
         * BYTES.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BYTES,
        /**
         * KILO_BYTES.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BYTES,
        /**
         * MEGA_BYTES.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BYTES,
        /**
         * GIGA_BYTES.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BYTES,
        /**
         * TERA_BYTES.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BYTES,
        /**
         * BITS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BITS,
        /**
         * KILO_BITS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BITS,
        /**
         * MEGA_BITS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BITS,
        /**
         * GIGA_BITS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BITS,
        /**
         * TERA_BITS.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BITS,
        /**
         * PERCENT.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        PERCENT,
        /**
         * COUNT.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        COUNT,
        /**
         * BYTES_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BYTES_PER_SECOND,
        /**
         * KILO_BYTES_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BYTES_PER_SECOND,
        /**
         * MEGA_BYTES_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BYTES_PER_SECOND,
        /**
         * GIGA_BYTES_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BYTES_PER_SECOND,
        /**
         * TERA_BYTES_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BYTES_PER_SECOND,
        /**
         * BITS_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        BITS_PER_SECOND,
        /**
         * KILO_BITS_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        KILO_BITS_PER_SECOND,
        /**
         * MEGA_BITS_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MEGA_BITS_PER_SECOND,
        /**
         * GIGA_BITS_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GIGA_BITS_PER_SECOND,
        /**
         * TERA_BITS_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERA_BITS_PER_SECOND,
        /**
         * COUNT_PER_SECOND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        COUNT_PER_SECOND,
    }
    /**
     * An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_Configuration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The classification within a configuration.
         * <p>
         * Default: No classification
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getClassification() {
            return null;
        }

        /**
         * A list of additional configurations to apply within a configuration object.
         * <p>
         * Default: No configurations
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * A set of properties specified within a configuration classification.
         * <p>
         * Default: No properties
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationProperty> {
            private java.lang.String classification;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private java.util.Map<java.lang.String, java.lang.String> properties;

            /**
             * Sets the value of {@link ConfigurationProperty#getClassification}
             * @param classification The classification within a configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getProperties}
             * @param properties A set of properties specified within a configuration classification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder properties(java.util.Map<java.lang.String, java.lang.String> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ConfigurationProperty build() {
                return new Jsii$Proxy(classification, configurations, properties);
            }
        }

        /**
         * An implementation for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationProperty {
            private final java.lang.String classification;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final java.util.Map<java.lang.String, java.lang.String> properties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = this.jsiiGet("classification", java.lang.String.class);
                this.configurations = this.jsiiGet("configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.properties = this.jsiiGet("properties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final java.lang.String classification, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations, final java.util.Map<java.lang.String, java.lang.String> properties) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = classification;
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                this.properties = properties;
            }

            @Override
            public java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public java.util.Map<java.lang.String, java.lang.String> getProperties() {
                return this.properties;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassification() != null) {
                    data.set("classification", om.valueToTree(this.getClassification()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationProperty.Jsii$Proxy that = (ConfigurationProperty.Jsii$Proxy) o;

                if (this.classification != null ? !this.classification.equals(that.classification) : that.classification != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
            }

            @Override
            public int hashCode() {
                int result = this.classification != null ? this.classification.hashCode() : 0;
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration of requested EBS block device associated with the instance group with count of volumes that will be associated to every instance.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsBlockDeviceConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsBlockDeviceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface EbsBlockDeviceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty getVolumeSpecification();

        /**
         * Number of EBS volumes with a specific volume configuration that will be associated with every instance in the instance group.
         * <p>
         * Default: EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumesPerInstance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty volumeSpecification;
            private java.lang.Number volumesPerInstance;

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumeSpecification(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumesPerInstance}
             * @param volumesPerInstance Number of EBS volumes with a specific volume configuration that will be associated with every instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumesPerInstance(java.lang.Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public EbsBlockDeviceConfigProperty build() {
                return new Jsii$Proxy(volumeSpecification, volumesPerInstance);
            }
        }

        /**
         * An implementation for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsBlockDeviceConfigProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty volumeSpecification;
            private final java.lang.Number volumesPerInstance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSpecification = this.jsiiGet("volumeSpecification", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty.class);
                this.volumesPerInstance = this.jsiiGet("volumesPerInstance", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty volumeSpecification, final java.lang.Number volumesPerInstance) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSpecification = java.util.Objects.requireNonNull(volumeSpecification, "volumeSpecification is required");
                this.volumesPerInstance = volumesPerInstance;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty getVolumeSpecification() {
                return this.volumeSpecification;
            }

            @Override
            public java.lang.Number getVolumesPerInstance() {
                return this.volumesPerInstance;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("volumeSpecification", om.valueToTree(this.getVolumeSpecification()));
                if (this.getVolumesPerInstance() != null) {
                    data.set("volumesPerInstance", om.valueToTree(this.getVolumesPerInstance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsBlockDeviceConfigProperty.Jsii$Proxy that = (EbsBlockDeviceConfigProperty.Jsii$Proxy) o;

                if (!volumeSpecification.equals(that.volumeSpecification)) return false;
                return this.volumesPerInstance != null ? this.volumesPerInstance.equals(that.volumesPerInstance) : that.volumesPerInstance == null;
            }

            @Override
            public int hashCode() {
                int result = this.volumeSpecification.hashCode();
                result = 31 * result + (this.volumesPerInstance != null ? this.volumesPerInstance.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * EBS Volume Types.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsBlockDeviceVolumeType")
    public enum EbsBlockDeviceVolumeType {
        /**
         * gp2 Volume Type.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        GP2,
        /**
         * io1 Volume Type.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        IO1,
        /**
         * Standard Volume Type.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        STANDARD,
    }
    /**
     * The Amazon EBS configuration of a cluster instance.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsConfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface EbsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> getEbsBlockDeviceConfigs() {
            return null;
        }

        /**
         * Indicates whether an Amazon EBS volume is EBS-optimized.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getEbsOptimized() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs;
            private java.lang.Boolean ebsOptimized;

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder ebsBlockDeviceConfigs(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty>)ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public EbsConfigurationProperty build() {
                return new Jsii$Proxy(ebsBlockDeviceConfigs, ebsOptimized);
            }
        }

        /**
         * An implementation for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsConfigurationProperty {
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs;
            private final java.lang.Boolean ebsOptimized;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsBlockDeviceConfigs = this.jsiiGet("ebsBlockDeviceConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty.class)));
                this.ebsOptimized = this.jsiiGet("ebsOptimized", java.lang.Boolean.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> ebsBlockDeviceConfigs, final java.lang.Boolean ebsOptimized) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsBlockDeviceConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty>)ebsBlockDeviceConfigs;
                this.ebsOptimized = ebsOptimized;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceConfigProperty> getEbsBlockDeviceConfigs() {
                return this.ebsBlockDeviceConfigs;
            }

            @Override
            public java.lang.Boolean getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsBlockDeviceConfigs() != null) {
                    data.set("ebsBlockDeviceConfigs", om.valueToTree(this.getEbsBlockDeviceConfigs()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EbsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsConfigurationProperty.Jsii$Proxy that = (EbsConfigurationProperty.Jsii$Proxy) o;

                if (this.ebsBlockDeviceConfigs != null ? !this.ebsBlockDeviceConfigs.equals(that.ebsBlockDeviceConfigs) : that.ebsBlockDeviceConfigs != null) return false;
                return this.ebsOptimized != null ? this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized == null;
            }

            @Override
            public int hashCode() {
                int result = this.ebsBlockDeviceConfigs != null ? this.ebsBlockDeviceConfigs.hashCode() : 0;
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Valid valus for the Cluster ScaleDownBehavior.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.EmrClusterScaleDownBehavior")
    public enum EmrClusterScaleDownBehavior {
        /**
         * Indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted.
         * <p>
         * This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERMINATE_AT_INSTANCE_HOUR,
        /**
         * Indicates that Amazon EMR blacklists and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERMINATE_AT_TASK_COMPLETION,
    }
    /**
     * The configuration that defines an instance fleet.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceFleetConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceFleetConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The node type that the instance fleet hosts.
         * <p>
         * Valid values are MASTER,CORE,and TASK.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceFleetType();

        /**
         * The instance type configurations that define the EC2 instances in the instance fleet.
         * <p>
         * Default: No instanceTpeConfigs
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> getInstanceTypeConfigs() {
            return null;
        }

        /**
         * The launch specification for the instance fleet.
         * <p>
         * Default: No launchSpecifications
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty getLaunchSpecifications() {
            return null;
        }

        /**
         * The friendly name of the instance fleet.
         * <p>
         * Default: No name
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         * <p>
         * Default: No targetOnDemandCapacity
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetOnDemandCapacity() {
            return null;
        }

        /**
         * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         * <p>
         * Default: No targetSpotCapacity
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetSpotCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetConfigProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceFleetType;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> instanceTypeConfigs;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications;
            private java.lang.String name;
            private java.lang.Number targetOnDemandCapacity;
            private java.lang.Number targetSpotCapacity;

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getInstanceFleetType}
             * @param instanceFleetType The node type that the instance fleet hosts. This parameter is required.
             *                          Valid values are MASTER,CORE,and TASK.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceFleetType(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceFleetType) {
                this.instanceFleetType = instanceFleetType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getInstanceTypeConfigs}
             * @param instanceTypeConfigs The instance type configurations that define the EC2 instances in the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder instanceTypeConfigs(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> instanceTypeConfigs) {
                this.instanceTypeConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty>)instanceTypeConfigs;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getLaunchSpecifications}
             * @param launchSpecifications The launch specification for the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder launchSpecifications(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getName}
             * @param name The friendly name of the instance fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getTargetOnDemandCapacity}
             * @param targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder targetOnDemandCapacity(java.lang.Number targetOnDemandCapacity) {
                this.targetOnDemandCapacity = targetOnDemandCapacity;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetConfigProperty#getTargetSpotCapacity}
             * @param targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder targetSpotCapacity(java.lang.Number targetSpotCapacity) {
                this.targetSpotCapacity = targetSpotCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceFleetConfigProperty build() {
                return new Jsii$Proxy(instanceFleetType, instanceTypeConfigs, launchSpecifications, name, targetOnDemandCapacity, targetSpotCapacity);
            }
        }

        /**
         * An implementation for {@link InstanceFleetConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetConfigProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceFleetType;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> instanceTypeConfigs;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications;
            private final java.lang.String name;
            private final java.lang.Number targetOnDemandCapacity;
            private final java.lang.Number targetSpotCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceFleetType = this.jsiiGet("instanceFleetType", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType.class);
                this.instanceTypeConfigs = this.jsiiGet("instanceTypeConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty.class)));
                this.launchSpecifications = this.jsiiGet("launchSpecifications", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.targetOnDemandCapacity = this.jsiiGet("targetOnDemandCapacity", java.lang.Number.class);
                this.targetSpotCapacity = this.jsiiGet("targetSpotCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceFleetType, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> instanceTypeConfigs, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty launchSpecifications, final java.lang.String name, final java.lang.Number targetOnDemandCapacity, final java.lang.Number targetSpotCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceFleetType = java.util.Objects.requireNonNull(instanceFleetType, "instanceFleetType is required");
                this.instanceTypeConfigs = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty>)instanceTypeConfigs;
                this.launchSpecifications = launchSpecifications;
                this.name = name;
                this.targetOnDemandCapacity = targetOnDemandCapacity;
                this.targetSpotCapacity = targetSpotCapacity;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceFleetType() {
                return this.instanceFleetType;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceTypeConfigProperty> getInstanceTypeConfigs() {
                return this.instanceTypeConfigs;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty getLaunchSpecifications() {
                return this.launchSpecifications;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.Number getTargetOnDemandCapacity() {
                return this.targetOnDemandCapacity;
            }

            @Override
            public java.lang.Number getTargetSpotCapacity() {
                return this.targetSpotCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceFleetType", om.valueToTree(this.getInstanceFleetType()));
                if (this.getInstanceTypeConfigs() != null) {
                    data.set("instanceTypeConfigs", om.valueToTree(this.getInstanceTypeConfigs()));
                }
                if (this.getLaunchSpecifications() != null) {
                    data.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTargetOnDemandCapacity() != null) {
                    data.set("targetOnDemandCapacity", om.valueToTree(this.getTargetOnDemandCapacity()));
                }
                if (this.getTargetSpotCapacity() != null) {
                    data.set("targetSpotCapacity", om.valueToTree(this.getTargetSpotCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceFleetConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetConfigProperty.Jsii$Proxy that = (InstanceFleetConfigProperty.Jsii$Proxy) o;

                if (!instanceFleetType.equals(that.instanceFleetType)) return false;
                if (this.instanceTypeConfigs != null ? !this.instanceTypeConfigs.equals(that.instanceTypeConfigs) : that.instanceTypeConfigs != null) return false;
                if (this.launchSpecifications != null ? !this.launchSpecifications.equals(that.launchSpecifications) : that.launchSpecifications != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.targetOnDemandCapacity != null ? !this.targetOnDemandCapacity.equals(that.targetOnDemandCapacity) : that.targetOnDemandCapacity != null) return false;
                return this.targetSpotCapacity != null ? this.targetSpotCapacity.equals(that.targetSpotCapacity) : that.targetSpotCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.instanceFleetType.hashCode();
                result = 31 * result + (this.instanceTypeConfigs != null ? this.instanceTypeConfigs.hashCode() : 0);
                result = 31 * result + (this.launchSpecifications != null ? this.launchSpecifications.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.targetOnDemandCapacity != null ? this.targetOnDemandCapacity.hashCode() : 0);
                result = 31 * result + (this.targetSpotCapacity != null ? this.targetSpotCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetProvisioningSpecifications.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceFleetProvisioningSpecificationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty getSpotSpecification();

        /**
         * @return a {@link Builder} of {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetProvisioningSpecificationsProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty spotSpecification;

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getSpotSpecification}
             * @param spotSpecification The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder spotSpecification(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetProvisioningSpecificationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii$Proxy(spotSpecification);
            }
        }

        /**
         * An implementation for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetProvisioningSpecificationsProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty spotSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spotSpecification = this.jsiiGet("spotSpecification", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty spotSpecification) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spotSpecification = java.util.Objects.requireNonNull(spotSpecification, "spotSpecification is required");
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty getSpotSpecification() {
                return this.spotSpecification;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spotSpecification", om.valueToTree(this.getSpotSpecification()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceFleetProvisioningSpecificationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy that = (InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy) o;

                return this.spotSpecification.equals(that.spotSpecification);
            }

            @Override
            public int hashCode() {
                int result = this.spotSpecification.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration defining a new instance group.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceGroupConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceGroupConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceGroupConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Target number of instances for the instance group.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The role of the instance group in the cluster.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceRole();

        /**
         * The EC2 instance type for all instances in the instance group.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty getAutoScalingPolicy() {
            return null;
        }

        /**
         * The bid price for each EC2 Spot instance type as defined by InstanceType.
         * <p>
         * Expressed in USD.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
            return null;
        }

        /**
         * The list of configurations supplied for an EMR cluster instance group.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * EBS configurations that will be attached to each EC2 instance in the instance group.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        /**
         * Market type of the EC2 instances used to create a cluster node.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
            return null;
        }

        /**
         * Friendly name given to the instance group.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceGroupConfigProperty> {
            private java.lang.Number instanceCount;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceRole;
            private java.lang.String instanceType;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty autoScalingPolicy;
            private java.lang.String bidPrice;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;
            private java.lang.String name;

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceCount}
             * @param instanceCount Target number of instances for the instance group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceRole}
             * @param instanceRole The role of the instance group in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceRole(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceRole) {
                this.instanceRole = instanceRole;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getInstanceType}
             * @param instanceType The EC2 instance type for all instances in the instance group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getAutoScalingPolicy}
             * @param autoScalingPolicy An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder autoScalingPolicy(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getBidPrice}
             * @param bidPrice The bid price for each EC2 Spot instance type as defined by InstanceType.
             *                 Expressed in USD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder bidPrice(java.lang.String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getConfigurations}
             * @param configurations The list of configurations supplied for an EMR cluster instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration EBS configurations that will be attached to each EC2 instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ebsConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getMarket}
             * @param market Market type of the EC2 instances used to create a cluster node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder market(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market) {
                this.market = market;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupConfigProperty#getName}
             * @param name Friendly name given to the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceGroupConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceGroupConfigProperty build() {
                return new Jsii$Proxy(instanceCount, instanceRole, instanceType, autoScalingPolicy, bidPrice, configurations, ebsConfiguration, market, name);
            }
        }

        /**
         * An implementation for {@link InstanceGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceGroupConfigProperty {
            private final java.lang.Number instanceCount;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceRole;
            private final java.lang.String instanceType;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty autoScalingPolicy;
            private final java.lang.String bidPrice;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = this.jsiiGet("instanceCount", java.lang.Number.class);
                this.instanceRole = this.jsiiGet("instanceRole", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType.class);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.autoScalingPolicy = this.jsiiGet("autoScalingPolicy", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty.class);
                this.bidPrice = this.jsiiGet("bidPrice", java.lang.String.class);
                this.configurations = this.jsiiGet("configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.ebsConfiguration = this.jsiiGet("ebsConfiguration", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty.class);
                this.market = this.jsiiGet("market", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final java.lang.Number instanceCount, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType instanceRole, final java.lang.String instanceType, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty autoScalingPolicy, final java.lang.String bidPrice, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market, final java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(instanceCount, "instanceCount is required");
                this.instanceRole = java.util.Objects.requireNonNull(instanceRole, "instanceRole is required");
                this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
                this.autoScalingPolicy = autoScalingPolicy;
                this.bidPrice = bidPrice;
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                this.ebsConfiguration = ebsConfiguration;
                this.market = market;
                this.name = name;
            }

            @Override
            public java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceRoleType getInstanceRole() {
                return this.instanceRole;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.AutoScalingPolicyProperty getAutoScalingPolicy() {
                return this.autoScalingPolicy;
            }

            @Override
            public java.lang.String getBidPrice() {
                return this.bidPrice;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
                return this.ebsConfiguration;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
                return this.market;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getAutoScalingPolicy() != null) {
                    data.set("autoScalingPolicy", om.valueToTree(this.getAutoScalingPolicy()));
                }
                if (this.getBidPrice() != null) {
                    data.set("bidPrice", om.valueToTree(this.getBidPrice()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getEbsConfiguration() != null) {
                    data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
                }
                if (this.getMarket() != null) {
                    data.set("market", om.valueToTree(this.getMarket()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceGroupConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceGroupConfigProperty.Jsii$Proxy that = (InstanceGroupConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceRole.equals(that.instanceRole)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (this.autoScalingPolicy != null ? !this.autoScalingPolicy.equals(that.autoScalingPolicy) : that.autoScalingPolicy != null) return false;
                if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
                if (this.market != null ? !this.market.equals(that.market) : that.market != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceRole.hashCode());
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.autoScalingPolicy != null ? this.autoScalingPolicy.hashCode() : 0);
                result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
                result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * EC2 Instance Market.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceMarket")
    public enum InstanceMarket {
        /**
         * On Demand Instance.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        ON_DEMAND,
        /**
         * Spot Instance.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SPOT,
    }
    /**
     * Instance Role Types.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceRoleType")
    public enum InstanceRoleType {
        /**
         * Master Node.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        MASTER,
        /**
         * Core Node.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        CORE,
        /**
         * Task Node.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TASK,
    }
    /**
     * An instance type configuration for each instance type in an instance fleet, which determines the EC2 instances Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceTypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceTypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An EC2 instance type.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The bid price for each EC2 Spot instance type as defined by InstanceType.
         * <p>
         * Expressed in USD.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
            return null;
        }

        /**
         * The bid price, as a percentage of On-Demand price.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        /**
         * A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * The configuration of Amazon Elastic Block Storage (EBS) attached to each instance as defined by InstanceType.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
            return null;
        }

        /**
         * The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in the InstanceFleetConfig.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceTypeConfigProperty> {
            private java.lang.String instanceType;
            private java.lang.String bidPrice;
            private java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            private java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getInstanceType}
             * @param instanceType An EC2 instance type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPrice}
             * @param bidPrice The bid price for each EC2 Spot instance type as defined by InstanceType.
             *                 Expressed in USD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder bidPrice(java.lang.String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPriceAsPercentageOfOnDemandPrice}
             * @param bidPriceAsPercentageOfOnDemandPrice The bid price, as a percentage of On-Demand price.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder bidPriceAsPercentageOfOnDemandPrice(java.lang.Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getConfigurations}
             * @param configurations A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder configurations(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration The configuration of Amazon Elastic Block Storage (EBS) attached to each instance as defined by InstanceType.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ebsConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in the InstanceFleetConfig.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceTypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstanceTypeConfigProperty build() {
                return new Jsii$Proxy(instanceType, bidPrice, bidPriceAsPercentageOfOnDemandPrice, configurations, ebsConfiguration, weightedCapacity);
            }
        }

        /**
         * An implementation for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceTypeConfigProperty {
            private final java.lang.String instanceType;
            private final java.lang.String bidPrice;
            private final java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
                this.bidPrice = this.jsiiGet("bidPrice", java.lang.String.class);
                this.bidPriceAsPercentageOfOnDemandPrice = this.jsiiGet("bidPriceAsPercentageOfOnDemandPrice", java.lang.Number.class);
                this.configurations = this.jsiiGet("configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.ebsConfiguration = this.jsiiGet("ebsConfiguration", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty.class);
                this.weightedCapacity = this.jsiiGet("weightedCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final java.lang.String instanceType, final java.lang.String bidPrice, final java.lang.Number bidPriceAsPercentageOfOnDemandPrice, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty ebsConfiguration, final java.lang.Number weightedCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
                this.bidPrice = bidPrice;
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                this.configurations = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty>)configurations;
                this.ebsConfiguration = ebsConfiguration;
                this.weightedCapacity = weightedCapacity;
            }

            @Override
            public java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public java.lang.String getBidPrice() {
                return this.bidPrice;
            }

            @Override
            public java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
                return this.bidPriceAsPercentageOfOnDemandPrice;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsConfigurationProperty getEbsConfiguration() {
                return this.ebsConfiguration;
            }

            @Override
            public java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getBidPrice() != null) {
                    data.set("bidPrice", om.valueToTree(this.getBidPrice()));
                }
                if (this.getBidPriceAsPercentageOfOnDemandPrice() != null) {
                    data.set("bidPriceAsPercentageOfOnDemandPrice", om.valueToTree(this.getBidPriceAsPercentageOfOnDemandPrice()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getEbsConfiguration() != null) {
                    data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstanceTypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceTypeConfigProperty.Jsii$Proxy that = (InstanceTypeConfigProperty.Jsii$Proxy) o;

                if (!instanceType.equals(that.instanceType)) return false;
                if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
                if (this.bidPriceAsPercentageOfOnDemandPrice != null ? !this.bidPriceAsPercentageOfOnDemandPrice.equals(that.bidPriceAsPercentageOfOnDemandPrice) : that.bidPriceAsPercentageOfOnDemandPrice != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.instanceType.hashCode();
                result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
                result = 31 * result + (this.bidPriceAsPercentageOfOnDemandPrice != null ? this.bidPriceAsPercentageOfOnDemandPrice.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A specification of the number and type of Amazon EC2 instances.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_JobFlowInstancesConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstancesConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstancesConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstancesConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of additional Amazon EC2 security group IDs for the master node.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalMasterSecurityGroups() {
            return null;
        }

        /**
         * A list of additional Amazon EC2 security group IDs for the core and task nodes.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalSlaveSecurityGroups() {
            return null;
        }

        /**
         * The name of the EC2 key pair that can be used to ssh to the master node as the user called "hadoop.".
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2KeyName() {
            return null;
        }

        /**
         * Applies to clusters that use the uniform instance group configuration.
         * <p>
         * To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC),
         * set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch.
         * <p>
         * Default: EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2SubnetId() {
            return null;
        }

        /**
         * Applies to clusters that use the instance fleet configuration.
         * <p>
         * When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and
         * launches instances in the optimal subnet.
         * <p>
         * Default: EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEc2SubnetIds() {
            return null;
        }

        /**
         * The identifier of the Amazon EC2 security group for the master node.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmrManagedMasterSecurityGroup() {
            return null;
        }

        /**
         * The identifier of the Amazon EC2 security group for the core and task nodes.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmrManagedSlaveSecurityGroup() {
            return null;
        }

        /**
         * Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster.
         * <p>
         * Default: - 0.18 if the AmiVersion parameter is not set. If AmiVersion is set, the version of Hadoop for that AMI version is used.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getHadoopVersion() {
            return null;
        }

        /**
         * The number of EC2 instances in the cluster.
         * <p>
         * Default: 0
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> getInstanceFleets() {
            return null;
        }

        /**
         * Configuration for the instance groups in a cluster.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> getInstanceGroups() {
            return null;
        }

        /**
         * The EC2 instance type of the master node.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterInstanceType() {
            return null;
        }

        /**
         * The Availability Zone in which the cluster runs.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty getPlacement() {
            return null;
        }

        /**
         * The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessSecurityGroup() {
            return null;
        }

        /**
         * The EC2 instance type of the core and task nodes.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlaveInstanceType() {
            return null;
        }

        /**
         * Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
         * <p>
         * Default: false
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtected() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<InstancesConfigProperty> {
            private java.util.List<java.lang.String> additionalMasterSecurityGroups;
            private java.util.List<java.lang.String> additionalSlaveSecurityGroups;
            private java.lang.String ec2KeyName;
            private java.lang.String ec2SubnetId;
            private java.util.List<java.lang.String> ec2SubnetIds;
            private java.lang.String emrManagedMasterSecurityGroup;
            private java.lang.String emrManagedSlaveSecurityGroup;
            private java.lang.String hadoopVersion;
            private java.lang.Number instanceCount;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> instanceFleets;
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> instanceGroups;
            private java.lang.String masterInstanceType;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty placement;
            private java.lang.String serviceAccessSecurityGroup;
            private java.lang.String slaveInstanceType;
            private java.lang.Boolean terminationProtected;

            /**
             * Sets the value of {@link InstancesConfigProperty#getAdditionalMasterSecurityGroups}
             * @param additionalMasterSecurityGroups A list of additional Amazon EC2 security group IDs for the master node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder additionalMasterSecurityGroups(java.util.List<java.lang.String> additionalMasterSecurityGroups) {
                this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getAdditionalSlaveSecurityGroups}
             * @param additionalSlaveSecurityGroups A list of additional Amazon EC2 security group IDs for the core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder additionalSlaveSecurityGroups(java.util.List<java.lang.String> additionalSlaveSecurityGroups) {
                this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEc2KeyName}
             * @param ec2KeyName The name of the EC2 key pair that can be used to ssh to the master node as the user called "hadoop.".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ec2KeyName(java.lang.String ec2KeyName) {
                this.ec2KeyName = ec2KeyName;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEc2SubnetId}
             * @param ec2SubnetId Applies to clusters that use the uniform instance group configuration.
             *                    To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC),
             *                    set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ec2SubnetId(java.lang.String ec2SubnetId) {
                this.ec2SubnetId = ec2SubnetId;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEc2SubnetIds}
             * @param ec2SubnetIds Applies to clusters that use the instance fleet configuration.
             *                     When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and
             *                     launches instances in the optimal subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder ec2SubnetIds(java.util.List<java.lang.String> ec2SubnetIds) {
                this.ec2SubnetIds = ec2SubnetIds;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEmrManagedMasterSecurityGroup}
             * @param emrManagedMasterSecurityGroup The identifier of the Amazon EC2 security group for the master node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder emrManagedMasterSecurityGroup(java.lang.String emrManagedMasterSecurityGroup) {
                this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getEmrManagedSlaveSecurityGroup}
             * @param emrManagedSlaveSecurityGroup The identifier of the Amazon EC2 security group for the core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder emrManagedSlaveSecurityGroup(java.lang.String emrManagedSlaveSecurityGroup) {
                this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getHadoopVersion}
             * @param hadoopVersion Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder hadoopVersion(java.lang.String hadoopVersion) {
                this.hadoopVersion = hadoopVersion;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getInstanceCount}
             * @param instanceCount The number of EC2 instances in the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getInstanceFleets}
             * @param instanceFleets Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.
             *                       The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder instanceFleets(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> instanceFleets) {
                this.instanceFleets = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty>)instanceFleets;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getInstanceGroups}
             * @param instanceGroups Configuration for the instance groups in a cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @SuppressWarnings("unchecked")
            public Builder instanceGroups(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> instanceGroups) {
                this.instanceGroups = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty>)instanceGroups;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getMasterInstanceType}
             * @param masterInstanceType The EC2 instance type of the master node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder masterInstanceType(java.lang.String masterInstanceType) {
                this.masterInstanceType = masterInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getPlacement}
             * @param placement The Availability Zone in which the cluster runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder placement(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getServiceAccessSecurityGroup}
             * @param serviceAccessSecurityGroup The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder serviceAccessSecurityGroup(java.lang.String serviceAccessSecurityGroup) {
                this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getSlaveInstanceType}
             * @param slaveInstanceType The EC2 instance type of the core and task nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder slaveInstanceType(java.lang.String slaveInstanceType) {
                this.slaveInstanceType = slaveInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstancesConfigProperty#getTerminationProtected}
             * @param terminationProtected Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder terminationProtected(java.lang.Boolean terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstancesConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public InstancesConfigProperty build() {
                return new Jsii$Proxy(additionalMasterSecurityGroups, additionalSlaveSecurityGroups, ec2KeyName, ec2SubnetId, ec2SubnetIds, emrManagedMasterSecurityGroup, emrManagedSlaveSecurityGroup, hadoopVersion, instanceCount, instanceFleets, instanceGroups, masterInstanceType, placement, serviceAccessSecurityGroup, slaveInstanceType, terminationProtected);
            }
        }

        /**
         * An implementation for {@link InstancesConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstancesConfigProperty {
            private final java.util.List<java.lang.String> additionalMasterSecurityGroups;
            private final java.util.List<java.lang.String> additionalSlaveSecurityGroups;
            private final java.lang.String ec2KeyName;
            private final java.lang.String ec2SubnetId;
            private final java.util.List<java.lang.String> ec2SubnetIds;
            private final java.lang.String emrManagedMasterSecurityGroup;
            private final java.lang.String emrManagedSlaveSecurityGroup;
            private final java.lang.String hadoopVersion;
            private final java.lang.Number instanceCount;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> instanceFleets;
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> instanceGroups;
            private final java.lang.String masterInstanceType;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty placement;
            private final java.lang.String serviceAccessSecurityGroup;
            private final java.lang.String slaveInstanceType;
            private final java.lang.Boolean terminationProtected;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalMasterSecurityGroups = this.jsiiGet("additionalMasterSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.additionalSlaveSecurityGroups = this.jsiiGet("additionalSlaveSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.ec2KeyName = this.jsiiGet("ec2KeyName", java.lang.String.class);
                this.ec2SubnetId = this.jsiiGet("ec2SubnetId", java.lang.String.class);
                this.ec2SubnetIds = this.jsiiGet("ec2SubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.emrManagedMasterSecurityGroup = this.jsiiGet("emrManagedMasterSecurityGroup", java.lang.String.class);
                this.emrManagedSlaveSecurityGroup = this.jsiiGet("emrManagedSlaveSecurityGroup", java.lang.String.class);
                this.hadoopVersion = this.jsiiGet("hadoopVersion", java.lang.String.class);
                this.instanceCount = this.jsiiGet("instanceCount", java.lang.Number.class);
                this.instanceFleets = this.jsiiGet("instanceFleets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty.class)));
                this.instanceGroups = this.jsiiGet("instanceGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty.class)));
                this.masterInstanceType = this.jsiiGet("masterInstanceType", java.lang.String.class);
                this.placement = this.jsiiGet("placement", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty.class);
                this.serviceAccessSecurityGroup = this.jsiiGet("serviceAccessSecurityGroup", java.lang.String.class);
                this.slaveInstanceType = this.jsiiGet("slaveInstanceType", java.lang.String.class);
                this.terminationProtected = this.jsiiGet("terminationProtected", java.lang.Boolean.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            private Jsii$Proxy(final java.util.List<java.lang.String> additionalMasterSecurityGroups, final java.util.List<java.lang.String> additionalSlaveSecurityGroups, final java.lang.String ec2KeyName, final java.lang.String ec2SubnetId, final java.util.List<java.lang.String> ec2SubnetIds, final java.lang.String emrManagedMasterSecurityGroup, final java.lang.String emrManagedSlaveSecurityGroup, final java.lang.String hadoopVersion, final java.lang.Number instanceCount, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> instanceFleets, final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> instanceGroups, final java.lang.String masterInstanceType, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty placement, final java.lang.String serviceAccessSecurityGroup, final java.lang.String slaveInstanceType, final java.lang.Boolean terminationProtected) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
                this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
                this.ec2KeyName = ec2KeyName;
                this.ec2SubnetId = ec2SubnetId;
                this.ec2SubnetIds = ec2SubnetIds;
                this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
                this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
                this.hadoopVersion = hadoopVersion;
                this.instanceCount = instanceCount;
                this.instanceFleets = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty>)instanceFleets;
                this.instanceGroups = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty>)instanceGroups;
                this.masterInstanceType = masterInstanceType;
                this.placement = placement;
                this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
                this.slaveInstanceType = slaveInstanceType;
                this.terminationProtected = terminationProtected;
            }

            @Override
            public java.util.List<java.lang.String> getAdditionalMasterSecurityGroups() {
                return this.additionalMasterSecurityGroups;
            }

            @Override
            public java.util.List<java.lang.String> getAdditionalSlaveSecurityGroups() {
                return this.additionalSlaveSecurityGroups;
            }

            @Override
            public java.lang.String getEc2KeyName() {
                return this.ec2KeyName;
            }

            @Override
            public java.lang.String getEc2SubnetId() {
                return this.ec2SubnetId;
            }

            @Override
            public java.util.List<java.lang.String> getEc2SubnetIds() {
                return this.ec2SubnetIds;
            }

            @Override
            public java.lang.String getEmrManagedMasterSecurityGroup() {
                return this.emrManagedMasterSecurityGroup;
            }

            @Override
            public java.lang.String getEmrManagedSlaveSecurityGroup() {
                return this.emrManagedSlaveSecurityGroup;
            }

            @Override
            public java.lang.String getHadoopVersion() {
                return this.hadoopVersion;
            }

            @Override
            public java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceFleetConfigProperty> getInstanceFleets() {
                return this.instanceFleets;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceGroupConfigProperty> getInstanceGroups() {
                return this.instanceGroups;
            }

            @Override
            public java.lang.String getMasterInstanceType() {
                return this.masterInstanceType;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.PlacementTypeProperty getPlacement() {
                return this.placement;
            }

            @Override
            public java.lang.String getServiceAccessSecurityGroup() {
                return this.serviceAccessSecurityGroup;
            }

            @Override
            public java.lang.String getSlaveInstanceType() {
                return this.slaveInstanceType;
            }

            @Override
            public java.lang.Boolean getTerminationProtected() {
                return this.terminationProtected;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalMasterSecurityGroups() != null) {
                    data.set("additionalMasterSecurityGroups", om.valueToTree(this.getAdditionalMasterSecurityGroups()));
                }
                if (this.getAdditionalSlaveSecurityGroups() != null) {
                    data.set("additionalSlaveSecurityGroups", om.valueToTree(this.getAdditionalSlaveSecurityGroups()));
                }
                if (this.getEc2KeyName() != null) {
                    data.set("ec2KeyName", om.valueToTree(this.getEc2KeyName()));
                }
                if (this.getEc2SubnetId() != null) {
                    data.set("ec2SubnetId", om.valueToTree(this.getEc2SubnetId()));
                }
                if (this.getEc2SubnetIds() != null) {
                    data.set("ec2SubnetIds", om.valueToTree(this.getEc2SubnetIds()));
                }
                if (this.getEmrManagedMasterSecurityGroup() != null) {
                    data.set("emrManagedMasterSecurityGroup", om.valueToTree(this.getEmrManagedMasterSecurityGroup()));
                }
                if (this.getEmrManagedSlaveSecurityGroup() != null) {
                    data.set("emrManagedSlaveSecurityGroup", om.valueToTree(this.getEmrManagedSlaveSecurityGroup()));
                }
                if (this.getHadoopVersion() != null) {
                    data.set("hadoopVersion", om.valueToTree(this.getHadoopVersion()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getInstanceFleets() != null) {
                    data.set("instanceFleets", om.valueToTree(this.getInstanceFleets()));
                }
                if (this.getInstanceGroups() != null) {
                    data.set("instanceGroups", om.valueToTree(this.getInstanceGroups()));
                }
                if (this.getMasterInstanceType() != null) {
                    data.set("masterInstanceType", om.valueToTree(this.getMasterInstanceType()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getServiceAccessSecurityGroup() != null) {
                    data.set("serviceAccessSecurityGroup", om.valueToTree(this.getServiceAccessSecurityGroup()));
                }
                if (this.getSlaveInstanceType() != null) {
                    data.set("slaveInstanceType", om.valueToTree(this.getSlaveInstanceType()));
                }
                if (this.getTerminationProtected() != null) {
                    data.set("terminationProtected", om.valueToTree(this.getTerminationProtected()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.InstancesConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstancesConfigProperty.Jsii$Proxy that = (InstancesConfigProperty.Jsii$Proxy) o;

                if (this.additionalMasterSecurityGroups != null ? !this.additionalMasterSecurityGroups.equals(that.additionalMasterSecurityGroups) : that.additionalMasterSecurityGroups != null) return false;
                if (this.additionalSlaveSecurityGroups != null ? !this.additionalSlaveSecurityGroups.equals(that.additionalSlaveSecurityGroups) : that.additionalSlaveSecurityGroups != null) return false;
                if (this.ec2KeyName != null ? !this.ec2KeyName.equals(that.ec2KeyName) : that.ec2KeyName != null) return false;
                if (this.ec2SubnetId != null ? !this.ec2SubnetId.equals(that.ec2SubnetId) : that.ec2SubnetId != null) return false;
                if (this.ec2SubnetIds != null ? !this.ec2SubnetIds.equals(that.ec2SubnetIds) : that.ec2SubnetIds != null) return false;
                if (this.emrManagedMasterSecurityGroup != null ? !this.emrManagedMasterSecurityGroup.equals(that.emrManagedMasterSecurityGroup) : that.emrManagedMasterSecurityGroup != null) return false;
                if (this.emrManagedSlaveSecurityGroup != null ? !this.emrManagedSlaveSecurityGroup.equals(that.emrManagedSlaveSecurityGroup) : that.emrManagedSlaveSecurityGroup != null) return false;
                if (this.hadoopVersion != null ? !this.hadoopVersion.equals(that.hadoopVersion) : that.hadoopVersion != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                if (this.instanceFleets != null ? !this.instanceFleets.equals(that.instanceFleets) : that.instanceFleets != null) return false;
                if (this.instanceGroups != null ? !this.instanceGroups.equals(that.instanceGroups) : that.instanceGroups != null) return false;
                if (this.masterInstanceType != null ? !this.masterInstanceType.equals(that.masterInstanceType) : that.masterInstanceType != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.serviceAccessSecurityGroup != null ? !this.serviceAccessSecurityGroup.equals(that.serviceAccessSecurityGroup) : that.serviceAccessSecurityGroup != null) return false;
                if (this.slaveInstanceType != null ? !this.slaveInstanceType.equals(that.slaveInstanceType) : that.slaveInstanceType != null) return false;
                return this.terminationProtected != null ? this.terminationProtected.equals(that.terminationProtected) : that.terminationProtected == null;
            }

            @Override
            public int hashCode() {
                int result = this.additionalMasterSecurityGroups != null ? this.additionalMasterSecurityGroups.hashCode() : 0;
                result = 31 * result + (this.additionalSlaveSecurityGroups != null ? this.additionalSlaveSecurityGroups.hashCode() : 0);
                result = 31 * result + (this.ec2KeyName != null ? this.ec2KeyName.hashCode() : 0);
                result = 31 * result + (this.ec2SubnetId != null ? this.ec2SubnetId.hashCode() : 0);
                result = 31 * result + (this.ec2SubnetIds != null ? this.ec2SubnetIds.hashCode() : 0);
                result = 31 * result + (this.emrManagedMasterSecurityGroup != null ? this.emrManagedMasterSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.emrManagedSlaveSecurityGroup != null ? this.emrManagedSlaveSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.hadoopVersion != null ? this.hadoopVersion.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.instanceFleets != null ? this.instanceFleets.hashCode() : 0);
                result = 31 * result + (this.instanceGroups != null ? this.instanceGroups.hashCode() : 0);
                result = 31 * result + (this.masterInstanceType != null ? this.masterInstanceType.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.serviceAccessSecurityGroup != null ? this.serviceAccessSecurityGroup.hashCode() : 0);
                result = 31 * result + (this.slaveInstanceType != null ? this.slaveInstanceType.hashCode() : 0);
                result = 31 * result + (this.terminationProtected != null ? this.terminationProtected.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * See the RunJobFlow API for complete documentation on input parameters
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_KerberosAttributes.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.KerberosAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(KerberosAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface KerberosAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Kerberos realm to which all nodes in a cluster belong.
         * <p>
         * For example, EC2.INTERNAL.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getRealm();

        /**
         * The Active Directory password for ADDomainJoinUser.
         * <p>
         * Default: No adDomainJoinPassword
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdDomainJoinPassword() {
            return null;
        }

        /**
         * Required only when establishing a cross-realm trust with an Active Directory domain.
         * <p>
         * A user with sufficient privileges to join
         * resources to the domain.
         * <p>
         * Default: No adDomainJoinUser
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdDomainJoinUser() {
            return null;
        }

        /**
         * Required only when establishing a cross-realm trust with a KDC in a different realm.
         * <p>
         * The cross-realm principal password, which
         * must be identical across realms.
         * <p>
         * Default: No crossRealmTrustPrincipalPassword
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossRealmTrustPrincipalPassword() {
            return null;
        }

        /**
         * The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
         * <p>
         * Default: No kdcAdminPassword
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getKdcAdminPassword() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<KerberosAttributesProperty> {
            private java.lang.String realm;
            private java.lang.String adDomainJoinPassword;
            private java.lang.String adDomainJoinUser;
            private java.lang.String crossRealmTrustPrincipalPassword;
            private java.lang.String kdcAdminPassword;

            /**
             * Sets the value of {@link KerberosAttributesProperty#getRealm}
             * @param realm The name of the Kerberos realm to which all nodes in a cluster belong. This parameter is required.
             *              For example, EC2.INTERNAL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder realm(java.lang.String realm) {
                this.realm = realm;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getAdDomainJoinPassword}
             * @param adDomainJoinPassword The Active Directory password for ADDomainJoinUser.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder adDomainJoinPassword(java.lang.String adDomainJoinPassword) {
                this.adDomainJoinPassword = adDomainJoinPassword;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getAdDomainJoinUser}
             * @param adDomainJoinUser Required only when establishing a cross-realm trust with an Active Directory domain.
             *                         A user with sufficient privileges to join
             *                         resources to the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder adDomainJoinUser(java.lang.String adDomainJoinUser) {
                this.adDomainJoinUser = adDomainJoinUser;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getCrossRealmTrustPrincipalPassword}
             * @param crossRealmTrustPrincipalPassword Required only when establishing a cross-realm trust with a KDC in a different realm.
             *                                         The cross-realm principal password, which
             *                                         must be identical across realms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder crossRealmTrustPrincipalPassword(java.lang.String crossRealmTrustPrincipalPassword) {
                this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
                return this;
            }

            /**
             * Sets the value of {@link KerberosAttributesProperty#getKdcAdminPassword}
             * @param kdcAdminPassword The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder kdcAdminPassword(java.lang.String kdcAdminPassword) {
                this.kdcAdminPassword = kdcAdminPassword;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KerberosAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public KerberosAttributesProperty build() {
                return new Jsii$Proxy(realm, adDomainJoinPassword, adDomainJoinUser, crossRealmTrustPrincipalPassword, kdcAdminPassword);
            }
        }

        /**
         * An implementation for {@link KerberosAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KerberosAttributesProperty {
            private final java.lang.String realm;
            private final java.lang.String adDomainJoinPassword;
            private final java.lang.String adDomainJoinUser;
            private final java.lang.String crossRealmTrustPrincipalPassword;
            private final java.lang.String kdcAdminPassword;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.realm = this.jsiiGet("realm", java.lang.String.class);
                this.adDomainJoinPassword = this.jsiiGet("adDomainJoinPassword", java.lang.String.class);
                this.adDomainJoinUser = this.jsiiGet("adDomainJoinUser", java.lang.String.class);
                this.crossRealmTrustPrincipalPassword = this.jsiiGet("crossRealmTrustPrincipalPassword", java.lang.String.class);
                this.kdcAdminPassword = this.jsiiGet("kdcAdminPassword", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String realm, final java.lang.String adDomainJoinPassword, final java.lang.String adDomainJoinUser, final java.lang.String crossRealmTrustPrincipalPassword, final java.lang.String kdcAdminPassword) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.realm = java.util.Objects.requireNonNull(realm, "realm is required");
                this.adDomainJoinPassword = adDomainJoinPassword;
                this.adDomainJoinUser = adDomainJoinUser;
                this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
                this.kdcAdminPassword = kdcAdminPassword;
            }

            @Override
            public java.lang.String getRealm() {
                return this.realm;
            }

            @Override
            public java.lang.String getAdDomainJoinPassword() {
                return this.adDomainJoinPassword;
            }

            @Override
            public java.lang.String getAdDomainJoinUser() {
                return this.adDomainJoinUser;
            }

            @Override
            public java.lang.String getCrossRealmTrustPrincipalPassword() {
                return this.crossRealmTrustPrincipalPassword;
            }

            @Override
            public java.lang.String getKdcAdminPassword() {
                return this.kdcAdminPassword;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("realm", om.valueToTree(this.getRealm()));
                if (this.getAdDomainJoinPassword() != null) {
                    data.set("adDomainJoinPassword", om.valueToTree(this.getAdDomainJoinPassword()));
                }
                if (this.getAdDomainJoinUser() != null) {
                    data.set("adDomainJoinUser", om.valueToTree(this.getAdDomainJoinUser()));
                }
                if (this.getCrossRealmTrustPrincipalPassword() != null) {
                    data.set("crossRealmTrustPrincipalPassword", om.valueToTree(this.getCrossRealmTrustPrincipalPassword()));
                }
                if (this.getKdcAdminPassword() != null) {
                    data.set("kdcAdminPassword", om.valueToTree(this.getKdcAdminPassword()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.KerberosAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KerberosAttributesProperty.Jsii$Proxy that = (KerberosAttributesProperty.Jsii$Proxy) o;

                if (!realm.equals(that.realm)) return false;
                if (this.adDomainJoinPassword != null ? !this.adDomainJoinPassword.equals(that.adDomainJoinPassword) : that.adDomainJoinPassword != null) return false;
                if (this.adDomainJoinUser != null ? !this.adDomainJoinUser.equals(that.adDomainJoinUser) : that.adDomainJoinUser != null) return false;
                if (this.crossRealmTrustPrincipalPassword != null ? !this.crossRealmTrustPrincipalPassword.equals(that.crossRealmTrustPrincipalPassword) : that.crossRealmTrustPrincipalPassword != null) return false;
                return this.kdcAdminPassword != null ? this.kdcAdminPassword.equals(that.kdcAdminPassword) : that.kdcAdminPassword == null;
            }

            @Override
            public int hashCode() {
                int result = this.realm.hashCode();
                result = 31 * result + (this.adDomainJoinPassword != null ? this.adDomainJoinPassword.hashCode() : 0);
                result = 31 * result + (this.adDomainJoinUser != null ? this.adDomainJoinUser.hashCode() : 0);
                result = 31 * result + (this.crossRealmTrustPrincipalPassword != null ? this.crossRealmTrustPrincipalPassword.hashCode() : 0);
                result = 31 * result + (this.kdcAdminPassword != null ? this.kdcAdminPassword.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A CloudWatch dimension, which is specified using a Key (known as a Name in CloudWatch), Value pair.
     * <p>
     * By default, Amazon EMR uses
     * one dimension whose Key is JobFlowID and Value is a variable representing the cluster ID, which is ${emr.clusterId}. This enables
     * the rule to bootstrap when the cluster ID becomes available
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_MetricDimension.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimension name.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The dimension value.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            private java.lang.String key;
            private java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getKey}
             * @param key The dimension name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The dimension value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(key, value);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String key, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The Amazon EC2 Availability Zone configuration of the cluster (job flow).
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_PlacementType.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.PlacementTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface PlacementTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EC2 Availability Zone for the cluster.
         * <p>
         * AvailabilityZone is used for uniform instance groups, while AvailabilityZones
         * (plural) is used for instance fleets.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * When multiple Availability Zones are specified, Amazon EMR evaluates them and launches instances in the optimal Availability Zone.
         * <p>
         * AvailabilityZones is used for instance fleets, while AvailabilityZone (singular) is used for uniform instance groups.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementTypeProperty> {
            private java.lang.String availabilityZone;
            private java.util.List<java.lang.String> availabilityZones;

            /**
             * Sets the value of {@link PlacementTypeProperty#getAvailabilityZone}
             * @param availabilityZone The Amazon EC2 Availability Zone for the cluster.
             *                         AvailabilityZone is used for uniform instance groups, while AvailabilityZones
             *                         (plural) is used for instance fleets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementTypeProperty#getAvailabilityZones}
             * @param availabilityZones When multiple Availability Zones are specified, Amazon EMR evaluates them and launches instances in the optimal Availability Zone.
             *                          AvailabilityZones is used for instance fleets, while AvailabilityZone (singular) is used for uniform instance groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public PlacementTypeProperty build() {
                return new Jsii$Proxy(availabilityZone, availabilityZones);
            }
        }

        /**
         * An implementation for {@link PlacementTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementTypeProperty {
            private final java.lang.String availabilityZone;
            private final java.util.List<java.lang.String> availabilityZones;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
                this.availabilityZones = this.jsiiGet("availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String availabilityZone, final java.util.List<java.lang.String> availabilityZones) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = availabilityZone;
                this.availabilityZones = availabilityZones;
            }

            @Override
            public java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public java.util.List<java.lang.String> getAvailabilityZones() {
                return this.availabilityZones;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getAvailabilityZones() != null) {
                    data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.PlacementTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementTypeProperty.Jsii$Proxy that = (PlacementTypeProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                return this.availabilityZones != null ? this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones == null;
            }

            @Override
            public int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
     * <p>
     * And an automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period,
     * and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingAction.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty getSimpleScalingPolicyConfiguration();

        /**
         * Not available for instance groups.
         * <p>
         * Instance groups use the market type specified for the group.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingActionProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;

            /**
             * Sets the value of {@link ScalingActionProperty#getSimpleScalingPolicyConfiguration}
             * @param simpleScalingPolicyConfiguration The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder simpleScalingPolicyConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingActionProperty#getMarket}
             * @param market Not available for instance groups.
             *               Instance groups use the market type specified for the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder market(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market) {
                this.market = market;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingActionProperty build() {
                return new Jsii$Proxy(simpleScalingPolicyConfiguration, market);
            }
        }

        /**
         * An implementation for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingActionProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.simpleScalingPolicyConfiguration = this.jsiiGet("simpleScalingPolicyConfiguration", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty.class);
                this.market = this.jsiiGet("market", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket market) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.simpleScalingPolicyConfiguration = java.util.Objects.requireNonNull(simpleScalingPolicyConfiguration, "simpleScalingPolicyConfiguration is required");
                this.market = market;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty getSimpleScalingPolicyConfiguration() {
                return this.simpleScalingPolicyConfiguration;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstanceMarket getMarket() {
                return this.market;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("simpleScalingPolicyConfiguration", om.valueToTree(this.getSimpleScalingPolicyConfiguration()));
                if (this.getMarket() != null) {
                    data.set("market", om.valueToTree(this.getMarket()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingActionProperty.Jsii$Proxy that = (ScalingActionProperty.Jsii$Proxy) o;

                if (!simpleScalingPolicyConfiguration.equals(that.simpleScalingPolicyConfiguration)) return false;
                return this.market != null ? this.market.equals(that.market) : that.market == null;
            }

            @Override
            public int hashCode() {
                int result = this.simpleScalingPolicyConfiguration.hashCode();
                result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * AutoScaling Adjustment Type.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingAdjustmentType")
    public enum ScalingAdjustmentType {
        /**
         * CHANGE_IN_CAPACITY.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        CHANGE_IN_CAPACITY,
        /**
         * PERCENT_CHANGE_IN_CAPACITY.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        PERCENT_CHANGE_IN_CAPACITY,
        /**
         * EXACT_CAPACITY.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        EXACT_CAPACITY,
    }
    /**
     * The upper and lower EC2 instance limits for an automatic scaling policy.
     * <p>
     * Automatic scaling activities triggered by automatic scaling
     * rules will not cause an instance group to grow above or below these limits.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingConstraints.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConstraintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingConstraintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow.
         * <p>
         * Scale-out
         * activities will not add instances beyond this boundary.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

        /**
         * The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink.
         * <p>
         * Scale-in
         * activities will not terminate instances below this boundary.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

        /**
         * @return a {@link Builder} of {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConstraintsProperty> {
            private java.lang.Number maxCapacity;
            private java.lang.Number minCapacity;

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMaxCapacity}
             * @param maxCapacity The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow. This parameter is required.
             *                    Scale-out
             *                    activities will not add instances beyond this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMinCapacity}
             * @param minCapacity The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink. This parameter is required.
             *                    Scale-in
             *                    activities will not terminate instances below this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConstraintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingConstraintsProperty build() {
                return new Jsii$Proxy(maxCapacity, minCapacity);
            }
        }

        /**
         * An implementation for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConstraintsProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = this.jsiiGet("maxCapacity", java.lang.Number.class);
                this.minCapacity = this.jsiiGet("minCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number maxCapacity, final java.lang.Number minCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = java.util.Objects.requireNonNull(maxCapacity, "maxCapacity is required");
                this.minCapacity = java.util.Objects.requireNonNull(minCapacity, "minCapacity is required");
            }

            @Override
            public java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingConstraintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConstraintsProperty.Jsii$Proxy that = (ScalingConstraintsProperty.Jsii$Proxy) o;

                if (!maxCapacity.equals(that.maxCapacity)) return false;
                return this.minCapacity.equals(that.minCapacity);
            }

            @Override
            public int hashCode() {
                int result = this.maxCapacity.hashCode();
                result = 31 * result + (this.minCapacity.hashCode());
                return result;
            }
        }
    }
    /**
     * A scale-in or scale-out rule that defines scaling activity, including the CloudWatch metric alarm that triggers activity, how EC2 instances are added or removed, and the periodicity of adjustments.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingRule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The conditions that trigger an automatic scaling activity.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty getAction();

        /**
         * The name used to identify an automatic scaling rule.
         * <p>
         * Rule names must be unique within a scaling policy.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty getTrigger();

        /**
         * A friendly, more verbose description of the automatic scaling rule.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingRuleProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty action;
            private java.lang.String name;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty trigger;
            private java.lang.String description;

            /**
             * Sets the value of {@link ScalingRuleProperty#getAction}
             * @param action The conditions that trigger an automatic scaling activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder action(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getName}
             * @param name The name used to identify an automatic scaling rule. This parameter is required.
             *             Rule names must be unique within a scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getTrigger}
             * @param trigger The CloudWatch alarm definition that determines when automatic scaling activity is triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder trigger(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getDescription}
             * @param description A friendly, more verbose description of the automatic scaling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingRuleProperty build() {
                return new Jsii$Proxy(action, name, trigger, description);
            }
        }

        /**
         * An implementation for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingRuleProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty action;
            private final java.lang.String name;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty trigger;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = this.jsiiGet("action", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.trigger = this.jsiiGet("trigger", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty action, final java.lang.String name, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty trigger, final java.lang.String description) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(action, "action is required");
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.trigger = java.util.Objects.requireNonNull(trigger, "trigger is required");
                this.description = description;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingActionProperty getAction() {
                return this.action;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingTriggerProperty getTrigger() {
                return this.trigger;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("trigger", om.valueToTree(this.getTrigger()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingRuleProperty.Jsii$Proxy that = (ScalingRuleProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!name.equals(that.name)) return false;
                if (!trigger.equals(that.trigger)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.trigger.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The conditions that trigger an automatic scaling activity and the definition of a CloudWatch metric alarm.
     * <p>
     * When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingTrigger.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingTriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScalingTriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The definition of a CloudWatch metric alarm.
         * <p>
         * When the defined alarm conditions are met along with other trigger parameters,
         * scaling activity begins.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty getCloudWatchAlarmDefinition();

        /**
         * @return a {@link Builder} of {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingTriggerProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition;

            /**
             * Sets the value of {@link ScalingTriggerProperty#getCloudWatchAlarmDefinition}
             * @param cloudWatchAlarmDefinition The definition of a CloudWatch metric alarm. This parameter is required.
             *                                  When the defined alarm conditions are met along with other trigger parameters,
             *                                  scaling activity begins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder cloudWatchAlarmDefinition(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingTriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScalingTriggerProperty build() {
                return new Jsii$Proxy(cloudWatchAlarmDefinition);
            }
        }

        /**
         * An implementation for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingTriggerProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchAlarmDefinition = this.jsiiGet("cloudWatchAlarmDefinition", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchAlarmDefinition = java.util.Objects.requireNonNull(cloudWatchAlarmDefinition, "cloudWatchAlarmDefinition is required");
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.CloudWatchAlarmDefinitionProperty getCloudWatchAlarmDefinition() {
                return this.cloudWatchAlarmDefinition;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchAlarmDefinition", om.valueToTree(this.getCloudWatchAlarmDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScalingTriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingTriggerProperty.Jsii$Proxy that = (ScalingTriggerProperty.Jsii$Proxy) o;

                return this.cloudWatchAlarmDefinition.equals(that.cloudWatchAlarmDefinition);
            }

            @Override
            public int hashCode() {
                int result = this.cloudWatchAlarmDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration of the script to run during a bootstrap action.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScriptBootstrapActionConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ScriptBootstrapActionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ScriptBootstrapActionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Location of the script to run during a bootstrap action.
         * <p>
         * Can be either a location in Amazon S3 or on a local file system.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.String getPath();

        /**
         * A list of command line arguments to pass to the bootstrap action script.
         * <p>
         * Default: No args
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<ScriptBootstrapActionConfigProperty> {
            private java.lang.String path;
            private java.util.List<java.lang.String> args;

            /**
             * Sets the value of {@link ScriptBootstrapActionConfigProperty#getPath}
             * @param path Location of the script to run during a bootstrap action. This parameter is required.
             *             Can be either a location in Amazon S3 or on a local file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link ScriptBootstrapActionConfigProperty#getArgs}
             * @param args A list of command line arguments to pass to the bootstrap action script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScriptBootstrapActionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public ScriptBootstrapActionConfigProperty build() {
                return new Jsii$Proxy(path, args);
            }
        }

        /**
         * An implementation for {@link ScriptBootstrapActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScriptBootstrapActionConfigProperty {
            private final java.lang.String path;
            private final java.util.List<java.lang.String> args;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = this.jsiiGet("path", java.lang.String.class);
                this.args = this.jsiiGet("args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String path, final java.util.List<java.lang.String> args) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = java.util.Objects.requireNonNull(path, "path is required");
                this.args = args;
            }

            @Override
            public java.lang.String getPath() {
                return this.path;
            }

            @Override
            public java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("path", om.valueToTree(this.getPath()));
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.ScriptBootstrapActionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScriptBootstrapActionConfigProperty.Jsii$Proxy that = (ScriptBootstrapActionConfigProperty.Jsii$Proxy) o;

                if (!path.equals(that.path)) return false;
                return this.args != null ? this.args.equals(that.args) : that.args == null;
            }

            @Override
            public int hashCode() {
                int result = this.path.hashCode();
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period, and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_SimpleScalingPolicyConfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SimpleScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface SimpleScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount by which to scale in or scale out, based on the specified AdjustmentType.
         * <p>
         * A positive value adds to the instance group's
         * EC2 instance count while a negative number removes instances. If AdjustmentType is set to EXACT_CAPACITY, the number should only be
         * a positive integer.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getScalingAdjustment();

        /**
         * The way in which EC2 instances are added (if ScalingAdjustment is a positive number) or terminated (if ScalingAdjustment is a negative number) each time the scaling activity is triggered.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType getAdjustmentType() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
         * <p>
         * Default: 0
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoolDown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<SimpleScalingPolicyConfigurationProperty> {
            private java.lang.Number scalingAdjustment;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType adjustmentType;
            private java.lang.Number coolDown;

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getScalingAdjustment}
             * @param scalingAdjustment The amount by which to scale in or scale out, based on the specified AdjustmentType. This parameter is required.
             *                          A positive value adds to the instance group's
             *                          EC2 instance count while a negative number removes instances. If AdjustmentType is set to EXACT_CAPACITY, the number should only be
             *                          a positive integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getAdjustmentType}
             * @param adjustmentType The way in which EC2 instances are added (if ScalingAdjustment is a positive number) or terminated (if ScalingAdjustment is a negative number) each time the scaling activity is triggered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder adjustmentType(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getCoolDown}
             * @param coolDown The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder coolDown(java.lang.Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimpleScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(scalingAdjustment, adjustmentType, coolDown);
            }
        }

        /**
         * An implementation for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimpleScalingPolicyConfigurationProperty {
            private final java.lang.Number scalingAdjustment;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType adjustmentType;
            private final java.lang.Number coolDown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scalingAdjustment = this.jsiiGet("scalingAdjustment", java.lang.Number.class);
                this.adjustmentType = this.jsiiGet("adjustmentType", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType.class);
                this.coolDown = this.jsiiGet("coolDown", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number scalingAdjustment, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType adjustmentType, final java.lang.Number coolDown) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scalingAdjustment = java.util.Objects.requireNonNull(scalingAdjustment, "scalingAdjustment is required");
                this.adjustmentType = adjustmentType;
                this.coolDown = coolDown;
            }

            @Override
            public java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ScalingAdjustmentType getAdjustmentType() {
                return this.adjustmentType;
            }

            @Override
            public java.lang.Number getCoolDown() {
                return this.coolDown;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                if (this.getAdjustmentType() != null) {
                    data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
                }
                if (this.getCoolDown() != null) {
                    data.set("coolDown", om.valueToTree(this.getCoolDown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SimpleScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimpleScalingPolicyConfigurationProperty.Jsii$Proxy that = (SimpleScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!scalingAdjustment.equals(that.scalingAdjustment)) return false;
                if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
                return this.coolDown != null ? this.coolDown.equals(that.coolDown) : that.coolDown == null;
            }

            @Override
            public int hashCode() {
                int result = this.scalingAdjustment.hashCode();
                result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
                result = 31 * result + (this.coolDown != null ? this.coolDown.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The launch specification for Spot instances in the instance fleet, which determines the defined duration and provisioning timeout behavior.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_SpotProvisioningSpecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotProvisioningSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface SpotProvisioningSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction getTimeoutAction();

        /**
         * The spot provisioning timeout period in minutes.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutDurationMinutes();

        /**
         * The defined duration for Spot instances (also known as Spot blocks) in minutes.
         * <p>
         * Default: No blockDurationMinutes
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockDurationMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<SpotProvisioningSpecificationProperty> {
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction timeoutAction;
            private java.lang.Number timeoutDurationMinutes;
            private java.lang.Number blockDurationMinutes;

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutAction}
             * @param timeoutAction The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder timeoutAction(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutDurationMinutes}
             * @param timeoutDurationMinutes The spot provisioning timeout period in minutes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder timeoutDurationMinutes(java.lang.Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getBlockDurationMinutes}
             * @param blockDurationMinutes The defined duration for Spot instances (also known as Spot blocks) in minutes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder blockDurationMinutes(java.lang.Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotProvisioningSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public SpotProvisioningSpecificationProperty build() {
                return new Jsii$Proxy(timeoutAction, timeoutDurationMinutes, blockDurationMinutes);
            }
        }

        /**
         * An implementation for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotProvisioningSpecificationProperty {
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction timeoutAction;
            private final java.lang.Number timeoutDurationMinutes;
            private final java.lang.Number blockDurationMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeoutAction = this.jsiiGet("timeoutAction", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction.class);
                this.timeoutDurationMinutes = this.jsiiGet("timeoutDurationMinutes", java.lang.Number.class);
                this.blockDurationMinutes = this.jsiiGet("blockDurationMinutes", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction timeoutAction, final java.lang.Number timeoutDurationMinutes, final java.lang.Number blockDurationMinutes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeoutAction = java.util.Objects.requireNonNull(timeoutAction, "timeoutAction is required");
                this.timeoutDurationMinutes = java.util.Objects.requireNonNull(timeoutDurationMinutes, "timeoutDurationMinutes is required");
                this.blockDurationMinutes = blockDurationMinutes;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.SpotTimeoutAction getTimeoutAction() {
                return this.timeoutAction;
            }

            @Override
            public java.lang.Number getTimeoutDurationMinutes() {
                return this.timeoutDurationMinutes;
            }

            @Override
            public java.lang.Number getBlockDurationMinutes() {
                return this.blockDurationMinutes;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeoutAction", om.valueToTree(this.getTimeoutAction()));
                data.set("timeoutDurationMinutes", om.valueToTree(this.getTimeoutDurationMinutes()));
                if (this.getBlockDurationMinutes() != null) {
                    data.set("blockDurationMinutes", om.valueToTree(this.getBlockDurationMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SpotProvisioningSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotProvisioningSpecificationProperty.Jsii$Proxy that = (SpotProvisioningSpecificationProperty.Jsii$Proxy) o;

                if (!timeoutAction.equals(that.timeoutAction)) return false;
                if (!timeoutDurationMinutes.equals(that.timeoutDurationMinutes)) return false;
                return this.blockDurationMinutes != null ? this.blockDurationMinutes.equals(that.blockDurationMinutes) : that.blockDurationMinutes == null;
            }

            @Override
            public int hashCode() {
                int result = this.timeoutAction.hashCode();
                result = 31 * result + (this.timeoutDurationMinutes.hashCode());
                result = 31 * result + (this.blockDurationMinutes != null ? this.blockDurationMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Spot Timeout Actions.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.SpotTimeoutAction")
    public enum SpotTimeoutAction {
        /**
         * \ SWITCH_TO_ON_DEMAND.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        SWITCH_TO_ON_DEMAND,
        /**
         * TERMINATE_CLUSTER.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        TERMINATE_CLUSTER,
    }
    /**
     * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_VolumeSpecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface VolumeSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The volume size.
         * <p>
         * If the volume type is EBS-optimized, the minimum value is 10GiB.
         * Maximum size is 1TiB
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size getVolumeSize();

        /**
         * The volume type.
         * <p>
         * Volume types supported are gp2, io1, standard.
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType getVolumeType();

        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            private software.amazon.awscdk.core.Size volumeSize;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType volumeType;
            private java.lang.Number iops;

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getVolumeSize}
             * @param volumeSize The volume size. This parameter is required.
             *                   If the volume type is EBS-optimized, the minimum value is 10GiB.
             *                   Maximum size is 1TiB
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumeSize(software.amazon.awscdk.core.Size volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getVolumeType}
             * @param volumeType The volume type. This parameter is required.
             *                   Volume types supported are gp2, io1, standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder volumeType(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) that the volume supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            @Override
            public VolumeSpecificationProperty build() {
                return new Jsii$Proxy(volumeSize, volumeType, iops);
            }
        }

        /**
         * An implementation for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeSpecificationProperty {
            private final software.amazon.awscdk.core.Size volumeSize;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType volumeType;
            private final java.lang.Number iops;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSize = this.jsiiGet("volumeSize", software.amazon.awscdk.core.Size.class);
                this.volumeType = this.jsiiGet("volumeType", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType.class);
                this.iops = this.jsiiGet("iops", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.core.Size volumeSize, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType volumeType, final java.lang.Number iops) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSize = java.util.Objects.requireNonNull(volumeSize, "volumeSize is required");
                this.volumeType = java.util.Objects.requireNonNull(volumeType, "volumeType is required");
                this.iops = iops;
            }

            @Override
            public software.amazon.awscdk.core.Size getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType getVolumeType() {
                return this.volumeType;
            }

            @Override
            public java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateCluster.VolumeSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeSpecificationProperty.Jsii$Proxy that = (VolumeSpecificationProperty.Jsii$Proxy) o;

                if (!volumeSize.equals(that.volumeSize)) return false;
                if (!volumeType.equals(that.volumeType)) return false;
                return this.iops != null ? this.iops.equals(that.iops) : that.iops == null;
            }

            @Override
            public int hashCode() {
                int result = this.volumeSize.hashCode();
                result = 31 * result + (this.volumeType.hashCode());
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateClusterProps.Builder();
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(final software.amazon.awscdk.core.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns
         * <p>
         * Default: IntegrationPattern.REQUEST_RESPONSE
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * Timeout for the state machine.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param timeout Timeout for the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * A specification of the number and type of Amazon EC2 instances.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instances(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * The Name of the Cluster.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param name The Name of the Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A JSON string for selecting additional features.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param additionalInfo A JSON string for selecting additional features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder additionalInfo(final java.lang.String additionalInfo) {
            this.props.additionalInfo(additionalInfo);
            return this;
        }

        /**
         * A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applications(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications) {
            this.props.applications(applications);
            return this;
        }

        /**
         * An IAM role for automatic scaling policies.
         * <p>
         * Default: - A role will be created.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param autoScalingRole An IAM role for automatic scaling policies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingRole(final software.amazon.awscdk.services.iam.IRole autoScalingRole) {
            this.props.autoScalingRole(autoScalingRole);
            return this;
        }

        /**
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bootstrapActions(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }

        /**
         * Also called instance profile and EC2 role.
         * <p>
         * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
         * <p>
         * This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
         * <p>
         * Default: - * A Role will be created
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param clusterRole Also called instance profile and EC2 role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterRole(final software.amazon.awscdk.services.iam.IRole clusterRole) {
            this.props.clusterRole(clusterRole);
            return this;
        }

        /**
         * The list of configurations supplied for the EMR cluster you are creating.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param configurations The list of configurations supplied for the EMR cluster you are creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurations(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        /**
         * The ID of a custom Amazon EBS-backed Linux AMI.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param customAmiId The ID of a custom Amazon EBS-backed Linux AMI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customAmiId(final java.lang.String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        /**
         * The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param ebsRootVolumeSize The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ebsRootVolumeSize(final software.amazon.awscdk.core.Size ebsRootVolumeSize) {
            this.props.ebsRootVolumeSize(ebsRootVolumeSize);
            return this;
        }

        /**
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kerberosAttributes(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }

        /**
         * The location in Amazon S3 to write the log files of the job flow.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param logUri The location in Amazon S3 to write the log files of the job flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logUri(final java.lang.String logUri) {
            this.props.logUri(logUri);
            return this;
        }

        /**
         * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param releaseLabel The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseLabel(final java.lang.String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        /**
         * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
         * <p>
         * Default: - EMR selected default
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param scaleDownBehavior Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scaleDownBehavior(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior) {
            this.props.scaleDownBehavior(scaleDownBehavior);
            return this;
        }

        /**
         * The name of a security configuration to apply to the cluster.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param securityConfiguration The name of a security configuration to apply to the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfiguration(final java.lang.String securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        /**
         * The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
         * <p>
         * Default: - A role will be created that Amazon EMR service can assume.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param tags A list of tags to associate with a cluster and propagate to Amazon EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
         * <p>
         * Default: true
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param visibleToAllUsers A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder visibleToAllUsers(final java.lang.Boolean visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
