package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for EvaluateExpression.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-10-01T01:50:03.839Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EvaluateExpressionProps")
@software.amazon.jsii.Jsii.Proxy(EvaluateExpressionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EvaluateExpressionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * The expression to evaluate.
     * <p>
     * The expression may contain state paths.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * "$.a + $.b";}</pre></blockquote>
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getExpression();

    /**
     * The runtime language to use to evaluate the expression.
     * <p>
     * Default: lambda.Runtime.NODEJS_10_X
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.Runtime getRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EvaluateExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EvaluateExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EvaluateExpressionProps> {
        private java.lang.String expression;
        private software.amazon.awscdk.services.lambda.Runtime runtime;
        private java.lang.String comment;
        private software.amazon.awscdk.core.Duration heartbeat;
        private java.lang.String inputPath;
        private software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private java.lang.String outputPath;
        private java.lang.String resultPath;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link EvaluateExpressionProps#getExpression}
         * @param expression The expression to evaluate. This parameter is required.
         *                   The expression may contain state paths.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expression(java.lang.String expression) {
            this.expression = expression;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getRuntime}
         * @param runtime The runtime language to use to evaluate the expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.core.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link EvaluateExpressionProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EvaluateExpressionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EvaluateExpressionProps build() {
            return new Jsii$Proxy(expression, runtime, comment, heartbeat, inputPath, integrationPattern, outputPath, resultPath, timeout);
        }
    }

    /**
     * An implementation for {@link EvaluateExpressionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluateExpressionProps {
        private final java.lang.String expression;
        private final software.amazon.awscdk.services.lambda.Runtime runtime;
        private final java.lang.String comment;
        private final software.amazon.awscdk.core.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.expression = this.jsiiGet("expression", java.lang.String.class);
            this.runtime = this.jsiiGet("runtime", software.amazon.awscdk.services.lambda.Runtime.class);
            this.comment = this.jsiiGet("comment", java.lang.String.class);
            this.heartbeat = this.jsiiGet("heartbeat", software.amazon.awscdk.core.Duration.class);
            this.inputPath = this.jsiiGet("inputPath", java.lang.String.class);
            this.integrationPattern = this.jsiiGet("integrationPattern", software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class);
            this.outputPath = this.jsiiGet("outputPath", java.lang.String.class);
            this.resultPath = this.jsiiGet("resultPath", java.lang.String.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String expression, final software.amazon.awscdk.services.lambda.Runtime runtime, final java.lang.String comment, final software.amazon.awscdk.core.Duration heartbeat, final java.lang.String inputPath, final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern, final java.lang.String outputPath, final java.lang.String resultPath, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.expression = java.util.Objects.requireNonNull(expression, "expression is required");
            this.runtime = runtime;
            this.comment = comment;
            this.heartbeat = heartbeat;
            this.inputPath = inputPath;
            this.integrationPattern = integrationPattern;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
            this.timeout = timeout;
        }

        @Override
        public java.lang.String getExpression() {
            return this.expression;
        }

        @Override
        public software.amazon.awscdk.services.lambda.Runtime getRuntime() {
            return this.runtime;
        }

        @Override
        public java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public software.amazon.awscdk.core.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("expression", om.valueToTree(this.getExpression()));
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EvaluateExpressionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EvaluateExpressionProps.Jsii$Proxy that = (EvaluateExpressionProps.Jsii$Proxy) o;

            if (!expression.equals(that.expression)) return false;
            if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.expression.hashCode();
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
