package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Options for binding a launch target to an ECS run job task.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-10-01T01:50:03.843Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.LaunchTargetBindOptions")
@software.amazon.jsii.Jsii.Proxy(LaunchTargetBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchTargetBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Task definition to run Docker containers in Amazon ECS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinition getTaskDefinition();

    /**
     * A regional grouping of one or more container instances on which you can run tasks and services.
     * <p>
     * Default: - No cluster
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LaunchTargetBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchTargetBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchTargetBindOptions> {
        private software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition;
        private software.amazon.awscdk.services.ecs.ICluster cluster;

        /**
         * Sets the value of {@link LaunchTargetBindOptions#getTaskDefinition}
         * @param taskDefinition Task definition to run Docker containers in Amazon ECS. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTargetBindOptions#getCluster}
         * @param cluster A regional grouping of one or more container instances on which you can run tasks and services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchTargetBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchTargetBindOptions build() {
            return new Jsii$Proxy(taskDefinition, cluster);
        }
    }

    /**
     * An implementation for {@link LaunchTargetBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTargetBindOptions {
        private final software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.taskDefinition = this.jsiiGet("taskDefinition", software.amazon.awscdk.services.ecs.ITaskDefinition.class);
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition, final software.amazon.awscdk.services.ecs.ICluster cluster) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.taskDefinition = java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required");
            this.cluster = cluster;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ITaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.LaunchTargetBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchTargetBindOptions.Jsii$Proxy that = (LaunchTargetBindOptions.Jsii$Proxy) o;

            if (!taskDefinition.equals(that.taskDefinition)) return false;
            return this.cluster != null ? this.cluster.equals(that.cluster) : that.cluster == null;
        }

        @Override
        public int hashCode() {
            int result = this.taskDefinition.hashCode();
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            return result;
        }
    }
}
