package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Identifies a model that you want to host and the resources to deploy for hosting it.
 * <p>
 * EXPERIMENTAL
 * <p>
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-10-01T01:50:03.844Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.ProductionVariant")
@software.amazon.jsii.Jsii.Proxy(ProductionVariant.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ProductionVariant extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ML compute instance type.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * The name of the model that you want to host.
     * <p>
     * This is the name that you specified when creating the model.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getModelName();

    /**
     * The name of the production variant.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getVariantName();

    /**
     * The size of the Elastic Inference (EI) instance to use for the production variant.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType getAcceleratorType() {
        return null;
    }

    /**
     * Number of instances to launch initially.
     * <p>
     * Default: - 1
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInitialInstanceCount() {
        return null;
    }

    /**
     * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.
     * <p>
     * Default: - 1.0
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInitialVariantWeight() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProductionVariant}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProductionVariant}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ProductionVariant> {
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private java.lang.String modelName;
        private java.lang.String variantName;
        private software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType acceleratorType;
        private java.lang.Number initialInstanceCount;
        private java.lang.Number initialVariantWeight;

        /**
         * Sets the value of {@link ProductionVariant#getInstanceType}
         * @param instanceType The ML compute instance type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ProductionVariant#getModelName}
         * @param modelName The name of the model that you want to host. This parameter is required.
         *                  This is the name that you specified when creating the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder modelName(java.lang.String modelName) {
            this.modelName = modelName;
            return this;
        }

        /**
         * Sets the value of {@link ProductionVariant#getVariantName}
         * @param variantName The name of the production variant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder variantName(java.lang.String variantName) {
            this.variantName = variantName;
            return this;
        }

        /**
         * Sets the value of {@link ProductionVariant#getAcceleratorType}
         * @param acceleratorType The size of the Elastic Inference (EI) instance to use for the production variant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder acceleratorType(software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        /**
         * Sets the value of {@link ProductionVariant#getInitialInstanceCount}
         * @param initialInstanceCount Number of instances to launch initially.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder initialInstanceCount(java.lang.Number initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        /**
         * Sets the value of {@link ProductionVariant#getInitialVariantWeight}
         * @param initialVariantWeight Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder initialVariantWeight(java.lang.Number initialVariantWeight) {
            this.initialVariantWeight = initialVariantWeight;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProductionVariant}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ProductionVariant build() {
            return new Jsii$Proxy(instanceType, modelName, variantName, acceleratorType, initialInstanceCount, initialVariantWeight);
        }
    }

    /**
     * An implementation for {@link ProductionVariant}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProductionVariant {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.String modelName;
        private final java.lang.String variantName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType acceleratorType;
        private final java.lang.Number initialInstanceCount;
        private final java.lang.Number initialVariantWeight;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.modelName = this.jsiiGet("modelName", java.lang.String.class);
            this.variantName = this.jsiiGet("variantName", java.lang.String.class);
            this.acceleratorType = this.jsiiGet("acceleratorType", software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType.class);
            this.initialInstanceCount = this.jsiiGet("initialInstanceCount", java.lang.Number.class);
            this.initialVariantWeight = this.jsiiGet("initialVariantWeight", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.InstanceType instanceType, final java.lang.String modelName, final java.lang.String variantName, final software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType acceleratorType, final java.lang.Number initialInstanceCount, final java.lang.Number initialVariantWeight) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.modelName = java.util.Objects.requireNonNull(modelName, "modelName is required");
            this.variantName = java.util.Objects.requireNonNull(variantName, "variantName is required");
            this.acceleratorType = acceleratorType;
            this.initialInstanceCount = initialInstanceCount;
            this.initialVariantWeight = initialVariantWeight;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.String getModelName() {
            return this.modelName;
        }

        @Override
        public java.lang.String getVariantName() {
            return this.variantName;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.AcceleratorType getAcceleratorType() {
            return this.acceleratorType;
        }

        @Override
        public java.lang.Number getInitialInstanceCount() {
            return this.initialInstanceCount;
        }

        @Override
        public java.lang.Number getInitialVariantWeight() {
            return this.initialVariantWeight;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("modelName", om.valueToTree(this.getModelName()));
            data.set("variantName", om.valueToTree(this.getVariantName()));
            if (this.getAcceleratorType() != null) {
                data.set("acceleratorType", om.valueToTree(this.getAcceleratorType()));
            }
            if (this.getInitialInstanceCount() != null) {
                data.set("initialInstanceCount", om.valueToTree(this.getInitialInstanceCount()));
            }
            if (this.getInitialVariantWeight() != null) {
                data.set("initialVariantWeight", om.valueToTree(this.getInitialVariantWeight()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.ProductionVariant"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProductionVariant.Jsii$Proxy that = (ProductionVariant.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!modelName.equals(that.modelName)) return false;
            if (!variantName.equals(that.variantName)) return false;
            if (this.acceleratorType != null ? !this.acceleratorType.equals(that.acceleratorType) : that.acceleratorType != null) return false;
            if (this.initialInstanceCount != null ? !this.initialInstanceCount.equals(that.initialInstanceCount) : that.initialInstanceCount != null) return false;
            return this.initialVariantWeight != null ? this.initialVariantWeight.equals(that.initialVariantWeight) : that.initialVariantWeight == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.modelName.hashCode());
            result = 31 * result + (this.variantName.hashCode());
            result = 31 * result + (this.acceleratorType != null ? this.acceleratorType.hashCode() : 0);
            result = 31 * result + (this.initialInstanceCount != null ? this.initialInstanceCount.hashCode() : 0);
            result = 31 * result + (this.initialVariantWeight != null ? this.initialVariantWeight.hashCode() : 0);
            return result;
        }
    }
}
