package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for publishing a message to an SNS topic.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.12.0 (build 5ddc9f2)", date = "2020-10-01T01:50:03.871Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.SnsPublishProps")
@software.amazon.jsii.Jsii.Proxy(SnsPublishProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SnsPublishProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * The message you want to send.
     * <p>
     * With the exception of SMS, messages must be UTF-8 encoded strings and
     * at most 256 KB in size.
     * For SMS, each message can contain up to 140 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput getMessage();

    /**
     * The SNS topic that the task will publish to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic getTopic();

    /**
     * Send different messages for each transport protocol.
     * <p>
     * For example, you might want to send a shorter message to SMS subscribers
     * and a more verbose message to email and SQS subscribers.
     * <p>
     * Your message must be a JSON object with a top-level JSON key of
     * "default" with a value that is a string
     * You can define other top-level keys that define the message you want to
     * send to a specific transport protocol (i.e. "sqs", "email", "http", etc)
     * <p>
     * Default: false
     * <p>
     * @see https://docs.aws.amazon.com/sns/latest/api/API_Publish.html#API_Publish_RequestParameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMessagePerSubscriptionType() {
        return null;
    }

    /**
     * Used as the "Subject" line when the message is delivered to email endpoints.
     * <p>
     * This field will also be included, if present, in the standard JSON messages
     * delivered to other endpoints.
     * <p>
     * Default: - No subject
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubject() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SnsPublishProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SnsPublishProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SnsPublishProps> {
        private software.amazon.awscdk.services.stepfunctions.TaskInput message;
        private software.amazon.awscdk.services.sns.ITopic topic;
        private java.lang.Boolean messagePerSubscriptionType;
        private java.lang.String subject;
        private java.lang.String comment;
        private software.amazon.awscdk.core.Duration heartbeat;
        private java.lang.String inputPath;
        private software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private java.lang.String outputPath;
        private java.lang.String resultPath;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link SnsPublishProps#getMessage}
         * @param message The message you want to send. This parameter is required.
         *                With the exception of SMS, messages must be UTF-8 encoded strings and
         *                at most 256 KB in size.
         *                For SMS, each message can contain up to 140 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(software.amazon.awscdk.services.stepfunctions.TaskInput message) {
            this.message = message;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getTopic}
         * @param topic The SNS topic that the task will publish to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getMessagePerSubscriptionType}
         * @param messagePerSubscriptionType Send different messages for each transport protocol.
         *                                   For example, you might want to send a shorter message to SMS subscribers
         *                                   and a more verbose message to email and SQS subscribers.
         *                                   <p>
         *                                   Your message must be a JSON object with a top-level JSON key of
         *                                   "default" with a value that is a string
         *                                   You can define other top-level keys that define the message you want to
         *                                   send to a specific transport protocol (i.e. "sqs", "email", "http", etc)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messagePerSubscriptionType(java.lang.Boolean messagePerSubscriptionType) {
            this.messagePerSubscriptionType = messagePerSubscriptionType;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getSubject}
         * @param subject Used as the "Subject" line when the message is delivered to email endpoints.
         *                This field will also be included, if present, in the standard JSON messages
         *                delivered to other endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subject(java.lang.String subject) {
            this.subject = subject;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.core.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link SnsPublishProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SnsPublishProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SnsPublishProps build() {
            return new Jsii$Proxy(message, topic, messagePerSubscriptionType, subject, comment, heartbeat, inputPath, integrationPattern, outputPath, resultPath, timeout);
        }
    }

    /**
     * An implementation for {@link SnsPublishProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsPublishProps {
        private final software.amazon.awscdk.services.stepfunctions.TaskInput message;
        private final software.amazon.awscdk.services.sns.ITopic topic;
        private final java.lang.Boolean messagePerSubscriptionType;
        private final java.lang.String subject;
        private final java.lang.String comment;
        private final software.amazon.awscdk.core.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.message = this.jsiiGet("message", software.amazon.awscdk.services.stepfunctions.TaskInput.class);
            this.topic = this.jsiiGet("topic", software.amazon.awscdk.services.sns.ITopic.class);
            this.messagePerSubscriptionType = this.jsiiGet("messagePerSubscriptionType", java.lang.Boolean.class);
            this.subject = this.jsiiGet("subject", java.lang.String.class);
            this.comment = this.jsiiGet("comment", java.lang.String.class);
            this.heartbeat = this.jsiiGet("heartbeat", software.amazon.awscdk.core.Duration.class);
            this.inputPath = this.jsiiGet("inputPath", java.lang.String.class);
            this.integrationPattern = this.jsiiGet("integrationPattern", software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class);
            this.outputPath = this.jsiiGet("outputPath", java.lang.String.class);
            this.resultPath = this.jsiiGet("resultPath", java.lang.String.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.TaskInput message, final software.amazon.awscdk.services.sns.ITopic topic, final java.lang.Boolean messagePerSubscriptionType, final java.lang.String subject, final java.lang.String comment, final software.amazon.awscdk.core.Duration heartbeat, final java.lang.String inputPath, final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern, final java.lang.String outputPath, final java.lang.String resultPath, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.message = java.util.Objects.requireNonNull(message, "message is required");
            this.topic = java.util.Objects.requireNonNull(topic, "topic is required");
            this.messagePerSubscriptionType = messagePerSubscriptionType;
            this.subject = subject;
            this.comment = comment;
            this.heartbeat = heartbeat;
            this.inputPath = inputPath;
            this.integrationPattern = integrationPattern;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
            this.timeout = timeout;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.TaskInput getMessage() {
            return this.message;
        }

        @Override
        public software.amazon.awscdk.services.sns.ITopic getTopic() {
            return this.topic;
        }

        @Override
        public java.lang.Boolean getMessagePerSubscriptionType() {
            return this.messagePerSubscriptionType;
        }

        @Override
        public java.lang.String getSubject() {
            return this.subject;
        }

        @Override
        public java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public software.amazon.awscdk.core.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("message", om.valueToTree(this.getMessage()));
            data.set("topic", om.valueToTree(this.getTopic()));
            if (this.getMessagePerSubscriptionType() != null) {
                data.set("messagePerSubscriptionType", om.valueToTree(this.getMessagePerSubscriptionType()));
            }
            if (this.getSubject() != null) {
                data.set("subject", om.valueToTree(this.getSubject()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.SnsPublishProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SnsPublishProps.Jsii$Proxy that = (SnsPublishProps.Jsii$Proxy) o;

            if (!message.equals(that.message)) return false;
            if (!topic.equals(that.topic)) return false;
            if (this.messagePerSubscriptionType != null ? !this.messagePerSubscriptionType.equals(that.messagePerSubscriptionType) : that.messagePerSubscriptionType != null) return false;
            if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.message.hashCode();
            result = 31 * result + (this.topic.hashCode());
            result = 31 * result + (this.messagePerSubscriptionType != null ? this.messagePerSubscriptionType.hashCode() : 0);
            result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
