package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The overrides that should be sent to a container.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2020-12-22T12:13:27.758Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.BatchContainerOverrides")
@software.amazon.jsii.Jsii.Proxy(BatchContainerOverrides.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BatchContainerOverrides extends software.amazon.jsii.JsiiSerializable {

    /**
     * The command to send to the container that overrides the default command from the Docker image or the job definition.
     * <p>
     * Default: - No command overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The environment variables to send to the container.
     * <p>
     * You can add new environment variables, which are added to the container
     * at launch, or you can override the existing environment variables from
     * the Docker image or the job definition.
     * <p>
     * Default: - No environment overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The number of physical GPUs to reserve for the container.
     * <p>
     * The number of GPUs reserved for all containers in a job
     * should not exceed the number of available GPUs on the compute
     * resource that the job is launched on.
     * <p>
     * Default: - No GPU reservation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuCount() {
        return null;
    }

    /**
     * The instance type to use for a multi-node parallel job.
     * <p>
     * This parameter is not valid for single-node container jobs.
     * <p>
     * Default: - No instance type overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * Memory reserved for the job.
     * <p>
     * Default: - No memory overrides. The memory supplied in the job definition will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getMemory() {
        return null;
    }

    /**
     * The number of vCPUs to reserve for the container.
     * <p>
     * This value overrides the value set in the job definition.
     * <p>
     * Default: - No vCPUs overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BatchContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BatchContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BatchContainerOverrides> {
        private java.util.List<java.lang.String> command;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.Number gpuCount;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.core.Size memory;
        private java.lang.Number vcpus;

        /**
         * Sets the value of {@link BatchContainerOverrides#getCommand}
         * @param command The command to send to the container that overrides the default command from the Docker image or the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link BatchContainerOverrides#getEnvironment}
         * @param environment The environment variables to send to the container.
         *                    You can add new environment variables, which are added to the container
         *                    at launch, or you can override the existing environment variables from
         *                    the Docker image or the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BatchContainerOverrides#getGpuCount}
         * @param gpuCount The number of physical GPUs to reserve for the container.
         *                 The number of GPUs reserved for all containers in a job
         *                 should not exceed the number of available GPUs on the compute
         *                 resource that the job is launched on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuCount(java.lang.Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        /**
         * Sets the value of {@link BatchContainerOverrides#getInstanceType}
         * @param instanceType The instance type to use for a multi-node parallel job.
         *                     This parameter is not valid for single-node container jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link BatchContainerOverrides#getMemory}
         * @param memory Memory reserved for the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(software.amazon.awscdk.core.Size memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link BatchContainerOverrides#getVcpus}
         * @param vcpus The number of vCPUs to reserve for the container.
         *              This value overrides the value set in the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcpus(java.lang.Number vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BatchContainerOverrides}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BatchContainerOverrides build() {
            return new Jsii$Proxy(command, environment, gpuCount, instanceType, memory, vcpus);
        }
    }

    /**
     * An implementation for {@link BatchContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchContainerOverrides {
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.Number gpuCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.core.Size memory;
        private final java.lang.Number vcpus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gpuCount = software.amazon.jsii.Kernel.get(this, "gpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class));
            this.vcpus = software.amazon.jsii.Kernel.get(this, "vcpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.util.List<java.lang.String> command, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.Number gpuCount, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final software.amazon.awscdk.core.Size memory, final java.lang.Number vcpus) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = command;
            this.environment = environment;
            this.gpuCount = gpuCount;
            this.instanceType = instanceType;
            this.memory = memory;
            this.vcpus = vcpus;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.Number getGpuCount() {
            return this.gpuCount;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.core.Size getMemory() {
            return this.memory;
        }

        @Override
        public final java.lang.Number getVcpus() {
            return this.vcpus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getGpuCount() != null) {
                data.set("gpuCount", om.valueToTree(this.getGpuCount()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getMemory() != null) {
                data.set("memory", om.valueToTree(this.getMemory()));
            }
            if (this.getVcpus() != null) {
                data.set("vcpus", om.valueToTree(this.getVcpus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.BatchContainerOverrides"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BatchContainerOverrides.Jsii$Proxy that = (BatchContainerOverrides.Jsii$Proxy) o;

            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.gpuCount != null ? !this.gpuCount.equals(that.gpuCount) : that.gpuCount != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
            return this.vcpus != null ? this.vcpus.equals(that.vcpus) : that.vcpus == null;
        }

        @Override
        public final int hashCode() {
            int result = this.command != null ? this.command.hashCode() : 0;
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.gpuCount != null ? this.gpuCount.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
            return result;
        }
    }
}
