package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * (experimental) Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-14T21:02:43.042Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.ResourceConfig")
@software.amazon.jsii.Jsii.Proxy(ResourceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ResourceConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The number of ML compute instances to use.
     * <p>
     * Default: 1 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

    /**
     * (experimental) ML compute instance type.
     * <p>
     * Default: is the 'm4.xlarge' instance type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * (experimental) Size of the ML storage volume that you want to provision.
     * <p>
     * Default: 10 GB EBS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Size getVolumeSize();

    /**
     * (experimental) KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
     * <p>
     * Default: - Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getVolumeEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceConfig> {
        private java.lang.Number instanceCount;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.core.Size volumeSize;
        private software.amazon.awscdk.services.kms.IKey volumeEncryptionKey;

        /**
         * Sets the value of {@link ResourceConfig#getInstanceCount}
         * @param instanceCount The number of ML compute instances to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceCount(java.lang.Number instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getInstanceType}
         * @param instanceType ML compute instance type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getVolumeSize}
         * @param volumeSize Size of the ML storage volume that you want to provision. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumeSize(software.amazon.awscdk.core.Size volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getVolumeEncryptionKey}
         * @param volumeEncryptionKey KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumeEncryptionKey(software.amazon.awscdk.services.kms.IKey volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ResourceConfig build() {
            return new Jsii$Proxy(instanceCount, instanceType, volumeSize, volumeEncryptionKey);
        }
    }

    /**
     * An implementation for {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceConfig {
        private final java.lang.Number instanceCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.core.Size volumeSize;
        private final software.amazon.awscdk.services.kms.IKey volumeEncryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class));
            this.volumeEncryptionKey = software.amazon.jsii.Kernel.get(this, "volumeEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number instanceCount, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final software.amazon.awscdk.core.Size volumeSize, final software.amazon.awscdk.services.kms.IKey volumeEncryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceCount = java.util.Objects.requireNonNull(instanceCount, "instanceCount is required");
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.volumeSize = java.util.Objects.requireNonNull(volumeSize, "volumeSize is required");
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        @Override
        public final java.lang.Number getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.core.Size getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getVolumeEncryptionKey() {
            return this.volumeEncryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
            if (this.getVolumeEncryptionKey() != null) {
                data.set("volumeEncryptionKey", om.valueToTree(this.getVolumeEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.ResourceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceConfig.Jsii$Proxy that = (ResourceConfig.Jsii$Proxy) o;

            if (!instanceCount.equals(that.instanceCount)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (!volumeSize.equals(that.volumeSize)) return false;
            return this.volumeEncryptionKey != null ? this.volumeEncryptionKey.equals(that.volumeEncryptionKey) : that.volumeEncryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceCount.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.volumeSize.hashCode());
            result = 31 * result + (this.volumeEncryptionKey != null ? this.volumeEncryptionKey.hashCode() : 0);
            return result;
        }
    }
}
